/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.io.Serializable;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer
implements Serializable {
    static final Logger logger = LoggerFactory.getLogger(Timer.class.getName());
    private static final long serialVersionUID = 1L;
    protected int count;
    protected long time = 0L;
    protected long lastTime = 0L;
    protected long maxTime = 0L;
    protected long minTime = Long.MAX_VALUE;
    protected long t_start = 0L;
    protected boolean started = false;

    protected Timer() {
    }

    public String implementationName() {
        return "ibis.util.Timer";
    }

    public synchronized void add(Timer t) {
        this.time += t.time;
        this.count += t.count;
    }

    public synchronized void add(long t, int cnt) {
        this.time += t * 1000L;
        this.count += cnt;
    }

    public double accuracy() {
        return 1.0E-9;
    }

    public long currentTimeNanos() {
        return System.nanoTime();
    }

    public void reset() {
        this.time = 0L;
        this.count = 0;
    }

    public double totalTimeVal() {
        long cur_time = 0L;
        if (this.started) {
            cur_time = System.nanoTime() - this.t_start;
        }
        return (double)(this.time + cur_time) / 1000.0;
    }

    public String totalTime() {
        return Timer.format(this.totalTimeVal());
    }

    public double averageTimeVal() {
        if (this.count > 0) {
            return (double)this.time / ((double)this.count * 1000.0);
        }
        return 0.0;
    }

    public String averageTime() {
        return Timer.format(this.averageTimeVal());
    }

    public double lastTimeVal() {
        return (double)this.lastTime / 1000.0;
    }

    public double maxTimeVal() {
        return (double)this.maxTime / 1000.0;
    }

    public double minTimeVal() {
        return (double)this.minTime / 1000.0;
    }

    public String lastTime() {
        return Timer.format(this.lastTimeVal());
    }

    public String maxTime() {
        return Timer.format(this.maxTimeVal());
    }

    public String minTime() {
        return Timer.format(this.minTimeVal());
    }

    public int nrTimes() {
        return this.count;
    }

    public void start() {
        if (this.started) {
            logger.error("Timer started twice!", new Error("Timer started twice"));
        }
        this.started = true;
        this.t_start = System.nanoTime();
    }

    public void stop() {
        if (!this.started) {
            logger.error("Timer stopped, but not started!", new Error("Timer stopped, but not started!"));
        }
        this.lastTime = System.nanoTime() - this.t_start;
        this.time += this.lastTime;
        if (this.lastTime > this.maxTime) {
            this.maxTime = this.lastTime;
        }
        if (this.lastTime < this.minTime) {
            this.minTime = this.lastTime;
        }
        ++this.count;
        this.started = false;
    }

    public static String format(double micros) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        nf.setGroupingUsed(false);
        if (micros <= 0.0) {
            return "  0.000  s";
        }
        if (micros < 1.0) {
            double nanos = micros * 1000.0;
            if (nanos < 10.0) {
                return "  " + nf.format(nanos) + " ns";
            }
            if (nanos < 100.0) {
                return " " + nf.format(nanos) + " ns";
            }
            return nf.format(nanos) + " ns";
        }
        if (micros < 1000.0) {
            if (micros < 10.0) {
                return "  " + nf.format(micros) + " us";
            }
            if (micros < 100.0) {
                return " " + nf.format(micros) + " us";
            }
            return nf.format(micros) + " us";
        }
        if (micros < 1000000.0) {
            double millis = micros / 1000.0;
            if (millis < 10.0) {
                return "  " + nf.format(millis) + " ms";
            }
            if (millis < 100.0) {
                return " " + nf.format(millis) + " ms";
            }
            return nf.format(millis) + " ms";
        }
        double secs = micros / 1000000.0;
        if (secs < 10.0) {
            return "  " + nf.format(secs) + "  s";
        }
        if (secs < 100.0) {
            return " " + nf.format(secs) + "  s";
        }
        return nf.format(secs) + "  s";
    }

    public static Timer createTimer(String impl) {
        try {
            Class<?> c = Class.forName(impl);
            return (Timer)c.newInstance();
        }
        catch (Throwable t) {
            System.err.println("Warning could not create timer " + impl + ", falling back to default");
            return Timer.createTimer();
        }
    }

    public static Timer createTimer() {
        try {
            Class<?> c = null;
            c = Class.forName("ibis.util.nativeCode.Rdtsc");
            return (Timer)c.newInstance();
        }
        catch (Throwable t) {
            return new Timer();
        }
    }

    public static void main(String[] args) {
        int n = 1000000;
        if (args.length > 0) {
            n = Integer.parseInt(args[0]);
        }
        Timer t = Timer.createTimer();
        for (int i = 0; i < n; ++i) {
            t.start();
            t.stop();
        }
        System.err.println("Timer(" + n + ") per call " + t.averageTime());
    }
}

