/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.TimePeriod;
import org.gridlab.gat.URI;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.HardwareResource;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.Reservation;
import org.gridlab.gat.resources.Resource;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.ResourceDescription;
import org.gridlab.gat.resources.SoftwareDescription;

public abstract class ResourceBrokerCpi
implements ResourceBroker {
    protected GATContext gatContext;
    protected URI brokerURI;

    public static Map<String, Boolean> getSupportedCapabilities() {
        HashMap<String, Boolean> capabilities = new HashMap<String, Boolean>();
        capabilities.put("beginMultiJob", false);
        capabilities.put("endMultiJob", false);
        capabilities.put("findResources", false);
        capabilities.put("reserveResource", false);
        capabilities.put("submitJob", false);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = new Preferences();
        preferences.put("job.stop.poststage", (Object)"true");
        preferences.put("job.stop.on.exit", (Object)"true");
        return preferences;
    }

    protected ResourceBrokerCpi(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        this.gatContext = gatContext;
        this.brokerURI = brokerURI;
        if (brokerURI == null) {
            throw new GATObjectCreationException("brokerURI is null");
        }
    }

    public void beginMultiJob() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Job endMultiJob() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<HardwareResource> findResources(ResourceDescription resourceDescription) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Reservation reserveResource(Resource resource, TimePeriod timePeriod) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Reservation reserveResource(ResourceDescription resourceDescription, TimePeriod timePeriod) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public final Job submitJob(AbstractJobDescription description) throws GATInvocationException {
        return this.submitJob(description, null, null);
    }

    public Job submitJob(AbstractJobDescription description, MetricListener listener, String metricName) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public final Job[] submitJob(JobDescription[] description) throws GATInvocationException {
        return this.submitJob(description, null, null);
    }

    public Job[] submitJob(JobDescription[] description, MetricListener listener, String metricName) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected String getExecutable(JobDescription description) throws GATInvocationException {
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        String path = sd.getExecutable();
        if (path == null) {
            throw new GATInvocationException("The Job description does not contain an executable");
        }
        return path;
    }

    protected int getIntAttribute(JobDescription description, String name, int defaultVal) {
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            return defaultVal;
        }
        return sd.getIntAttribute(name, defaultVal);
    }

    protected long getLongAttribute(JobDescription description, String name, long defaultVal) {
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            return defaultVal;
        }
        return sd.getLongAttribute(name, defaultVal);
    }

    protected String getStringAttribute(JobDescription description, String name, String defaultVal) {
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            return defaultVal;
        }
        return sd.getStringAttribute(name, defaultVal);
    }

    protected boolean getBooleanAttribute(JobDescription description, String name, boolean defaultVal) {
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            return defaultVal;
        }
        return sd.getBooleanAttribute(name, defaultVal);
    }

    protected String[] getArgumentsArray(JobDescription description) throws GATInvocationException {
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        return sd.getArguments();
    }

    protected String getArguments(JobDescription description) throws GATInvocationException {
        String[] arguments = this.getArgumentsArray(description);
        String argString = "";
        if (arguments == null) {
            return "";
        }
        for (int i = 0; i < arguments.length; ++i) {
            argString = argString + " " + arguments[i];
        }
        return argString;
    }

    protected String getHostname() {
        return this.brokerURI.getHost();
    }

    protected String getAuthority() {
        return this.brokerURI.getAuthority();
    }

    protected String getScheme() {
        return this.brokerURI.getScheme();
    }

    public String toString() {
        return this.brokerURI.toString();
    }
}

