/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import org.gridlab.gat.GAT;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJob;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.WrapperSoftwareDescription;

public class ResourceBrokerWrapperJobExample {
    public static void main(String[] args) throws Exception {
        new ResourceBrokerWrapperJobExample().start();
    }

    public void start() throws Exception {
        WrapperSoftwareDescription wsd = new WrapperSoftwareDescription();
        wsd.setStdout(GAT.createFile((String)"wrapper.stdout"));
        wsd.setStderr(GAT.createFile((String)"wrapper.stderr"));
        wsd.setExecutable("/usr/local/package/jdk1.6.0/bin/java");
        wsd.setGATLocation(System.getenv("user.home") + "/JavaGatVersions/JavaGAT-2.0-rc2");
        WrapperJobDescription wjd = new WrapperJobDescription(wsd);
        JobDescription[] wrappedJobDescriptions = new JobDescription[30];
        for (int i = 0; i < wrappedJobDescriptions.length; ++i) {
            SoftwareDescription sd = new SoftwareDescription();
            sd.setExecutable("/bin/sleep");
            sd.setArguments(new String[]{"" + (int)(30.0 * Math.random())});
            sd.addPreStagedFile(GAT.createFile((String)"largefile"));
            sd.setStdout(GAT.createFile((String)("stdout." + i)));
            Preferences preferences = new Preferences();
            preferences.put("resourcebroker.adaptor.name", (Object)"local");
            wrappedJobDescriptions[i] = new JobDescription(sd);
            wjd.add(wrappedJobDescriptions[i], new URI("any://localhost"), preferences);
        }
        Preferences wrapperPreferences = new Preferences();
        wrapperPreferences.put("resourcebroker.adaptor.name", (Object)"globus");
        ResourceBroker broker = GAT.createResourceBroker((Preferences)wrapperPreferences, (URI)new URI("any://fs0.das3.cs.vu.nl/jobmanager-sge"));
        WrapperJob[] wrapperJobs = new WrapperJob[10];
        for (int i = 0; i < wrapperJobs.length; ++i) {
            wrapperJobs[i] = (WrapperJob)broker.submitJob((AbstractJobDescription)wjd);
        }
        boolean allwrappersstopped = false;
        while (!allwrappersstopped) {
            allwrappersstopped = true;
            for (int i = 0; i < wrapperJobs.length; ++i) {
                System.out.print(wrapperJobs[i].getState().toString().substring(0, 5) + "\t");
                allwrappersstopped &= wrapperJobs[i].getState() == Job.JobState.STOPPED;
            }
            System.out.println();
            System.out.println("-----");
            for (int j = 0; j < wrappedJobDescriptions.length; ++j) {
                for (int i = 0; i < wrapperJobs.length; ++i) {
                    System.out.print(wrapperJobs[i].getJob(wrappedJobDescriptions[j]).getState().toString().substring(0, 5) + "\t");
                }
                System.out.println();
            }
            System.out.println();
            Thread.sleep(1000L);
        }
        GAT.end();
    }
}

