/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.options;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdateUserOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String name;
    private String email;
    private String password;
    private boolean enabled;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UpdateUserOptions) {
            UpdateUserOptions other = (UpdateUserOptions)UpdateUserOptions.class.cast(object);
            return Objects.equal(this.name, other.name) && Objects.equal(this.email, other.email) && Objects.equal(this.enabled, other.enabled) && Objects.equal(this.password, other.password);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.email, this.enabled, this.password);
    }

    protected Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = Objects.toStringHelper("").omitNullValues();
        toString.add("name", this.name);
        toString.add("email", this.email);
        toString.add("password", this.password);
        toString.add("enabled", (Object)this.enabled);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest user = new ServerRequest();
        if (this.email != null) {
            user.email = this.email;
        }
        if (this.name != null) {
            user.name = this.name;
        }
        if (this.password != null) {
            user.password = this.password;
        }
        user.enabled = this.enabled;
        return this.bindToRequest(request, ImmutableMap.of("user", user));
    }

    public String getName() {
        return this.name;
    }

    public UpdateUserOptions name(String name) {
        this.name = name;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public UpdateUserOptions password(String password) {
        this.password = password;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public UpdateUserOptions email(String email) {
        this.email = email;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public UpdateUserOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static UpdateUserOptions name(String name) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.name(name);
        }

        public static UpdateUserOptions email(String email) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.email(email);
        }

        public static UpdateUserOptions enabled(boolean enabled) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.enabled(enabled);
        }

        public static UpdateUserOptions password(String password) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.password(password);
        }
    }

    static class ServerRequest {
        String name;
        String email;
        String password;
        boolean enabled;

        ServerRequest() {
        }
    }
}

