/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;

public class RunNodesException
extends Exception {
    private final String group;
    private final int count;
    private final Template template;
    private final Set<? extends NodeMetadata> successfulNodes;
    private final Map<? extends NodeMetadata, ? extends Throwable> failedNodes;
    private final Map<?, Exception> executionExceptions;

    public RunNodesException(String group, int count, Template template, Set<? extends NodeMetadata> successfulNodes, Map<?, Exception> executionExceptions, Map<? extends NodeMetadata, ? extends Throwable> failedNodes) {
        super(String.format("error running %d node%s group(%s) location(%s) image(%s) size(%s) options(%s)%n%s%n%s", count, count > 1 ? "s" : "", group, template.getLocation().getId(), template.getImage().getProviderId(), template.getHardware().getProviderId(), template.getOptions(), ComputeServiceUtils.createExecutionErrorMessage(executionExceptions), ComputeServiceUtils.createNodeErrorMessage(failedNodes)));
        this.group = group;
        this.count = count;
        this.template = template;
        this.successfulNodes = successfulNodes;
        this.failedNodes = failedNodes;
        this.executionExceptions = executionExceptions;
    }

    public Set<? extends NodeMetadata> getSuccessfulNodes() {
        return this.successfulNodes;
    }

    public Map<?, ? extends Throwable> getExecutionErrors() {
        return this.executionExceptions;
    }

    public Map<? extends NodeMetadata, ? extends Throwable> getNodeErrors() {
        return this.failedNodes;
    }

    public String getGroup() {
        return this.group;
    }

    public int getCount() {
        return this.count;
    }

    public Template getTemplate() {
        return this.template;
    }
}

