/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.monitor.impl;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.util.ResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeMonitor
implements Runnable {
    private static final boolean monitorEnabled = System.getProperty("compss.monitor") != null && !System.getProperty("compss.monitor").equals("0");
    private static final String monitorDirPath;
    private static final Logger logger;
    private static final String ERROR_GENERATING_DATA = "Error generating monitoring data";
    private TaskDispatcher TD;
    private AccessProcessor AP;
    private GraphGenerator GM;
    private long sleepTime;
    private boolean keepRunning;
    private boolean running;
    private Thread monitor;
    String installDir;

    public RuntimeMonitor(AccessProcessor AP, TaskDispatcher TD, GraphGenerator GM, long sleepTime) {
        this.TD = TD;
        this.AP = AP;
        this.GM = GM;
        this.keepRunning = true;
        this.sleepTime = sleepTime;
        this.installDir = System.getenv().get("COMPSS_HOME");
        this.monitor = new Thread(this);
        this.monitor.setName("Monitor Thread");
        this.monitor.start();
    }

    @Override
    public void run() {
        this.running = true;
        while (this.keepRunning) {
            try {
                this.getXMLTaskState();
                this.printCurrentGraph();
                this.TD.printCurrentState();
                ResourceManager.printResourcesState();
                Thread.sleep(this.sleepTime);
            }
            catch (IOException ioe) {
                logger.error(ERROR_GENERATING_DATA, (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                logger.error(ERROR_GENERATING_DATA, (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        this.running = false;
    }

    public void shutdown() {
        this.keepRunning = false;
        try {
            while (this.running) {
                Thread.sleep(this.sleepTime);
            }
            this.getXMLTaskState();
            this.printCurrentGraph();
        }
        catch (IOException | InterruptedException ioe) {
            logger.error(ERROR_GENERATING_DATA, (Throwable)ioe);
        }
        if (!new File(monitorDirPath + "monitor.xml").delete()) {
            logger.error("Error clearing monitor.xml execution files");
        }
    }

    private void getXMLTaskState() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"").append(this.installDir).append("/xml/monitor/monitor.xsl\"?>").append("\n");
        sb.append("<COMPSsState>").append("\n");
        sb.append(this.AP.getCurrentTaskState());
        sb.append(this.TD.getCurrentMonitoringData());
        sb.append("</COMPSsState>");
        BufferedWriter fw = new BufferedWriter(new FileWriter(monitorDirPath + "COMPSs_state.xml"));
        fw.write(sb.toString());
        fw.close();
        fw = null;
    }

    private void printCurrentGraph() {
        BufferedWriter graph = this.GM.getAndOpenCurrentGraph();
        this.TD.printCurrentGraph(graph);
        this.GM.closeCurrentGraph();
    }

    public static String getMonitorDirPath() {
        return monitorDirPath;
    }

    public static boolean isEnabled() {
        return monitorEnabled;
    }

    static {
        logger = LogManager.getLogger("es.bsc.compss.Components");
        monitorDirPath = GraphGenerator.getMonitorDirPath();
    }
}

