/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sftpTrilead;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.cpi.FileCpi;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadConnection;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadHostVerifier;
import org.gridlab.gat.io.cpi.sftpTrilead.SftpTrileadSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpTrileadFileAdaptor
extends FileCpi {
    protected static Logger logger = LoggerFactory.getLogger(SftpTrileadFileAdaptor.class);
    static final int SSH_PORT = 22;
    static final boolean USE_CLIENT_CACHING = true;
    private final SftpTrileadHostVerifier verifier;
    private static Hashtable<String, SftpTrileadConnection> clienttable = new Hashtable();
    private boolean haveAttrs;
    private SFTPv3FileAttributes attrs;
    private String[] client2serverCiphers;
    private String[] server2clientCiphers;
    private boolean tcpNoDelay;
    private URI fixedURI;
    private boolean localFile;

    public static String getDescription() {
        return "The SftpTrilead File Adaptor implements the File object using the SFTP support of the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileCpi.getSupportedCapabilities();
        capabilities.put("createNewFile", true);
        capabilities.put("copy", true);
        capabilities.put("delete", true);
        capabilities.put("exists", true);
        capabilities.put("isDirectory", true);
        capabilities.put("isFile", true);
        capabilities.put("lastModified", true);
        capabilities.put("length", true);
        capabilities.put("list", true);
        capabilities.put("mkdir", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = FileCpi.getSupportedPreferences();
        preferences.put("sftptrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sftptrilead.noHostKeyChecking", (Object)"true");
        preferences.put("sftptrilead.cipher.client2server", (Object)"<sftp default>");
        preferences.put("sftptrilead.cipher.server2client", (Object)"<sftp default>");
        preferences.put("sftptrilead.tcp.nodelay", (Object)"true");
        preferences.put("sftptrilead.connect.timeout", (Object)"5000");
        preferences.put("sftptrilead.kex.timeout", (Object)"5000");
        return preferences;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sftptrilead", "sftp", "file", ""};
    }

    public static void end() {
        Collection<SftpTrileadConnection> connections = clienttable.values();
        for (SftpTrileadConnection conn : connections) {
            try {
                SftpTrileadFileAdaptor.doWorkCloseConnection(conn);
            }
            catch (Throwable throwable) {}
        }
    }

    public SftpTrileadFileAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException {
        super(gatContext, location);
        Preferences p = gatContext.getPreferences();
        boolean noHostKeyChecking = ((String)p.get("sftptrilead.noHostKeyChecking", (Object)"true")).equalsIgnoreCase("true");
        boolean strictHostKeyChecking = ((String)p.get("sftptrilead.strictHostKeyChecking", (Object)"false")).equalsIgnoreCase("true");
        String client2serverCipherString = (String)p.get("sftptrilead.cipher.client2server");
        this.client2serverCiphers = client2serverCipherString == null ? null : client2serverCipherString.split(",");
        String server2clientCipherString = (String)p.get("sftptrilead.cipher.server2client");
        this.server2clientCiphers = server2clientCipherString == null ? null : server2clientCipherString.split(",");
        this.tcpNoDelay = ((String)p.get("sftptrilead.tcp.nodelay", (Object)"true")).equalsIgnoreCase("true");
        this.verifier = new SftpTrileadHostVerifier(false, strictHostKeyChecking, noHostKeyChecking);
        this.fixedURI = SftpTrileadFileAdaptor.fixURI((URI)location, null);
        if (this.fixedURI.isCompatible("file") && this.fixedURI.refersToLocalHost()) {
            this.localFile = true;
        }
    }

    private static String getClientKey(URI hostURI, Preferences prefs) {
        return hostURI.resolveHost() + ":" + hostURI.getPort(22) + "-" + prefs;
    }

    private static synchronized SftpTrileadConnection getFromCache(String key) {
        SftpTrileadConnection client = null;
        if (clienttable.containsKey(key)) {
            client = clienttable.remove(key);
        }
        return client;
    }

    private static synchronized boolean putInCache(String key, SftpTrileadConnection c) {
        if (!clienttable.containsKey(key)) {
            clienttable.put(key, c);
            return true;
        }
        return false;
    }

    private SftpTrileadConnection openConnection() throws GATInvocationException {
        return SftpTrileadFileAdaptor.getConnection(this.gatContext, this.location, this.verifier, this.client2serverCiphers, this.server2clientCiphers, this.tcpNoDelay);
    }

    public static SftpTrileadConnection getConnection(GATContext gatContext, URI location, SftpTrileadHostVerifier verifier, String[] client2serverCiphers, String[] server2clientCiphers, boolean tcpNoDelay) throws GATInvocationException {
        SftpTrileadConnection c = null;
        String key = SftpTrileadFileAdaptor.getClientKey(location, gatContext.getPreferences());
        c = SftpTrileadFileAdaptor.getFromCache(key);
        if (c == null) {
            c = SftpTrileadFileAdaptor.doWorkcreateConnection(gatContext, location, verifier, client2serverCiphers, server2clientCiphers, tcpNoDelay);
        }
        return c;
    }

    private static synchronized SftpTrileadConnection doWorkcreateConnection(GATContext gatContext, URI location, ServerHostKeyVerifier verifier, String[] client2serverCiphers, String[] server2clientCiphers, boolean tcpNoDelay) throws GATInvocationException {
        SftpTrileadConnection res = new SftpTrileadConnection();
        res.remoteMachine = location;
        int port = location.getPort();
        if (port == -1) {
            port = 22;
        }
        try {
            res.userInfo = SftpTrileadSecurityUtils.getSftpCredential(gatContext, "sftpTrilead", location, port);
        }
        catch (CouldNotInitializeCredentialException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        catch (CredentialExpiredException e2) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e2);
        }
        res.connection = new Connection(location.resolveHost(), port);
        int connectTimeout = 5000;
        String connectTimeoutString = (String)gatContext.getPreferences().get("sftptrilead.connect.timeout");
        if (connectTimeoutString != null) {
            try {
                connectTimeout = Integer.parseInt(connectTimeoutString);
            }
            catch (Throwable t) {
                logger.info("'sftptrilead.connect.timeout' set, but could not be parsed: " + t);
            }
        }
        int kexTimeout = 5000;
        String kexTimeoutString = (String)gatContext.getPreferences().get("sftptrilead.kex.timeout");
        if (kexTimeoutString != null) {
            try {
                kexTimeout = Integer.parseInt(kexTimeoutString);
            }
            catch (Throwable t) {
                logger.info("'sftptrilead.kex.timeout' set, but could not be parsed: " + t);
            }
        }
        try {
            res.connection.connect(verifier, connectTimeout, kexTimeout);
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        boolean authenticated = false;
        try {
            if (res.userInfo.password != null && res.connection.isAuthMethodAvailable(res.userInfo.username, "password")) {
                authenticated = res.connection.authenticateWithPassword(res.userInfo.username, res.userInfo.password);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!authenticated && res.userInfo.defaultContext) {
            try {
                authenticated = res.connection.authenticateWithPublicKey(res.userInfo.username);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!authenticated) {
            try {
                authenticated = res.connection.authenticateWithPublicKey(res.userInfo.username, res.userInfo.privateKey, res.userInfo.password);
            }
            catch (IOException e) {
                res.connection.close();
                throw new GATInvocationException("sftpTrilead", (Throwable)e);
            }
        }
        if (!authenticated) {
            throw new GATInvocationException("Unable to authenticate");
        }
        try {
            if (client2serverCiphers != null) {
                res.connection.setClient2ServerCiphers(client2serverCiphers);
            }
            if (server2clientCiphers != null) {
                res.connection.setServer2ClientCiphers(server2clientCiphers);
            }
            res.connection.setTCPNoDelay(tcpNoDelay);
            res.sftpClient = new SFTPv3Client(res.connection);
        }
        catch (IOException e) {
            res.connection.close();
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        return res;
    }

    public static void closeConnection(SftpTrileadConnection c, Preferences prefs) throws GATInvocationException {
        block5: {
            if (c == null) {
                return;
            }
            String key = SftpTrileadFileAdaptor.getClientKey(c.remoteMachine, prefs);
            if (!SftpTrileadFileAdaptor.putInCache(key, c)) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("closing client");
                    }
                    SftpTrileadFileAdaptor.doWorkCloseConnection(c);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("end of sftpTrilead adaptor, closing client, got exception (ignoring): " + e);
                }
            }
        }
    }

    private static void doWorkCloseConnection(SftpTrileadConnection c) {
        c.sftpClient.close();
        c.sftpClient = null;
        c.connection.close();
        c.connection = null;
    }

    private SFTPv3FileAttributes getAttrs() throws GATInvocationException {
        block9: {
            if (!this.haveAttrs) {
                SftpTrileadConnection c = this.openConnection();
                try {
                    this.attrs = c.sftpClient.stat(this.fixedURI.getPath());
                }
                catch (SFTPException x) {
                    if (x.getServerErrorCode() == 2) {
                        break block9;
                    }
                    throw new GATInvocationException("sftpTrilead", (Throwable)x);
                }
                catch (IOException e) {
                    throw new GATInvocationException("sftpTrilead", (Throwable)e);
                }
                finally {
                    SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
                }
            }
        }
        this.haveAttrs = true;
        return this.attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdir() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        if (a != null) {
            return false;
        }
        SftpTrileadConnection c = this.openConnection();
        this.haveAttrs = false;
        try {
            c.sftpClient.mkdir(this.fixedURI.getPath(), 448);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
        }
        return true;
    }

    public boolean createNewFile() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        if (a != null) {
            return false;
        }
        this.haveAttrs = false;
        SftpTrileadConnection c = this.openConnection();
        try {
            c.sftpClient.closeFile(c.sftpClient.createFileTruncate(this.location.getPath()));
        }
        catch (IOException e) {
            throw new GATInvocationException("Could not create", (Throwable)e);
        }
        finally {
            SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
        }
        return true;
    }

    public long lastModified() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        if (a == null) {
            return 0L;
        }
        return a.mtime;
    }

    public boolean isDirectory() throws GATInvocationException {
        if (this.localFile) {
            java.io.File f = new java.io.File(this.location.getPath());
            boolean isDir = f.isDirectory();
            return isDir;
        }
        SFTPv3FileAttributes a = this.getAttrs();
        return a != null && a.isDirectory();
    }

    public boolean delete() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        if (a == null) {
            return false;
        }
        SftpTrileadConnection c = this.openConnection();
        try {
            if (a.isDirectory()) {
                c.sftpClient.rmdir(this.fixedURI.getPath());
            } else {
                c.sftpClient.rm(this.fixedURI.getPath());
            }
        }
        catch (IOException e) {
            if (e instanceof SFTPException && ((SFTPException)((Object)e)).getServerErrorCode() == 2) {
                boolean bl = false;
                return bl;
            }
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        finally {
            SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
        }
        this.haveAttrs = false;
        return true;
    }

    public void recursivelyDeleteDirectory() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        if (!a.isDirectory()) {
            throw new GATInvocationException("Not a directory!");
        }
        SftpTrileadConnection c = this.openConnection();
        String path = this.fixedURI.getPath();
        try {
            this.remove(c.sftpClient, path);
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        finally {
            SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
        }
    }

    private void remove(SFTPv3Client c, String path) throws IOException {
        Vector list = c.ls(path);
        for (int i = 0; i < list.size(); ++i) {
            SFTPv3DirectoryEntry entry = (SFTPv3DirectoryEntry)list.get(i);
            if (entry.filename.equals(".") || entry.filename.equals("..")) continue;
            String name = path + "/" + entry.filename;
            SFTPv3FileAttributes a = c.stat(name);
            if (a.isDirectory()) {
                this.remove(c, name);
                continue;
            }
            c.rm(name);
        }
        c.rmdir(path);
    }

    public boolean exists() throws GATInvocationException {
        return this.getAttrs() != null;
    }

    public String[] list() throws GATInvocationException {
        if (this.localFile) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            String[] l = f.list();
            return l;
        }
        SFTPv3FileAttributes a = this.getAttrs();
        if (a == null || !a.isDirectory()) {
            return null;
        }
        SftpTrileadConnection c = this.openConnection();
        try {
            Vector result = c.sftpClient.ls(this.fixedURI.getPath());
            Vector<String> newRes = new Vector<String>();
            for (int i = 0; i < result.size(); ++i) {
                SFTPv3DirectoryEntry entry = (SFTPv3DirectoryEntry)result.get(i);
                if (entry.filename.equals(".") || entry.filename.equals("..")) continue;
                newRes.add(entry.filename);
            }
            String[] res = new String[newRes.size()];
            for (int i = 0; i < newRes.size(); ++i) {
                res[i] = (String)newRes.get(i);
            }
            String[] stringArray = res;
            return stringArray;
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        finally {
            SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
        }
    }

    public boolean isFile() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        return a != null && a.isRegularFile();
    }

    public void move(URI dest) throws GATInvocationException {
        boolean destIsLocal = dest.isCompatible("file") && dest.refersToLocalHost();
        URI uri = this.toURI();
        if (logger.isDebugEnabled()) {
            logger.debug("move " + uri + " " + dest);
        }
        if (!this.localFile && !destIsLocal && uri.getScheme().equals(dest.getScheme()) && uri.getAuthority().equals(dest.getAuthority())) {
            try {
                File destFile = GAT.createFile((GATContext)this.gatContext, (URI)dest);
                if (destFile.isDirectory()) {
                    dest = dest.setPath(dest.getPath() + "/" + this.getName());
                }
            }
            catch (Throwable e) {
                throw new GATInvocationException("move", e);
            }
            SftpTrileadConnection c = this.openConnection();
            try {
                c.sftpClient.mv(this.getPath(), dest.getPath());
                this.haveAttrs = false;
                return;
            }
            catch (Throwable e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("move: got exception", e);
                }
                throw new GATInvocationException("move", e);
            }
            finally {
                SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
            }
        }
        if (this.localFile && !destIsLocal && SftpTrileadFileAdaptor.recognizedScheme((String)dest.getScheme(), (String[])SftpTrileadFileAdaptor.getSupportedSchemes())) {
            super.move(dest);
            return;
        }
        if (!this.localFile && destIsLocal) {
            super.move(dest);
            return;
        }
        throw new GATInvocationException("sftptrilead: cannot do third party move");
    }

    public long length() throws GATInvocationException {
        SFTPv3FileAttributes a = this.getAttrs();
        if (a == null) {
            return -1L;
        }
        return a.size;
    }

    public void safeCopy(URI dest) throws GATInvocationException {
        boolean destIsLocal = dest.isCompatible("file") && dest.refersToLocalHost();
        URI uri = this.toURI();
        if (this.localFile) {
            if (destIsLocal) {
                throw new GATInvocationException("sftpTrilead cannot copy local files");
            }
            if (SftpTrileadFileAdaptor.recognizedScheme((String)dest.getScheme(), (String[])SftpTrileadFileAdaptor.getSupportedSchemes())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sftpTrilead file: copy local to remote");
                }
                this.safeCopyToRemote(SftpTrileadFileAdaptor.fixURI((URI)uri, null), SftpTrileadFileAdaptor.fixURI((URI)dest, null));
                return;
            }
            throw new GATInvocationException("sftptrilead: remote scheme not recognized: " + dest.getScheme());
        }
        if (destIsLocal) {
            this.copyToLocal(SftpTrileadFileAdaptor.fixURI((URI)uri, null), SftpTrileadFileAdaptor.fixURI((URI)dest, null));
            return;
        }
        this.copy(dest);
    }

    public void copy(URI dest) throws GATInvocationException {
        boolean destIsLocal = dest.isCompatible("file") && dest.refersToLocalHost();
        URI uri = this.toURI();
        if (this.localFile) {
            if (destIsLocal) {
                throw new GATInvocationException("sftpTrilead cannot copy local files");
            }
            if (this.determineIsDirectory()) {
                SftpTrileadFileAdaptor.copyDirectory((GATContext)this.gatContext, null, (URI)uri, (URI)dest);
                return;
            }
            if (SftpTrileadFileAdaptor.recognizedScheme((String)dest.getScheme(), (String[])SftpTrileadFileAdaptor.getSupportedSchemes())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sftpTrilead file: copy local to remote");
                }
                this.copyToRemote(SftpTrileadFileAdaptor.fixURI((URI)uri, null), SftpTrileadFileAdaptor.fixURI((URI)dest, null));
                return;
            }
            throw new GATInvocationException("sftptrilead: remote scheme not recognized: " + dest.getScheme());
        }
        if (destIsLocal) {
            SFTPv3FileAttributes a = this.getAttrs();
            if (a == null) {
                throw new GATInvocationException("sftptrilead: file does not exist");
            }
            if (a.isDirectory()) {
                SftpTrileadFileAdaptor.copyDirectory((GATContext)this.gatContext, null, (URI)uri, (URI)dest);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sftpTrilead file: copy remote to local");
            }
            this.copyToLocal(SftpTrileadFileAdaptor.fixURI((URI)uri, null), SftpTrileadFileAdaptor.fixURI((URI)dest, null));
            return;
        }
        if (uri.getScheme().equals(dest.getScheme()) && uri.getAuthority().equals(dest.getAuthority())) {
            SFTPv3FileAttributes a = this.getAttrs();
            if (a == null || a.isDirectory()) {
                throw new GATInvocationException("sftptrilead: cannot do third party copy");
            }
            SftpTrileadConnection c = this.openConnection();
            try {
                int len;
                try {
                    a = c.sftpClient.stat(SftpTrileadFileAdaptor.fixURI((URI)dest, null).getPath());
                }
                catch (SFTPException x) {
                    if (x.getServerErrorCode() == 2) {
                        a = null;
                    }
                    throw new GATInvocationException("sftpTrilead", (Throwable)x);
                }
                if (a != null && !a.isRegularFile()) {
                    if (a.isDirectory()) {
                        try {
                            dest = dest.setPath(dest.getPath() + "/" + this.getName());
                        }
                        catch (Throwable e) {
                            throw new GATInvocationException("sftpTrilead", e);
                        }
                    } else {
                        throw new GATInvocationException("sftptrilead: cannot do third party copy");
                    }
                }
                SFTPv3FileHandle handleW = c.sftpClient.createFileTruncate(SftpTrileadFileAdaptor.fixURI((URI)dest, null).getPath());
                SFTPv3FileHandle handleR = c.sftpClient.openFileRO(SftpTrileadFileAdaptor.fixURI((URI)uri, null).getPath());
                long done = 0L;
                byte[] copyBuf = new byte[32768];
                while ((len = c.sftpClient.read(handleR, done, copyBuf, 0, copyBuf.length)) > 0) {
                    c.sftpClient.write(handleW, done, copyBuf, 0, len);
                    done += (long)len;
                }
                c.sftpClient.closeFile(handleR);
                c.sftpClient.closeFile(handleW);
            }
            catch (IOException e) {
                throw new GATInvocationException("sftpTrilead", (Throwable)e);
            }
            finally {
                SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
            }
            return;
        }
        throw new GATInvocationException("sftptrilead: cannot do third party copy");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyToLocal(URI src, URI dest) throws GATInvocationException {
        SftpTrileadConnection c;
        SFTPv3FileHandle handle;
        FilterOutputStream outBuf;
        block26: {
            outBuf = null;
            handle = null;
            c = null;
            try {
                int len;
                String destPath = dest.getPath();
                if (new java.io.File(destPath).isDirectory() || destPath.endsWith(java.io.File.separator)) {
                    String sourcePath = src.getPath();
                    if (sourcePath.endsWith(java.io.File.separator)) {
                        sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
                    }
                    if (sourcePath.length() > 0) {
                        int start = sourcePath.lastIndexOf(java.io.File.separator) + 1;
                        String separator = "";
                        if (!destPath.endsWith(java.io.File.separator)) {
                            separator = java.io.File.separator;
                        }
                        destPath = destPath + separator + sourcePath.substring(start);
                    }
                }
                java.io.File destinationFile = new java.io.File(destPath);
                if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") && destinationFile.getParentFile() != null) {
                    destinationFile.getParentFile().mkdirs();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("creating local file " + destinationFile);
                }
                destinationFile.createNewFile();
                FileOutputStream out = new FileOutputStream(destinationFile);
                outBuf = new BufferedOutputStream(out);
                long length = this.length();
                c = this.openConnection();
                handle = c.sftpClient.openFileRO(src.getPath());
                byte[] buf = new byte[32768];
                for (long bytesWritten = 0L; bytesWritten != length; bytesWritten += (long)len) {
                    len = c.sftpClient.read(handle, bytesWritten, buf, 0, buf.length);
                    ((BufferedOutputStream)outBuf).write(buf, 0, len);
                }
                ((BufferedOutputStream)outBuf).flush();
                if (!this.gatContext.getPreferences().containsKey("file.copytime") || !((String)this.gatContext.getPreferences().get("file.copytime")).equalsIgnoreCase("true")) break block26;
                try {
                    long l = this.lastModified();
                    if (l != 0L) {
                        destinationFile.setLastModified(l * 1000L);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                try {
                    throw new GATInvocationException("sftpTrilead", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (outBuf != null) {
                            outBuf.close();
                        }
                    }
                    catch (IOException e2) {
                        throw new GATInvocationException("sftpTrilead", (Throwable)e2);
                    }
                    try {
                        if (handle != null && c != null) {
                            c.sftpClient.closeFile(handle);
                        }
                    }
                    catch (IOException e3) {
                        throw new GATInvocationException("sftpTrilead", (Throwable)e3);
                    }
                    if (c == null) throw throwable;
                    SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
                    throw throwable;
                }
            }
        }
        try {
            if (outBuf != null) {
                outBuf.close();
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        try {
            if (handle != null && c != null) {
                c.sftpClient.closeFile(handle);
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        if (c == null) return;
        SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void safeCopyToRemote(URI src, URI dest) throws GATInvocationException {
        SFTPv3FileHandle handle = null;
        BufferedInputStream inBuf = null;
        SftpTrileadConnection c = null;
        try {
            int len;
            String sourcePath;
            FileInputStream in = new FileInputStream(src.getPath());
            inBuf = new BufferedInputStream(in);
            long length = new java.io.File(src.getPath()).length();
            c = SftpTrileadFileAdaptor.getConnection(this.gatContext, dest, this.verifier, this.client2serverCiphers, this.server2clientCiphers, this.tcpNoDelay);
            String destPath = dest.getPath();
            if (destPath.endsWith(java.io.File.separator) && (sourcePath = src.getPath()).length() > 0) {
                int start = sourcePath.lastIndexOf(java.io.File.separator) + 1;
                String separator = "";
                if (!destPath.endsWith(java.io.File.separator)) {
                    separator = java.io.File.separator;
                }
                destPath = destPath + separator + sourcePath.substring(start);
            }
            handle = c.sftpClient.createFileTruncate(destPath);
            byte[] buf = new byte[32768];
            for (long bytesWritten = 0L; bytesWritten != length; bytesWritten += (long)len) {
                len = inBuf.read(buf, 0, buf.length);
                c.sftpClient.write(handle, bytesWritten, buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                throw new GATInvocationException("sftpTrilead", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (inBuf != null) {
                        inBuf.close();
                    }
                }
                catch (IOException e2) {
                    throw new GATInvocationException("sftpTrilead", (Throwable)e2);
                }
                try {
                    if (handle != null && c != null) {
                        c.sftpClient.closeFile(handle);
                    }
                }
                catch (IOException e3) {
                    throw new GATInvocationException("sftpTrilead", (Throwable)e3);
                }
                if (c == null) throw throwable;
                SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
                throw throwable;
            }
        }
        try {
            if (inBuf != null) {
                inBuf.close();
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        try {
            if (handle != null && c != null) {
                c.sftpClient.closeFile(handle);
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        if (c == null) return;
        SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyToRemote(URI src, URI dest) throws GATInvocationException {
        SFTPv3FileHandle handle = null;
        BufferedInputStream inBuf = null;
        SftpTrileadConnection c = null;
        try {
            int len;
            File destinationParentFile;
            FileInputStream in = new FileInputStream(src.getPath());
            inBuf = new BufferedInputStream(in);
            long length = new java.io.File(src.getPath()).length();
            c = SftpTrileadFileAdaptor.getConnection(this.gatContext, dest, this.verifier, this.client2serverCiphers, this.server2clientCiphers, this.tcpNoDelay);
            String destPath = dest.getPath();
            FileInterface destFile = GAT.createFile((GATContext)this.gatContext, (URI)dest).getFileInterface();
            if (destFile.exists() && destFile.isDirectory() || destPath.endsWith(java.io.File.separator)) {
                String sourcePath = src.getPath();
                if (sourcePath.endsWith(java.io.File.separator)) {
                    sourcePath = sourcePath.substring(0, sourcePath.length() - 1);
                }
                if (sourcePath.length() > 0) {
                    int start = sourcePath.lastIndexOf(java.io.File.separator) + 1;
                    String separator = "";
                    if (!destPath.endsWith(java.io.File.separator)) {
                        separator = java.io.File.separator;
                    }
                    destPath = destPath + separator + sourcePath.substring(start);
                }
            }
            if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") && (destinationParentFile = (destFile = GAT.createFile((GATContext)this.gatContext, (String)dest.toString().replace(dest.getPath(), destPath)).getFileInterface()).getParentFile()) != null) {
                destinationParentFile.getFileInterface().mkdirs();
            }
            handle = c.sftpClient.createFileTruncate(destPath);
            byte[] buf = new byte[32768];
            for (long bytesWritten = 0L; bytesWritten != length; bytesWritten += (long)len) {
                len = inBuf.read(buf, 0, buf.length);
                c.sftpClient.write(handle, bytesWritten, buf, 0, len);
            }
        }
        catch (Exception e) {
            try {
                throw new GATInvocationException("sftpTrilead", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (inBuf != null) {
                        inBuf.close();
                    }
                }
                catch (IOException e2) {
                    throw new GATInvocationException("sftpTrilead", (Throwable)e2);
                }
                try {
                    if (handle != null && c != null) {
                        c.sftpClient.closeFile(handle);
                    }
                }
                catch (IOException e3) {
                    throw new GATInvocationException("sftpTrilead", (Throwable)e3);
                }
                if (c == null) throw throwable;
                SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
                throw throwable;
            }
        }
        try {
            if (inBuf != null) {
                inBuf.close();
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        try {
            if (handle != null && c != null) {
                c.sftpClient.closeFile(handle);
            }
        }
        catch (IOException e) {
            throw new GATInvocationException("sftpTrilead", (Throwable)e);
        }
        if (c == null) return;
        SftpTrileadFileAdaptor.closeConnection(c, this.gatContext.getPreferences());
    }
}

