/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslCertificateException;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public abstract class OpenSslContext
extends SslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslContext.class);
    private static final boolean JDK_REJECT_CLIENT_INITIATED_RENEGOTIATION = SystemPropertyUtil.getBoolean("jdk.tls.rejectClientInitiatedRenegotiation", false);
    private static final List<String> DEFAULT_CIPHERS;
    private static final Integer DH_KEY_LENGTH;
    protected static final int VERIFY_DEPTH = 10;
    protected volatile long ctx;
    long aprPool;
    private volatile int aprPoolDestroyed;
    private final List<String> unmodifiableCiphers;
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final OpenSslEngineMap engineMap = new DefaultOpenSslEngineMap();
    volatile boolean rejectRemoteInitiatedRenegotiation;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;

    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apnCfg, long sessionCacheSize, long sessionTimeout, int mode, Certificate[] keyCertChain, ClientAuth clientAuth) throws SSLException {
        this(ciphers, cipherFilter, OpenSslContext.toNegotiator(apnCfg), sessionCacheSize, sessionTimeout, mode, keyCertChain, clientAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, long sessionCacheSize, long sessionTimeout, int mode, Certificate[] keyCertChain, ClientAuth clientAuth) throws SSLException {
        ArrayList<String> convertedCiphers;
        OpenSsl.ensureAvailability();
        if (mode != 1 && mode != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.mode = mode;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        if (mode == 1) {
            this.rejectRemoteInitiatedRenegotiation = JDK_REJECT_CLIENT_INITIATED_RENEGOTIATION;
        }
        Certificate[] certificateArray = this.keyCertChain = keyCertChain == null ? null : (Certificate[])keyCertChain.clone();
        if (ciphers == null) {
            convertedCiphers = null;
        } else {
            convertedCiphers = new ArrayList<String>();
            for (String c : ciphers) {
                if (c == null) break;
                String converted = CipherSuiteConverter.toOpenSsl(c);
                if (converted != null) {
                    c = converted;
                }
                convertedCiphers.add(c);
            }
        }
        this.unmodifiableCiphers = Arrays.asList(ObjectUtil.checkNotNull(cipherFilter, "cipherFilter").filterCipherSuites(convertedCiphers, DEFAULT_CIPHERS, OpenSsl.availableCipherSuites()));
        this.apn = ObjectUtil.checkNotNull(apn, "apn");
        this.aprPool = Pool.create((long)0L);
        boolean success = false;
        try {
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                try {
                    this.ctx = SSLContext.make((long)this.aprPool, (int)31, (int)mode);
                }
                catch (Exception e) {
                    throw new SSLException("failed to create an SSL_CTX", e);
                }
                SSLContext.setOptions((long)this.ctx, (int)4095);
                SSLContext.setOptions((long)this.ctx, (int)0x1000000);
                SSLContext.setOptions((long)this.ctx, (int)0x2000000);
                SSLContext.setOptions((long)this.ctx, (int)0x400000);
                SSLContext.setOptions((long)this.ctx, (int)524288);
                SSLContext.setOptions((long)this.ctx, (int)0x100000);
                SSLContext.setOptions((long)this.ctx, (int)65536);
                SSLContext.setOptions((long)this.ctx, (int)16384);
                SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | 2));
                if (DH_KEY_LENGTH != null) {
                    SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
                }
                try {
                    SSLContext.setCipherSuite((long)this.ctx, (String)CipherSuiteConverter.toOpenSsl(this.unmodifiableCiphers));
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, e);
                }
                List<String> nextProtoList = apn.protocols();
                if (!nextProtoList.isEmpty()) {
                    String[] protocols = nextProtoList.toArray(new String[nextProtoList.size()]);
                    int selectorBehavior = OpenSslContext.opensslSelectorFailureBehavior(apn.selectorFailureBehavior());
                    switch (apn.protocol()) {
                        case NPN: {
                            SSLContext.setNpnProtos((long)this.ctx, (String[])protocols, (int)selectorBehavior);
                            break;
                        }
                        case ALPN: {
                            SSLContext.setAlpnProtos((long)this.ctx, (String[])protocols, (int)selectorBehavior);
                            break;
                        }
                        case NPN_AND_ALPN: {
                            SSLContext.setNpnProtos((long)this.ctx, (String[])protocols, (int)selectorBehavior);
                            SSLContext.setAlpnProtos((long)this.ctx, (String[])protocols, (int)selectorBehavior);
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                }
                if (sessionCacheSize > 0L) {
                    this.sessionCacheSize = sessionCacheSize;
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
                } else {
                    this.sessionCacheSize = sessionCacheSize = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
                }
                if (sessionTimeout > 0L) {
                    this.sessionTimeout = sessionTimeout;
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
                } else {
                    this.sessionTimeout = sessionTimeout = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
                }
                // ** MonitorExit[var13_12] (shouldn't be in output)
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroy();
            }
        }
        {
            return;
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior behavior) {
        switch (behavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        return new OpenSslEngine(this, alloc, peerHost, peerPort);
    }

    abstract OpenSslKeyMaterialManager keyMaterialManager();

    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc) {
        return this.newEngine(alloc, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.ctx;
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    public void setRejectRemoteInitiatedRenegotiation(boolean rejectRemoteInitiatedRenegotiation) {
        this.rejectRemoteInitiatedRenegotiation = rejectRemoteInitiatedRenegotiation;
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    @Deprecated
    public final void setTicketKeys(byte[] keys) {
        this.sessionContext().setTicketKeys(keys);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    public final long sslCtxPointer() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroy() {
        Class<OpenSslContext> clazz = OpenSslContext.class;
        synchronized (OpenSslContext.class) {
            if (this.ctx != 0L) {
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
            }
            if (this.aprPool != 0L) {
                Pool.destroy((long)this.aprPool);
                this.aprPool = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSslX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] kms) {
        for (KeyManager km : kms) {
            if (!(km instanceof X509KeyManager)) continue;
            return (X509KeyManager)km;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig config) {
        if (config == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (config.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (config.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (config.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(config);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)config.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)config.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager trustManager) {
        return PlatformDependent.javaVersion() >= 7 && trustManager instanceof X509ExtendedTrustManager;
    }

    static boolean useExtendedKeyManager(X509KeyManager keyManager) {
        return PlatformDependent.javaVersion() >= 7 && keyManager instanceof X509ExtendedKeyManager;
    }

    static void setKeyMaterial(long ctx, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword) throws SSLException {
        long keyBio = 0L;
        long keyCertChainBio = 0L;
        try {
            keyCertChainBio = OpenSslContext.toBIO(keyCertChain);
            keyBio = OpenSslContext.toBIO(key);
            SSLContext.setCertificateBio((long)ctx, (long)keyCertChainBio, (long)keyBio, (String)(keyPassword == null ? "" : keyPassword), (int)0);
            SSLContext.setCertificateChainBio((long)ctx, (long)keyCertChainBio, (boolean)false);
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException("failed to set certificate and key", e);
        }
        finally {
            if (keyBio != 0L) {
                SSL.freeBIO((long)keyBio);
            }
            if (keyCertChainBio != 0L) {
                SSL.freeBIO((long)keyCertChainBio);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(PrivateKey key) throws Exception {
        if (key == null) {
            return 0L;
        }
        ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
        PemEncoded pem = PemPrivateKey.toPEM(allocator, true, key);
        try {
            long l = OpenSslContext.toBIO(allocator, pem.retain());
            return l;
        }
        finally {
            pem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(X509Certificate ... certChain) throws Exception {
        if (certChain == null) {
            return 0L;
        }
        if (certChain.length == 0) {
            throw new IllegalArgumentException("certChain can't be empty");
        }
        ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
        PemEncoded pem = PemX509Certificate.toPEM(allocator, true, certChain);
        try {
            long l = OpenSslContext.toBIO(allocator, pem.retain());
            return l;
        }
        finally {
            pem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long toBIO(ByteBufAllocator allocator, PemEncoded pem) throws Exception {
        try {
            long l;
            ByteBuf content = pem.content();
            if (content.isDirect()) {
                long l2 = OpenSslContext.newBIO(content.retainedSlice());
                return l2;
            }
            ByteBuf buffer = allocator.directBuffer(content.readableBytes());
            try {
                buffer.writeBytes(content, content.readerIndex(), content.readableBytes());
                l = OpenSslContext.newBIO(buffer.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pem.isSensitive()) {
                        SslUtils.zeroout(buffer);
                    }
                }
                finally {
                    buffer.release();
                }
                throw throwable;
            }
            try {
                if (pem.isSensitive()) {
                    SslUtils.zeroout(buffer);
                }
            }
            finally {
                buffer.release();
            }
            return l;
        }
        finally {
            pem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf buffer) throws Exception {
        try {
            long bio = SSL.newMemBIO();
            int readable = buffer.readableBytes();
            if (SSL.writeToBIO((long)bio, (long)OpenSsl.memoryAddress(buffer), (int)readable) != readable) {
                SSL.freeBIO((long)bio);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l = bio;
            return l;
        }
        finally {
            buffer.release();
        }
    }

    static {
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        ArrayList ciphers = new ArrayList();
        Collections.addAll(ciphers, "ECDHE-RSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-SHA", "ECDHE-RSA-AES256-SHA", "AES128-GCM-SHA256", "AES128-SHA", "AES256-SHA", "DES-CBC3-SHA");
        DEFAULT_CIPHERS = Collections.unmodifiableList(ciphers);
        if (logger.isDebugEnabled()) {
            logger.debug("Default cipher suite (OpenSSL): " + ciphers);
        }
        Integer dhLen = null;
        try {
            String dhKeySize = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return SystemPropertyUtil.get("jdk.tls.ephemeralDHKeySize");
                }
            });
            if (dhKeySize != null) {
                try {
                    dhLen = Integer.parseInt(dhKeySize);
                }
                catch (NumberFormatException e) {
                    logger.debug("OpenSslContext only support -Djdk.tls.ephemeralDHKeySize={int}, but got: " + dhKeySize);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = dhLen;
    }

    private static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, OpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        @Override
        public OpenSslEngine remove(long ssl) {
            return this.engines.remove(ssl);
        }

        @Override
        public void add(OpenSslEngine engine) {
            this.engines.put(engine.sslPointer(), engine);
        }

        @Override
        public OpenSslEngine get(long ssl) {
            return this.engines.get(ssl);
        }
    }

    static abstract class AbstractCertificateVerifier
    implements CertificateVerifier {
        private final OpenSslEngineMap engineMap;

        AbstractCertificateVerifier(OpenSslEngineMap engineMap) {
            this.engineMap = engineMap;
        }

        public final int verify(long ssl, byte[][] chain, String auth) {
            X509Certificate[] peerCerts = OpenSslContext.certificates(chain);
            OpenSslEngine engine = this.engineMap.get(ssl);
            try {
                this.verify(engine, peerCerts, auth);
                return 0;
            }
            catch (Throwable cause) {
                logger.debug("verification of certificate failed", cause);
                SSLHandshakeException e = new SSLHandshakeException("General OpenSslEngine problem");
                e.initCause(cause);
                engine.handshakeException = e;
                if (cause instanceof OpenSslCertificateException) {
                    return ((OpenSslCertificateException)cause).errorCode();
                }
                if (cause instanceof CertificateExpiredException) {
                    return 10;
                }
                if (cause instanceof CertificateNotYetValidException) {
                    return 9;
                }
                if (PlatformDependent.javaVersion() >= 7 && cause instanceof CertificateRevokedException) {
                    return 23;
                }
                return 1;
            }
        }

        abstract void verify(OpenSslEngine var1, X509Certificate[] var2, String var3) throws Exception;
    }
}

