/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.config;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jclouds.logging.Logger;

public class SSLModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(HostnameVerifier.class).annotatedWith(Names.named("untrusted")).to(LogToMapHostnameVerifier.class);
        this.bind(new TypeLiteral<Supplier<SSLContext>>(){}).annotatedWith(Names.named("untrusted")).to((TypeLiteral<Supplier<SSLContext>>)new TypeLiteral<UntrustedSSLContextSupplier>(){});
    }

    @Singleton
    public static class TrustAllCerts
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    @Singleton
    public static class UntrustedSSLContextSupplier
    implements Supplier<SSLContext> {
        private final TrustAllCerts trustAllCerts;

        @Inject
        UntrustedSSLContextSupplier(TrustAllCerts trustAllCerts) {
            this.trustAllCerts = trustAllCerts;
        }

        @Override
        public SSLContext get() {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, new TrustManager[]{this.trustAllCerts}, new SecureRandom());
                return sc;
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
    }

    @Singleton
    public static class LogToMapHostnameVerifier
    implements HostnameVerifier {
        @Resource
        private Logger logger = Logger.NULL;
        private final Map<String, String> sslMap = new MapMaker().makeMap();

        @Override
        public boolean verify(String hostname, SSLSession session) {
            String oldPeerHost;
            String peerHost = session.getPeerHost();
            if (!(hostname.equals(peerHost) || (oldPeerHost = this.sslMap.get(hostname)) != null && oldPeerHost.equals(peerHost))) {
                this.logger.warn("hostname was %s while session was %s", hostname, peerHost);
                this.sslMap.put(hostname, peerHost);
            }
            return true;
        }
    }
}

