/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindSecurityGroupRuleToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/securitygroups/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface SecurityGroupApi {
    @Named(value="securityGroup:list")
    @GET
    @Path(value="/os-security-groups")
    @SelectJson(value={"security_groups"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<SecurityGroup> list();

    @Named(value="securityGroup:get")
    @GET
    @Path(value="/os-security-groups/{id}")
    @SelectJson(value={"security_group"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SecurityGroup get(@PathParam(value="id") String var1);

    @Named(value="securityGroup:create")
    @POST
    @Path(value="/os-security-groups")
    @SelectJson(value={"security_group"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"security_group\":%7B\"name\":\"{name}\",\"description\":\"{description}\"%7D%7D")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SecurityGroup createWithDescription(@PayloadParam(value="name") String var1, @PayloadParam(value="description") String var2);

    @Named(value="securityGroup:delete")
    @DELETE
    @Path(value="/os-security-groups/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="securityGroup:create")
    @POST
    @Path(value="/os-security-group-rules")
    @SelectJson(value={"security_group_rule"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindSecurityGroupRuleToJsonPayload.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SecurityGroupRule createRuleAllowingCidrBlock(@PayloadParam(value="parent_group_id") String var1, Ingress var2, @PayloadParam(value="cidr") String var3);

    @Named(value="securityGroup:create")
    @POST
    @Path(value="/os-security-group-rules")
    @SelectJson(value={"security_group_rule"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindSecurityGroupRuleToJsonPayload.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SecurityGroupRule createRuleAllowingSecurityGroupId(@PayloadParam(value="parent_group_id") String var1, Ingress var2, @PayloadParam(value="group_id") String var3);

    @Named(value="securityGroup:delete")
    @DELETE
    @Path(value="/os-security-group-rules/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteRule(@PathParam(value="id") String var1);
}

