/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.sshtrilead;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.DebugLogger;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.CommandRunner;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.cpi.FileCpi;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.gridlab.gat.security.sshtrilead.HostKeyVerifier;
import org.gridlab.gat.security.sshtrilead.SshTrileadSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshTrileadFileAdaptor
extends FileCpi {
    private static final long serialVersionUID = 7343449503574566274L;
    private static Logger logger = LoggerFactory.getLogger(SshTrileadFileAdaptor.class);
    private static final int SSH_PORT = 22;
    static final int STDOUT = 0;
    static final int STDERR = 1;
    static final int EXIT_VALUE = 2;
    static final String DEFAULT_MODE = "0700";
    private static Map<ConnectionKey, Connection> connections = new HashMap<ConnectionKey, Connection>();
    private static Map<URI, Boolean> isDirCache = new HashMap<URI, Boolean>();
    private static Map<URI, Boolean> isFileCache = new HashMap<URI, Boolean>();
    private static Map<URI, Boolean> existsCache = new HashMap<URI, Boolean>();
    private static Map<URI, Boolean> canReadCache = new HashMap<URI, Boolean>();
    private static Map<URI, Boolean> canWriteCache = new HashMap<URI, Boolean>();
    private static Map<String, Boolean> isWindowsCache = new HashMap<String, Boolean>();
    private static Map<String, Boolean> isCshCache = new HashMap<String, Boolean>();
    private static Map<URI, String[]> listCache = new HashMap<URI, String[]>();
    private boolean canReadCacheEnable;
    private boolean canWriteCacheEnable;
    private boolean existsCacheEnable;
    private boolean isDirCacheEnable;
    private boolean isFileCacheEnable;
    private boolean listCacheEnable;
    private boolean isWindowsCacheEnable;
    private boolean connectionCacheEnable;
    private String[] client2serverCiphers;
    private String[] server2clientCiphers;
    private boolean tcpNoDelay;
    URI fixedURI;
    private HostKeyVerifier verifier;
    private boolean isLocal;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileCpi.getSupportedCapabilities();
        capabilities.put("copy", true);
        capabilities.put("canRead", true);
        capabilities.put("canWrite", true);
        capabilities.put("createNewFile", true);
        capabilities.put("delete", true);
        capabilities.put("exists", true);
        capabilities.put("getAbsoluteFile", true);
        capabilities.put("getAbsolutePath", true);
        capabilities.put("isDirectory", true);
        capabilities.put("isFile", true);
        capabilities.put("isHidden", true);
        capabilities.put("lastModified", true);
        capabilities.put("length", true);
        capabilities.put("list", true);
        capabilities.put("mkdir", true);
        capabilities.put("mkdirs", true);
        capabilities.put("move", true);
        capabilities.put("renameTo", true);
        capabilities.put("setLastModified", true);
        capabilities.put("setReadOnly", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = FileCpi.getSupportedPreferences();
        preferences.put("sshtrilead.caching.canread", (Object)"false");
        preferences.put("sshtrilead.caching.canwrite", (Object)"false");
        preferences.put("sshtrilead.caching.exists", (Object)"false");
        preferences.put("sshtrilead.caching.isdirectory", (Object)"false");
        preferences.put("sshtrilead.caching.isfile", (Object)"false");
        preferences.put("sshtrilead.caching.ishidden", (Object)"false");
        preferences.put("sshtrilead.caching.lastmodified", (Object)"false");
        preferences.put("sshtrilead.caching.length", (Object)"false");
        preferences.put("sshtrilead.caching.list", (Object)"false");
        preferences.put("sshtrilead.caching.iswindows", (Object)"true");
        preferences.put("sshtrilead.caching.iscsh", (Object)"true");
        preferences.put("sshtrilead.cipher.client2server", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.cipher.server2client", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        preferences.put("sshtrilead.tcp.nodelay", (Object)"true");
        preferences.put("sshtrilead.use.cached.connections", (Object)"true");
        preferences.put("sshtrilead.connect.timeout", (Object)"5000");
        preferences.put("sshtrilead.kex.timeout", (Object)"5000");
        preferences.put("sshtrilead.strictHostKeyChecking", (Object)"false");
        preferences.put("sshtrilead.noHostKeyChecking", (Object)"true");
        preferences.put("ssh.gateway.uri", (Object)"<no default value>");
        preferences.put("file.chmod", (Object)DEFAULT_MODE);
        return preferences;
    }

    public static String getDescription() {
        return "The SshTrilead File Adaptor implements the File object using the trilead ssh library. Trilead ssh is an open source full java ssh library. On the server side, the 'scp' program must be in the PATH. Connections with a remote ssh server can be made by using the username + password, username + keyfile, or with only a username, depending on the client and server settings.";
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"sshtrilead", "ssh", "file", ""};
    }

    public static void end() {
        SshTrileadFileAdaptor.killConnections();
        isDirCache.clear();
        isFileCache.clear();
        existsCache.clear();
        canReadCache.clear();
        canWriteCache.clear();
        isWindowsCache.clear();
        isCshCache.clear();
        listCache.clear();
    }

    public SshTrileadFileAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException, GATInvocationException {
        super(gatContext, location);
        this.fixedURI = SshTrileadFileAdaptor.fixURI((URI)location, null);
        Preferences p = gatContext.getPreferences();
        this.canReadCacheEnable = ((String)p.get("sshtrilead.caching.canread", (Object)"false")).equalsIgnoreCase("true");
        this.canWriteCacheEnable = ((String)p.get("sshtrilead.caching.canwrite", (Object)"false")).equalsIgnoreCase("true");
        this.existsCacheEnable = ((String)p.get("sshtrilead.caching.exists", (Object)"false")).equalsIgnoreCase("true");
        this.isDirCacheEnable = ((String)p.get("sshtrilead.caching.isdirectory", (Object)"false")).equalsIgnoreCase("true");
        this.isFileCacheEnable = ((String)p.get("sshtrilead.caching.isfile", (Object)"false")).equalsIgnoreCase("true");
        this.listCacheEnable = ((String)p.get("sshtrilead.caching.list", (Object)"false")).equalsIgnoreCase("true");
        this.isWindowsCacheEnable = ((String)p.get("sshtrilead.caching.iswindows", (Object)"true")).equalsIgnoreCase("true");
        String client2serverCipherString = (String)p.get("sshtrilead.cipher.client2server", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        this.client2serverCiphers = client2serverCipherString.split(",");
        String server2clientCipherString = (String)p.get("sshtrilead.cipher.server2client", (Object)"aes256-ctr,aes192-ctr,aes128-ctr,blowfish-ctr,aes256-cbc,aes192-cbc,aes128-cbc,blowfish-cbc");
        this.server2clientCiphers = server2clientCipherString.split(",");
        this.tcpNoDelay = ((String)p.get("sshtrilead.tcp.nodelay", (Object)"true")).equalsIgnoreCase("true");
        this.connectionCacheEnable = ((String)p.get("sshtrilead.use.cached.connections", (Object)"true")).equalsIgnoreCase("true");
        boolean noHostKeyChecking = ((String)p.get("sshtrilead.noHostKeyChecking", (Object)"true")).equalsIgnoreCase("true");
        boolean strictHostKeyChecking = ((String)p.get("sshtrilead.strictHostKeyChecking", (Object)"false")).equalsIgnoreCase("true");
        this.verifier = new HostKeyVerifier(false, strictHostKeyChecking, noHostKeyChecking);
        this.isLocal = location.isCompatible("file") && location.refersToLocalHost();
    }

    public void copy(URI destination) throws GATInvocationException {
        destination = SshTrileadFileAdaptor.fixURI((URI)destination, null);
        if (this.isLocal) {
            try {
                this.put(destination);
            }
            catch (Exception e) {
                if (e instanceof GATInvocationException) {
                    throw (GATInvocationException)e;
                }
                throw new GATInvocationException("SshTrileadFileAdaptor", (Throwable)e);
            }
        } else if (destination.isCompatible("file") && destination.refersToLocalHost()) {
            try {
                this.get(destination);
            }
            catch (Exception e) {
                if (e instanceof GATInvocationException) {
                    throw (GATInvocationException)e;
                }
                throw new GATInvocationException("SshTrileadFileAdaptor", (Throwable)e);
            }
        } else {
            this.remoteScp(destination);
        }
    }

    public void safeCopy(URI destination) throws GATInvocationException {
        destination = SshTrileadFileAdaptor.fixURI((URI)destination, null);
        if (this.isLocal) {
            try {
                this.safePut(destination);
            }
            catch (Exception e) {
                if (e instanceof GATInvocationException) {
                    throw (GATInvocationException)e;
                }
                throw new GATInvocationException("SshTrileadFileAdaptor", (Throwable)e);
            }
        } else if (destination.isCompatible("file") && destination.refersToLocalHost()) {
            try {
                this.safeGet(destination);
            }
            catch (Exception e) {
                if (e instanceof GATInvocationException) {
                    throw (GATInvocationException)e;
                }
                throw new GATInvocationException("SshTrileadFileAdaptor", (Throwable)e);
            }
        } else {
            this.remoteScp(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(URI destination) throws Exception {
        String parentPath;
        if (destination.isCompatible("file") && destination.refersToLocalHost()) {
            throw new GATInvocationException("SshTrileadFileAdaptor cannot copy local to local");
        }
        if (!SshTrileadFileAdaptor.recognizedScheme((String)destination.getScheme(), (String[])SshTrileadFileAdaptor.getSupportedSchemes())) {
            throw new GATInvocationException("SshTrileadFileAdaptor.copy: unrecognized scheme");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("destination: " + destination);
        }
        SshTrileadFileAdaptor destinationFile = new SshTrileadFileAdaptor(this.gatContext, destination);
        String remoteDir = null;
        String remoteFileName = null;
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") && (parentPath = destinationFile.getParent()) != null) {
            URI parentUri = destinationFile.toURI().setPath(parentPath);
            SshTrileadFileAdaptor parent = new SshTrileadFileAdaptor(this.gatContext, parentUri);
            parent.mkdirs();
        }
        if (destination.hasAbsolutePath()) {
            remoteDir = destinationFile.isDirectory() ? destinationFile.getPath() : destinationFile.getParent();
        } else if (destinationFile.isDirectory()) {
            remoteDir = destinationFile.getPath();
        } else {
            remoteDir = ".";
            String parent = destinationFile.getParent();
            if (parent != null) {
                String separator = this.isWindows(this.gatContext, destination) ? "\\" : "/";
                remoteDir = parent.startsWith(separator) ? parent : remoteDir + separator + parent;
            }
        }
        remoteFileName = destinationFile.getName();
        String mode = this.getMode(this.gatContext, DEFAULT_MODE);
        java.io.File sourceFile = new java.io.File(this.getFixedPath());
        if (sourceFile.isFile()) {
            SCPClient client;
            Connection connection = SshTrileadFileAdaptor.getConnection(destination, this.gatContext, this.connectionCacheEnable, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
            try {
                client = connection.createSCPClient();
            }
            catch (IOException e) {
                ConnectionKey key = SshTrileadFileAdaptor.getKey(destination, this.gatContext);
                if (key != null) {
                    Map<ConnectionKey, Connection> map = connections;
                    synchronized (map) {
                        connections.remove(key);
                    }
                }
                connection.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("createSCPClient to " + destination + " got exception", (Throwable)e);
                }
                if (this.connectionCacheEnable) {
                    connection = SshTrileadFileAdaptor.getConnection(destination, this.gatContext, false, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
                    try {
                        client = connection.createSCPClient();
                    }
                    catch (IOException e1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("createSCPClient to " + destination + " got second exception", (Throwable)e1);
                        }
                        connection.close();
                        throw e1;
                    }
                }
                throw e;
            }
            if (destinationFile.isDirectory()) {
                logger.debug("put " + this.getFixedPath() + ", " + remoteDir + ", " + mode);
                client.put(this.getFixedPath(), remoteDir, mode);
            } else {
                logger.debug("put " + this.getFixedPath() + ", " + remoteFileName + ", " + remoteDir + ", " + mode);
                client.put(this.getFixedPath(), remoteFileName, remoteDir, mode);
            }
        } else if (sourceFile.isDirectory()) {
            this.copyDir(destination);
        } else {
            throw new GATInvocationException("cannot copy this file '" + this.fixedURI + "' to '" + remoteFileName + "' in dir '" + remoteDir + "'! (Reason: src is file: " + sourceFile.isFile() + ", src is dir: " + sourceFile.isDirectory() + ", dest is dir: " + destinationFile.isDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safePut(URI destination) throws Exception {
        SCPClient client;
        if (destination.isCompatible("file") && destination.refersToLocalHost()) {
            throw new GATInvocationException("SshTrileadFileAdaptor cannot copy local to local");
        }
        if (!SshTrileadFileAdaptor.recognizedScheme((String)destination.getScheme(), (String[])SshTrileadFileAdaptor.getSupportedSchemes())) {
            throw new GATInvocationException("SshTrileadFileAdaptor.copy: unrecognized scheme");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("destination: " + destination);
        }
        Connection connection = SshTrileadFileAdaptor.getConnection(destination, this.gatContext, this.connectionCacheEnable, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
        try {
            client = connection.createSCPClient();
        }
        catch (IOException e) {
            ConnectionKey key = SshTrileadFileAdaptor.getKey(destination, this.gatContext);
            if (key != null) {
                Map<ConnectionKey, Connection> map = connections;
                synchronized (map) {
                    connections.remove(key);
                }
            }
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("createSCPClient to " + destination + " got exception", (Throwable)e);
            }
            if (this.connectionCacheEnable) {
                connection = SshTrileadFileAdaptor.getConnection(destination, this.gatContext, false, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
                try {
                    client = connection.createSCPClient();
                }
                catch (IOException e1) {
                    connection.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("createSCPClient to " + destination + " got second exception", (Throwable)e1);
                    }
                    throw e1;
                }
            }
            throw e;
        }
        SshTrileadFileAdaptor destinationFile = new SshTrileadFileAdaptor(this.gatContext, destination);
        String remoteDir = null;
        String remoteFileName = null;
        if (destination.hasAbsolutePath()) {
            remoteDir = destinationFile.getParent();
        } else {
            remoteDir = ".";
            String parent = destinationFile.getParent();
            if (parent != null) {
                String separator = this.isWindows(this.gatContext, destination) ? "\\" : "/";
                remoteDir = parent.startsWith(separator) ? parent : remoteDir + separator + parent;
            }
        }
        remoteFileName = destinationFile.getName();
        String mode = this.getMode(this.gatContext, DEFAULT_MODE);
        if (logger.isDebugEnabled()) {
            logger.debug("put " + this.getFixedPath() + ", " + remoteFileName + ", " + remoteDir + ", " + mode);
        }
        client.put(this.getFixedPath(), remoteFileName, remoteDir, mode);
    }

    private String getMode(GATContext gatContext, String defaultMode) throws GATInvocationException {
        String mode = defaultMode;
        if (gatContext.getPreferences().containsKey("file.chmod")) {
            mode = (String)gatContext.getPreferences().get("file.chmod");
            if (mode.length() == 3) {
                mode = "0" + mode;
            }
            if (mode.length() != 4 || !mode.startsWith("0")) {
                throw new GATInvocationException("invalid mode: '" + gatContext.getPreferences().get("file.chmod") + "'. Should be like '0xxx' or 'xxx'");
            }
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(URI destination) throws Exception {
        File destinationParentFile;
        FileInterface destinationFile = GAT.createFile((GATContext)this.gatContext, (URI)destination).getFileInterface();
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") && (destinationParentFile = destinationFile.getParentFile()) != null) {
            destinationParentFile.getFileInterface().mkdirs();
        }
        String dest = destination.getPath();
        if (this.isFile()) {
            SCPClient client = this.getSCPClient();
            if (destinationFile.isDirectory()) {
                dest = dest + "/" + this.getName();
                this.createNewFile(dest, this.getMode(this.gatContext, DEFAULT_MODE));
                FileOutputStream d = new FileOutputStream(dest);
                try {
                    client.get(this.getFixedPath(), (OutputStream)d);
                }
                finally {
                    try {
                        d.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (this.gatContext.getPreferences().containsKey("file.copytime") && ((String)this.gatContext.getPreferences().get("file.copytime")).equalsIgnoreCase("true")) {
                    try {
                        new java.io.File(dest).setLastModified(this.lastModified());
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.createNewFile(dest, this.getMode(this.gatContext, DEFAULT_MODE));
                FileOutputStream d = new FileOutputStream(dest);
                try {
                    client.get(this.getFixedPath(), (OutputStream)d);
                }
                finally {
                    try {
                        d.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (this.gatContext.getPreferences().containsKey("file.copytime") && ((String)this.gatContext.getPreferences().get("file.copytime")).equalsIgnoreCase("true")) {
                    try {
                        new java.io.File(dest).setLastModified(this.lastModified());
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else if (this.isDirectory()) {
            this.copyDir(destination);
        } else {
            throw new GATInvocationException("cannot copy this file '" + this.fixedURI + "' to '" + destination + "'! (Reason: src is file: " + this.isFile() + ", src is dir: " + this.isDirectory() + ", target is dir: " + destinationFile.isDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeGet(URI destination) throws Exception {
        SCPClient client = this.getSCPClient();
        String dest = destination.getPath();
        this.createNewFile(dest, this.getMode(this.gatContext, DEFAULT_MODE));
        FileOutputStream d = new FileOutputStream(dest);
        try {
            client.get(this.getFixedPath(), (OutputStream)d);
        }
        finally {
            try {
                d.close();
            }
            catch (Throwable throwable) {}
        }
        if (this.gatContext.getPreferences().containsKey("file.copytime") && ((String)this.gatContext.getPreferences().get("file.copytime")).equalsIgnoreCase("true")) {
            try {
                new java.io.File(dest).setLastModified(this.lastModified());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean isWindows(GATContext context, URI destination) throws GATInvocationException {
        return SshTrileadFileAdaptor.isWindows(context, destination, this.isWindowsCacheEnable);
    }

    public static boolean isWindows(GATContext context, URI destination, boolean isWindowsCacheEnable) throws GATInvocationException {
        String[] result;
        SshTrileadFileAdaptor file;
        String host = destination.getHost();
        if (host == null) {
            host = destination.resolveHost();
        }
        logger.info("is Windows for host: " + host);
        if (isWindowsCacheEnable && isWindowsCache.containsKey(host)) {
            logger.debug("got is Windows from cache");
            return isWindowsCache.get(host);
        }
        try {
            file = new SshTrileadFileAdaptor(context, destination);
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("failed to create ssh file", (Throwable)e);
        }
        try {
            result = file.execCommand("ls -d");
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        if (result[1].length() != 0) {
            boolean isWindows;
            try {
                result = file.execCommand("dir");
            }
            catch (Exception e) {
                throw new GATInvocationException("sshtrilead", (Throwable)e);
            }
            boolean bl = isWindows = result[1].length() == 0;
            if (isWindowsCacheEnable) {
                isWindowsCache.put(host, isWindows);
            }
            return isWindows;
        }
        if (isWindowsCacheEnable) {
            isWindowsCache.put(host, false);
        }
        return false;
    }

    public static boolean isCsh(GATContext context, URI destination, boolean isCshCacheEnable) throws GATInvocationException {
        String[] result;
        SshTrileadFileAdaptor file;
        String host = destination.getHost();
        if (host == null) {
            host = destination.resolveHost();
        }
        logger.info("isCsh for host: " + host);
        if (isCshCacheEnable && isCshCache.containsKey(host)) {
            logger.debug("got isCsh from cache");
            return isCshCache.get(host);
        }
        try {
            file = new SshTrileadFileAdaptor(context, destination);
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("failed to create ssh file", (Throwable)e);
        }
        try {
            result = file.execCommand("echo ___________*_____________");
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean isCsh = result[0].contains("match");
        if (isCshCacheEnable) {
            isCshCache.put(host, isCsh);
        }
        return isCsh;
    }

    private boolean createNewFile(String localfile, String mode) throws GATInvocationException {
        boolean result;
        java.io.File f = new java.io.File(localfile);
        try {
            result = f.createNewFile();
        }
        catch (IOException e) {
            throw new GATInvocationException("Could not create file", (Throwable)e);
        }
        if (java.io.File.separator.equals("/")) {
            new CommandRunner(new String[]{"chmod", mode, localfile});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(URI fixedURI, GATContext context, boolean useCachedConnection, boolean tcpNoDelay, String[] client2server, String[] server2client, HostKeyVerifier verifier) throws GATInvocationException, IOException {
        Connection connection = SshTrileadFileAdaptor.getConnection(fixedURI, context, useCachedConnection, tcpNoDelay, client2server, server2client, verifier);
        try {
            return connection.openSession();
        }
        catch (IOException e) {
            ConnectionKey key = SshTrileadFileAdaptor.getKey(fixedURI, context);
            if (key != null) {
                Map<ConnectionKey, Connection> map = connections;
                synchronized (map) {
                    connections.remove(key);
                }
            }
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("openSession got exception", (Throwable)e);
            }
            if (useCachedConnection) {
                connection = SshTrileadFileAdaptor.getConnection(fixedURI, context, false, tcpNoDelay, client2server, server2client, verifier);
                try {
                    return connection.openSession();
                }
                catch (IOException e1) {
                    connection.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("openSession got second exception", (Throwable)e1);
                    }
                    throw e1;
                }
            }
            throw e;
        }
    }

    Session getSession() throws IOException, GATInvocationException {
        return SshTrileadFileAdaptor.getSession(this.fixedURI, this.gatContext, this.connectionCacheEnable, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCPClient getSCPClient() throws IOException, GATInvocationException {
        Connection connection = SshTrileadFileAdaptor.getConnection(this.fixedURI, this.gatContext, this.connectionCacheEnable, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
        try {
            return connection.createSCPClient();
        }
        catch (IOException e) {
            ConnectionKey key;
            if (logger.isDebugEnabled()) {
                logger.debug("createSCPClient got exception", (Throwable)e);
            }
            if ((key = SshTrileadFileAdaptor.getKey(this.fixedURI, this.gatContext)) != null) {
                Map<ConnectionKey, Connection> map = connections;
                synchronized (map) {
                    connections.remove(key);
                }
            }
            connection.close();
            if (this.connectionCacheEnable) {
                connection = SshTrileadFileAdaptor.getConnection(this.fixedURI, this.gatContext, false, this.tcpNoDelay, this.client2serverCiphers, this.server2clientCiphers, this.verifier);
                try {
                    return connection.createSCPClient();
                }
                catch (IOException e1) {
                    connection.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("createSCPClient got second exception", (Throwable)e);
                    }
                    throw e1;
                }
            }
            throw e;
        }
    }

    public static ConnectionKey getKey(URI fixedURI, GATContext context) {
        String host = fixedURI.getHost();
        int port = fixedURI.getPort(22);
        if (host == null) {
            host = fixedURI.resolveHost();
        }
        if (logger.isInfoEnabled()) {
            logger.info("getting key for host: " + host);
        }
        try {
            SshTrileadSecurityUtils.getSshTrileadCredential(context, "sshtrilead", fixedURI, port);
        }
        catch (Throwable e) {
            return null;
        }
        return new ConnectionKey(host, port, (GATContext)context.clone());
    }

    private static void killConnections() {
        Collection<Connection> cns = connections.values();
        for (Connection c : cns) {
            try {
                c.close();
            }
            catch (Throwable throwable) {}
        }
        connections.clear();
    }

    public static int findFreePort() throws IOException {
        ServerSocket server = new ServerSocket(0);
        int port = server.getLocalPort();
        server.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(URI fixedURI, GATContext context, boolean useCachedConnection, boolean tcpNoDelay, String[] client2server, String[] server2client, HostKeyVerifier verifier) throws GATInvocationException {
        Connection newConnection;
        Map<String, Object> securityInfo;
        String host = fixedURI.getHost();
        int port = fixedURI.getPort(22);
        if (host == null) {
            host = fixedURI.resolveHost();
        }
        if (logger.isInfoEnabled()) {
            logger.info("getting connection for URI: " + fixedURI + ", host: " + host);
        }
        try {
            securityInfo = SshTrileadSecurityUtils.getSshTrileadCredential(context, "sshtrilead", fixedURI, port);
        }
        catch (Throwable e) {
            throw new GATInvocationException("Could not get credentials", e);
        }
        ConnectionKey key = new ConnectionKey(host, port, (GATContext)context.clone());
        Map<ConnectionKey, Connection> map = connections;
        synchronized (map) {
            Object o;
            if (useCachedConnection) {
                logger.info("looking for a cached connection");
                Connection c = connections.get(key);
                if (c != null) {
                    logger.info("returning cached connection");
                    return c;
                }
                logger.info("not found");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up connection to " + host);
            }
            Preferences prefs = context.getPreferences();
            URI gateway = null;
            if (prefs != null && (o = prefs.get("ssh.gateway.uri")) != null) {
                if (o instanceof URI) {
                    gateway = (URI)o;
                } else if (o instanceof String) {
                    try {
                        gateway = new URI((String)o);
                    }
                    catch (URISyntaxException e) {
                        throw new GATInvocationException("Illegal uri in preference ssh.gateway.uri: " + o, (Throwable)e);
                    }
                }
            }
            if (gateway != null) {
                int localPort;
                GATContext clone = (GATContext)context.clone();
                prefs = clone.getPreferences();
                prefs.remove("ssh.gateway.uri");
                clone.removePreferences();
                clone.addPreferences(prefs);
                if (logger.isDebugEnabled()) {
                    logger.debug("Getting a connection to the gateway " + gateway);
                    logger.debug("Context = " + clone);
                }
                Connection conn = SshTrileadFileAdaptor.getConnection(gateway, clone, useCachedConnection, tcpNoDelay, client2server, server2client, verifier);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got a connection to the gateway " + gateway);
                }
                try {
                    localPort = SshTrileadFileAdaptor.findFreePort();
                }
                catch (IOException e) {
                    throw new GATInvocationException("Could not find a free port", (Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found local free port " + localPort);
                }
                try {
                    conn.createLocalPortForwarder(localPort, host, fixedURI.getPort(22));
                }
                catch (IOException e) {
                    throw new GATInvocationException("Got exception while creating local port forwarder");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Got local port forwarder");
                }
                newConnection = new Connection("localhost", localPort);
            } else {
                newConnection = new Connection(host, fixedURI.getPort(22));
            }
            if (logger.isDebugEnabled()) {
                DebugLogger log = new DebugLogger(){

                    public void log(int arg0, String arg1, String arg2) {
                        logger.debug(arg1 + ": " + arg2);
                    }
                };
                newConnection.enableDebugging(true, log);
            }
            newConnection.setClient2ServerCiphers(client2server);
            newConnection.setServer2ClientCiphers(server2client);
            try {
                newConnection.setTCPNoDelay(tcpNoDelay);
            }
            catch (IOException log) {
                // empty catch block
            }
            int connectTimeout = 5000;
            String connectTimeoutString = (String)context.getPreferences().get("sshtrilead.connect.timeout");
            if (connectTimeoutString != null) {
                try {
                    connectTimeout = Integer.parseInt(connectTimeoutString);
                }
                catch (Throwable t) {
                    logger.info("'sshtrilead.connect.timeout' set, but could not be parsed: " + t);
                }
            }
            int kexTimeout = 5000;
            String kexTimeoutString = (String)context.getPreferences().get("sshtrilead.kex.timeout");
            if (kexTimeoutString != null) {
                try {
                    kexTimeout = Integer.parseInt(kexTimeoutString);
                }
                catch (Throwable t) {
                    logger.info("'sshtrilead.kex.timeout' set, but could not be parsed: " + t);
                }
            }
            try {
                newConnection.connect((ServerHostKeyVerifier)verifier, connectTimeout, kexTimeout);
            }
            catch (IOException e1) {
                newConnection.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not connect, closing" + host);
                }
                throw new GATInvocationException("Could not connect", (Throwable)e1);
            }
            String username = (String)securityInfo.get("username");
            String password = (String)securityInfo.get("password");
            java.io.File keyFile = (java.io.File)securityInfo.get("keyfile");
            boolean defaultInfo = securityInfo.get("default") != null;
            boolean connected = false;
            if (username != null && password != null) {
                block62: {
                    try {
                        connected = newConnection.authenticateWithPassword(username, password);
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block62;
                        logger.debug("exception caught during authentication with password: ", (Throwable)e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("authentication with password: " + connected);
                }
            }
            if (!connected && defaultInfo && username != null) {
                block63: {
                    try {
                        connected = newConnection.authenticateWithPublicKey(username);
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block63;
                        logger.debug("exception caught during authentication with public key: ", (Throwable)e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("authentication with public key: " + connected);
                }
            }
            if (!connected && username != null && keyFile != null) {
                block64: {
                    try {
                        connected = newConnection.authenticateWithPublicKey(username, keyFile, password);
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block64;
                        logger.debug("exception caught during authentication with public key: ", (Throwable)e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("authentication with public key: " + connected);
                }
            }
            if (!connected && username != null) {
                block65: {
                    try {
                        connected = newConnection.authenticateWithNone(username);
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block65;
                        logger.debug("exception caught during authentication with username: " + e);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("authentication with username: " + connected);
                }
            }
            if (!connected) {
                newConnection.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not authenticate, closing" + host);
                }
                throw new GATInvocationException("unable to authenticate");
            }
            logger.info("putting connection for host " + host + " into cache");
            Connection c = connections.get(key);
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            connections.put(key, newConnection);
        }
        if (logger.isInfoEnabled()) {
            long start = System.currentTimeMillis();
            try {
                newConnection.ping();
                logger.info("ping connection: " + (System.currentTimeMillis() - start) + " ms");
            }
            catch (Exception e) {
                logger.info("ping failed: " + e);
            }
        }
        return newConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] execCommand(String cmd) throws IOException, Exception {
        if (logger.isInfoEnabled()) {
            logger.info("execCommand: " + cmd + ", uri: " + this.fixedURI);
        }
        String[] result = new String[3];
        Session session = this.getSession();
        try {
            String line;
            String line2;
            session.execCommand(cmd);
            StreamGobbler stdout = new StreamGobbler(session.getStdout());
            StreamGobbler stderr = new StreamGobbler(session.getStderr());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout));
            result[0] = "";
            result[1] = "";
            StringBuffer out = new StringBuffer();
            while ((line2 = br.readLine()) != null) {
                out.append(line2);
                out.append("\n");
            }
            result[0] = out.toString();
            br = new BufferedReader(new InputStreamReader((InputStream)stderr));
            StringBuffer err = new StringBuffer();
            while ((line = br.readLine()) != null) {
                err.append(line);
                err.append("\n");
            }
            result[1] = err.toString();
            Integer exitValue = session.getExitStatus();
            for (int sleepcount = 0; sleepcount < 5 && exitValue == null; ++sleepcount) {
                Thread.sleep(100L);
                exitValue = session.getExitStatus();
            }
            result[2] = exitValue == null ? "0" : "" + exitValue;
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info("ExecCommand closes session");
            }
            session.close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("STDOUT: " + result[0]);
            logger.debug("STDERR: " + result[1]);
            logger.debug("EXIT:   " + result[2]);
        }
        return result;
    }

    public boolean canRead() throws GATInvocationException {
        boolean canread;
        String[] result;
        if (this.canReadCacheEnable && canReadCache.containsKey(this.fixedURI)) {
            return canReadCache.get(this.fixedURI);
        }
        if (this.fixedURI.refersToLocalHost()) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            boolean canread2 = f.canRead();
            if (this.canReadCacheEnable) {
                canReadCache.put(this.fixedURI, canread2);
            }
            return canread2;
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("test -r " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()) + " && echo 0");
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean bl = canread = result[0].length() != 0;
        if (this.canReadCacheEnable) {
            canReadCache.put(this.fixedURI, canread);
        }
        return canread;
    }

    private void remoteScp(URI dest) throws GATInvocationException {
        String[] result;
        if (this.isWindows(this.gatContext, this.location) || !SshTrileadFileAdaptor.recognizedScheme((String)dest.getScheme(), (String[])SshTrileadFileAdaptor.getSupportedSchemes())) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (dest.getAuthority().equals(this.location.getAuthority())) {
            try {
                result = this.execCommand("cp -r " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()) + " " + SshTrileadFileAdaptor.protectAgainstShellMetas(dest.getPath()));
            }
            catch (Exception e) {
                throw new GATInvocationException("sshtrilead", (Throwable)e);
            }
        }
        try {
            result = this.execCommand("scp -r " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()) + " ${USER}@" + dest.getHost() + ":" + SshTrileadFileAdaptor.protectAgainstShellMetas(dest.getPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        if (result[1].length() != 0 && !result[1].startsWith("Warning:")) {
            throw new GATInvocationException("Third party transfer failed: " + result[1]);
        }
    }

    public boolean canWrite() throws GATInvocationException {
        boolean canwrite;
        String[] result;
        if (this.canWriteCacheEnable && canWriteCache.containsKey(this.fixedURI)) {
            return canWriteCache.get(this.fixedURI);
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            boolean canwrite2 = f.canWrite();
            if (this.canWriteCacheEnable) {
                canWriteCache.put(this.fixedURI, canwrite2);
            }
            return canwrite2;
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("test -w " + this.getFixedPath() + " && echo 0");
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean bl = canwrite = result[0].length() != 0;
        if (this.canWriteCacheEnable) {
            canWriteCache.put(this.fixedURI, canwrite);
        }
        return canwrite;
    }

    public boolean createNewFile() throws GATInvocationException {
        String[] result;
        if (this.exists()) {
            return false;
        }
        if (this.isLocal) {
            return this.createNewFile(this.fixedURI.getPath(), this.getMode(this.gatContext, DEFAULT_MODE));
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        String path = SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath());
        try {
            result = this.execCommand("test ! -d " + path + " && test ! -f " + path + " && touch " + path + " && chmod " + this.getMode(this.gatContext, DEFAULT_MODE) + " " + path);
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        if (this.existsCacheEnable && result[1].length() == 0) {
            existsCache.put(this.fixedURI, result[1].length() == 0);
        }
        return result[1].length() == 0;
    }

    public boolean delete() throws GATInvocationException {
        String[] result;
        if (!this.exists()) {
            return false;
        }
        if (this.existsCacheEnable && existsCache.containsKey(this.fixedURI)) {
            existsCache.remove(this.fixedURI);
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            try {
                return f.delete();
            }
            catch (Exception e) {
                throw new GATInvocationException("sshtrilead", (Throwable)e);
            }
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("rm -rf " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        return result[1].length() == 0;
    }

    public boolean exists() throws GATInvocationException {
        boolean exists;
        String[] result;
        if (this.existsCacheEnable && existsCache.containsKey(this.fixedURI)) {
            return existsCache.get(this.fixedURI);
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            try {
                boolean result2 = f.exists();
                if (this.existsCacheEnable && result2) {
                    existsCache.put(this.fixedURI, true);
                }
            }
            catch (Exception e) {
                throw new GATInvocationException("sshtrilead", (Throwable)e);
            }
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (logger.isInfoEnabled()) {
            logger.info("exists: ls -d " + this.getFixedPath());
        }
        try {
            result = this.execCommand("ls -d " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean bl = exists = result[1].length() == 0 && result[0].length() > 0;
        if (this.existsCacheEnable) {
            existsCache.put(this.fixedURI, exists);
        }
        return exists;
    }

    public File getAbsoluteFile() throws GATInvocationException {
        String absUri = this.fixedURI.toString().replace(this.fixedURI.getPath(), this.getAbsolutePath());
        try {
            return GAT.createFile((GATContext)this.gatContext, (URI)new URI(absUri));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAbsolutePath() throws GATInvocationException {
        String[] result;
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.getAbsolutePath();
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        String fixed = this.getFixedPath();
        if (fixed.startsWith("/")) {
            return fixed;
        }
        try {
            result = this.execCommand("echo ~");
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        return result[0].replace("\n", "") + "/" + fixed;
    }

    public boolean isDirectory() throws GATInvocationException {
        String[] result;
        logger.debug("isDirectory " + this.getFixedPath() + " (uri:" + this.fixedURI + ")");
        if (this.isDirCacheEnable && isDirCache.containsKey(this.fixedURI)) {
            logger.debug("got isDirectory from cache");
            return isDirCache.get(this.fixedURI);
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            boolean isDir = f.isDirectory();
            if (this.isDirCacheEnable) {
                isDirCache.put(this.fixedURI, isDir);
            }
            return isDir;
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("test -d " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean isDir = result[2].equals("0");
        if (this.isDirCacheEnable) {
            isDirCache.put(this.fixedURI, isDir);
        }
        return isDir;
    }

    final String getFixedPath() {
        String res = this.fixedURI.getPath();
        if (res == null) {
            throw new Error("path not specified correctly in URI: " + this.fixedURI);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("fixed path = " + res);
        }
        return res;
    }

    public boolean isFile() throws GATInvocationException {
        String[] result;
        if (this.isFileCacheEnable && isFileCache.containsKey(this.fixedURI)) {
            return isFileCache.get(this.fixedURI);
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            boolean isFile = f.isFile();
            if (this.isFileCacheEnable) {
                isFileCache.put(this.fixedURI, isFile);
            }
            return isFile;
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("test -f " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean isFile = result[2].equals("0");
        if (this.isFileCacheEnable) {
            isFileCache.put(this.fixedURI, isFile);
        }
        return isFile;
    }

    public boolean isHidden() throws GATInvocationException {
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        return this.getName().startsWith(".");
    }

    public long length() throws GATInvocationException {
        String[] result;
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.length();
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("wc -c < " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Throwable e) {
            throw new GATInvocationException("sshtrilead", e);
        }
        try {
            return Long.parseLong(result[0].replaceAll("[ \t\n\f\r]", ""));
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    public String[] list() throws GATInvocationException {
        String[] result;
        if (!this.isDirectory()) {
            return null;
        }
        if (this.listCacheEnable && listCache.containsKey(this.fixedURI)) {
            return listCache.get(this.fixedURI);
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            String[] l = f.list();
            if (this.listCacheEnable) {
                listCache.put(this.fixedURI, l);
            }
            return l;
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("ls -1 " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        if (result[0].equals("")) {
            return new String[0];
        }
        String[] list = result[0].split("\n");
        if (this.listCacheEnable) {
            listCache.put(this.fixedURI, list);
        }
        return list;
    }

    public File[] listFiles() throws GATInvocationException {
        try {
            String[] f = this.list();
            if (f == null) {
                return null;
            }
            File[] res = new File[f.length];
            for (int i = 0; i < f.length; ++i) {
                String uri = this.fixedURI.toString();
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri + f[i];
                res[i] = GAT.createFile((GATContext)this.gatContext, (URI)new URI(uri));
            }
            return res;
        }
        catch (Exception e) {
            throw new GATInvocationException("file cpi", (Throwable)e);
        }
    }

    public boolean mkdir() throws GATInvocationException {
        boolean mkdir;
        String[] result;
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.mkdir();
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("mkdir -m " + this.getMode(this.gatContext, DEFAULT_MODE) + " " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean bl = mkdir = result[1].length() == 0;
        if (this.existsCacheEnable && mkdir) {
            existsCache.put(this.fixedURI, mkdir);
        }
        if (this.isDirCacheEnable && mkdir) {
            isDirCache.put(this.fixedURI, mkdir);
        }
        return mkdir;
    }

    public boolean mkdirs() throws GATInvocationException {
        boolean mkdirs;
        String[] result;
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.mkdirs();
        }
        if (this.exists()) {
            return false;
        }
        if (this.isWindows(this.gatContext, this.location)) {
            return super.mkdirs();
        }
        try {
            result = this.execCommand("mkdir -m " + this.getMode(this.gatContext, DEFAULT_MODE) + " -p " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean bl = mkdirs = result[1].length() == 0;
        if (this.existsCacheEnable && mkdirs) {
            existsCache.put(this.fixedURI, mkdirs);
        }
        if (this.isDirCacheEnable && mkdirs) {
            isDirCache.put(this.fixedURI, mkdirs);
        }
        return mkdirs;
    }

    public void move(URI destination) throws GATInvocationException {
        FileInterface destinationFile = null;
        try {
            destinationFile = GAT.createFile((GATContext)this.gatContext, (URI)destination).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        boolean movedIntoExistingDir = destinationFile.exists() && destinationFile.isDirectory();
        this.copy(destination);
        if (!this.delete()) {
            throw new GATInvocationException("internal error in SshTrileadFileAdaptor: could not move file " + this.toURI() + " to " + destination);
        }
        if (this.canReadCacheEnable) {
            canReadCache.remove(this.fixedURI);
        }
        if (this.canWriteCacheEnable) {
            canWriteCache.remove(this.fixedURI);
        }
        if (this.isDirCacheEnable) {
            isDirCache.remove(this.fixedURI);
        }
        if (this.isFileCacheEnable) {
            isFileCache.remove(this.fixedURI);
        }
        if (this.existsCacheEnable) {
            existsCache.remove(this.fixedURI);
        }
        if (this.listCacheEnable) {
            listCache.remove(this.fixedURI);
        }
        if (movedIntoExistingDir) {
            try {
                this.fixedURI = new URI(destination + "/" + this.getName());
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.fixedURI = destination;
        }
        if (this.existsCacheEnable) {
            existsCache.put(this.fixedURI, true);
        }
    }

    public void renameTo(URI destination) throws GATInvocationException {
        this.move(destination);
    }

    public boolean renameTo(File file) throws GATInvocationException {
        this.copy(file.toGATURI());
        if (!this.delete()) {
            return false;
        }
        this.fixedURI = file.toGATURI();
        return true;
    }

    public boolean setLastModified(long lastModified) throws GATInvocationException {
        String[] result;
        if (!this.exists()) {
            return false;
        }
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.setLastModified(lastModified);
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("touch -c -t " + this.toTouchDateFormat(lastModified) + " " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        return result[1].length() == 0;
    }

    public long lastModified() throws GATInvocationException {
        String[] result;
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.lastModified();
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("stat -c %Y " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        try {
            return Long.parseLong(result[0].substring(0, result[0].length() - 1)) * 1000L;
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    private String toTouchDateFormat(long date) {
        Date d = new Date(date);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm.ss");
        return formatter.format(d);
    }

    public boolean setReadOnly() throws GATInvocationException {
        String[] result;
        if (this.isLocal) {
            java.io.File f = new java.io.File(this.fixedURI.getPath());
            return f.setReadOnly();
        }
        if (this.isWindows(this.gatContext, this.location)) {
            throw new UnsupportedOperationException("Not implemented");
        }
        try {
            result = this.execCommand("chmod a-w " + SshTrileadFileAdaptor.protectAgainstShellMetas(this.getFixedPath()));
        }
        catch (Exception e) {
            throw new GATInvocationException("sshtrilead", (Throwable)e);
        }
        return result[1].length() == 0;
    }

    static String protectAgainstShellMetas(String s) {
        char[] chars = s.toCharArray();
        StringBuffer b = new StringBuffer();
        b.append('\'');
        for (char c : chars) {
            if (c == '\'') {
                b.append('\'');
                b.append('\\');
                b.append('\'');
            }
            b.append(c);
        }
        b.append('\'');
        return b.toString();
    }

    private static class ConnectionKey {
        final String host;
        final GATContext context;
        final int port;

        public ConnectionKey(String host, int port, GATContext context) {
            this.host = host;
            this.context = context;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(Object o) {
            List l2;
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Comparing connection keys " + this + " and " + o);
            }
            ConnectionKey k = (ConnectionKey)o;
            if (k.port == this.port) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ports compare equal");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("ports compare NOT equal");
                }
                return false;
            }
            if (k.host.equals(this.host)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("hosts compare equal");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("hosts compare NOT equal");
                }
                return false;
            }
            List l1 = SecurityContextUtils.getValidSecurityContexts((GATContext)this.context, (String)"sshtrilead", (String)this.host, (int)this.port);
            if (l1.equals(l2 = SecurityContextUtils.getValidSecurityContexts((GATContext)k.context, (String)"sshtrilead", (String)this.host, (int)this.port))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("relevant security contexts compare equal");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("relevant security contexts compare NOT equal");
                }
                return false;
            }
            Preferences p1 = k.context.getPreferences();
            Preferences p2 = this.context.getPreferences();
            if (p1.get("sshtrilead.strictHostKeyChecking", (Object)"false").equals(p2.get("sshtrilead.strictHostKeyChecking", (Object)"false")) && p1.get("sshtrilead.noHostKeyChecking", (Object)"true").equals(p2.get("sshtrilead.noHostKeyChecking", (Object)"true"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("relevant preferences compare equal");
                }
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("relevant preferences compare NOT equal");
            }
            return false;
        }

        public String toString() {
            return "(" + this.host + ", " + this.context + ")";
        }
    }
}

