/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.connectors.utils;

import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.connectors.VM;
import es.bsc.compss.connectors.utils.Operations;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeletionThread
extends Thread {
    private static final Logger RESOURCE_LOGGER = LogManager.getLogger((String)"es.bsc.compss.ConnectorsUtils");
    private static final Logger RUNTIME_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.ResourceManager");
    private static final boolean DEBUG = RESOURCE_LOGGER.isDebugEnabled();
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    private final Operations operations;
    private final CloudMethodWorker worker;
    private final CloudMethodResourceDescription reduction;
    private VM vm;

    public DeletionThread(Operations connector, CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        this.setName("DeletionThread " + worker.getName());
        this.operations = connector;
        this.worker = worker;
        this.reduction = reduction;
        this.vm = null;
        COUNT.incrementAndGet();
    }

    public DeletionThread(Operations connector, VM vm) {
        this.setName("DeletionThread " + vm.getName());
        this.operations = connector;
        this.worker = null;
        this.reduction = null;
        this.vm = vm;
        COUNT.incrementAndGet();
    }

    @Override
    public void run() {
        if (this.reduction != null) {
            if (DEBUG) {
                RUNTIME_LOGGER.debug("[Deletion Thread] Pausing worker " + this.worker.getName());
            }
            this.vm = this.operations.pause(this.worker);
        }
        if (this.vm != null) {
            CloudMethodWorker cloudWorker = this.vm.getWorker();
            if (DEBUG) {
                RUNTIME_LOGGER.debug("[Deletion Thread] Worker " + cloudWorker.getName() + " stopped. Powering of the VM");
            }
            try {
                this.operations.poweroff(this.vm);
            }
            catch (ConnectorException e) {
                RESOURCE_LOGGER.error("ERROR: Powering off the resource", (Throwable)e);
            }
        }
        int count = COUNT.decrementAndGet();
        if (DEBUG) {
            RUNTIME_LOGGER.debug("Number of current VMs deletions decreased (" + count + ").");
        }
    }

    public static int getCount() {
        return COUNT.get();
    }
}

