/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseIdToNameFromHttpResponse
implements Function<HttpResponse, Map<String, String>> {
    private final ParseFirstJsonValueNamed<Set<IdName>> parser;

    @Inject
    public ParseIdToNameFromHttpResponse(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed<Set<IdName>>(Preconditions.checkNotNull(gsonView, "gsonView"), new TypeLiteral<Set<IdName>>(){}, "oscategory");
    }

    @Override
    public Map<String, String> apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Set<IdName> toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", response);
        ImmutableSortedMap.Builder<String, String> builder = ImmutableSortedMap.naturalOrder();
        for (IdName entry : toParse) {
            ((ImmutableMap.Builder)builder).put(entry.id, entry.name);
        }
        return ((ImmutableMap.Builder)builder).build();
    }

    private static class IdName {
        private String id;
        private String name;

        private IdName() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdName that = (IdName)o;
            if (!Objects.equal(this.id, that.id)) {
                return false;
            }
            return Objects.equal(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.id, this.name);
        }
    }
}

