/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Address;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.DiskType;
import org.jclouds.googlecomputeengine.domain.ForwardingRule;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.TargetInstance;
import org.jclouds.googlecomputeengine.domain.TargetPool;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/aggregated")
@Consumes(value={"application/json"})
public interface AggregatedListApi {
    @Named(value="MachineTypes:aggregatedList")
    @GET
    @Path(value="/machineTypes")
    public ListPage<MachineType> pageOfMachineTypes(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="MachineTypes:aggregatedList")
    @GET
    @Path(value="/machineTypes")
    @Transform(value=MachineTypePages.class)
    public Iterator<ListPage<MachineType>> machineTypes();

    @Named(value="MachineTypes:aggregatedList")
    @GET
    @Path(value="/machineTypes")
    @Transform(value=MachineTypePages.class)
    public Iterator<ListPage<MachineType>> machineTypes(ListOptions var1);

    @Named(value="Instances:aggregatedList")
    @GET
    @Path(value="/instances")
    public ListPage<Instance> pageOfInstances(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Instances:aggregatedList")
    @GET
    @Path(value="/instances")
    @Transform(value=InstancePages.class)
    public Iterator<ListPage<Instance>> instances();

    @Named(value="Instances:aggregatedList")
    @GET
    @Path(value="/instances")
    @Transform(value=InstancePages.class)
    public Iterator<ListPage<Instance>> instances(ListOptions var1);

    @Named(value="Addresses:aggregatedList")
    @GET
    @Path(value="/addresses")
    public ListPage<Address> pageOfAddresses(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Addresses:aggregatedList")
    @GET
    @Path(value="/addresses")
    @Transform(value=AddressPages.class)
    public Iterator<ListPage<Address>> addresses();

    @Named(value="Addresses:aggregatedList")
    @GET
    @Path(value="/addresses")
    @Transform(value=AddressPages.class)
    public Iterator<ListPage<Address>> addresses(ListOptions var1);

    @Named(value="Disks:aggregatedList")
    @GET
    @Path(value="/disks")
    public ListPage<Disk> pageOfDisks(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Disks:aggregatedList")
    @GET
    @Path(value="/disks")
    @Transform(value=DiskPages.class)
    public Iterator<ListPage<Disk>> disks();

    @Named(value="Disks:aggregatedList")
    @GET
    @Path(value="/disks")
    @Transform(value=DiskPages.class)
    public Iterator<ListPage<Disk>> disks(ListOptions var1);

    @Named(value="DiskTypes:aggregatedList")
    @GET
    @Path(value="/diskTypes")
    public ListPage<DiskType> pageOfDiskTypes(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="DiskTypes:aggregatedList")
    @GET
    @Path(value="/diskTypes")
    @Transform(value=DiskTypePages.class)
    public Iterator<ListPage<DiskType>> diskTypes();

    @Named(value="DiskTypes:aggregatedList")
    @GET
    @Path(value="/diskTypes")
    @Transform(value=DiskTypePages.class)
    public Iterator<ListPage<DiskType>> diskTypes(ListOptions var1);

    @Named(value="GlobalOperations:aggregatedList")
    @GET
    @Path(value="/operations")
    public ListPage<Operation> pageOfGlobalOperations(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="GlobalOperations:aggregatedList")
    @GET
    @Path(value="/operations")
    @Transform(value=OperationPages.class)
    public Iterator<ListPage<Operation>> globalOperations();

    @Named(value="GlobalOperations:aggregatedList")
    @GET
    @Path(value="/operations")
    @Transform(value=OperationPages.class)
    public Iterator<ListPage<Operation>> globalOperations(ListOptions var1);

    @Named(value="ForwardingRules:aggregatedList")
    @GET
    @Path(value="/forwardingRules")
    public ListPage<ForwardingRule> pageOfForwardingRules(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="ForwardingRules:aggregatedList")
    @GET
    @Path(value="/forwardingRules")
    @Transform(value=ForwardingRulePages.class)
    public Iterator<ListPage<ForwardingRule>> forwardingRules();

    @Named(value="ForwardingRule:aggregatedList")
    @GET
    @Path(value="/forwardingRules")
    @Transform(value=ForwardingRulePages.class)
    public Iterator<ListPage<ForwardingRule>> forwardingRules(ListOptions var1);

    @Named(value="TargetInstances:aggregatedList")
    @GET
    @Path(value="/targetInstances")
    public ListPage<TargetInstance> pageOfTargetInstances(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="TargetInstances:aggregatedList")
    @GET
    @Path(value="/targetInstances")
    @Transform(value=TargetInstancePages.class)
    public Iterator<ListPage<TargetInstance>> targetInstances();

    @Named(value="TargetInstances:aggregatedList")
    @GET
    @Path(value="/targetInstances")
    @Transform(value=TargetInstancePages.class)
    public Iterator<ListPage<TargetInstance>> targetInstances(ListOptions var1);

    @Named(value="TargetPool:aggregatedList")
    @GET
    @Path(value="/targetPools")
    public ListPage<TargetPool> pageOfTargetPools(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="TargetPool:aggregatedList")
    @GET
    @Path(value="/targetPools")
    @Transform(value=TargetPoolPages.class)
    public Iterator<ListPage<TargetPool>> targetPools();

    @Named(value="TargetPool:aggregatedList")
    @GET
    @Path(value="/targetPools")
    @Transform(value=TargetPoolPages.class)
    public Iterator<ListPage<TargetPool>> targetPools(ListOptions var1);

    public static final class TargetPoolPages
    extends BaseToIteratorOfListPage<TargetPool, TargetPoolPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        TargetPoolPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<TargetPool>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<TargetPool>>(){

                @Override
                public ListPage<TargetPool> apply(String pageToken) {
                    return TargetPoolPages.this.api.aggregatedList().pageOfTargetPools(pageToken, options);
                }
            };
        }
    }

    public static final class TargetInstancePages
    extends BaseToIteratorOfListPage<TargetInstance, TargetInstancePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        TargetInstancePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<TargetInstance>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<TargetInstance>>(){

                @Override
                public ListPage<TargetInstance> apply(String pageToken) {
                    return TargetInstancePages.this.api.aggregatedList().pageOfTargetInstances(pageToken, options);
                }
            };
        }
    }

    public static final class ForwardingRulePages
    extends BaseToIteratorOfListPage<ForwardingRule, ForwardingRulePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        ForwardingRulePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<ForwardingRule>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<ForwardingRule>>(){

                @Override
                public ListPage<ForwardingRule> apply(String pageToken) {
                    return ForwardingRulePages.this.api.aggregatedList().pageOfForwardingRules(pageToken, options);
                }
            };
        }
    }

    public static final class OperationPages
    extends BaseToIteratorOfListPage<Operation, OperationPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        OperationPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Operation>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Operation>>(){

                @Override
                public ListPage<Operation> apply(String pageToken) {
                    return OperationPages.this.api.aggregatedList().pageOfGlobalOperations(pageToken, options);
                }
            };
        }
    }

    public static final class DiskTypePages
    extends BaseToIteratorOfListPage<DiskType, DiskTypePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        DiskTypePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<DiskType>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<DiskType>>(){

                @Override
                public ListPage<DiskType> apply(String pageToken) {
                    return DiskTypePages.this.api.aggregatedList().pageOfDiskTypes(pageToken, options);
                }
            };
        }
    }

    public static final class DiskPages
    extends BaseToIteratorOfListPage<Disk, DiskPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        DiskPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Disk>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Disk>>(){

                @Override
                public ListPage<Disk> apply(String pageToken) {
                    return DiskPages.this.api.aggregatedList().pageOfDisks(pageToken, options);
                }
            };
        }
    }

    public static final class AddressPages
    extends BaseToIteratorOfListPage<Address, AddressPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        AddressPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Address>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Address>>(){

                @Override
                public ListPage<Address> apply(String pageToken) {
                    return AddressPages.this.api.aggregatedList().pageOfAddresses(pageToken, options);
                }
            };
        }
    }

    public static final class InstancePages
    extends BaseToIteratorOfListPage<Instance, InstancePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        InstancePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Instance>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Instance>>(){

                @Override
                public ListPage<Instance> apply(String pageToken) {
                    return InstancePages.this.api.aggregatedList().pageOfInstances(pageToken, options);
                }
            };
        }
    }

    public static final class MachineTypePages
    extends BaseToIteratorOfListPage<MachineType, MachineTypePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        MachineTypePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<MachineType>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<MachineType>>(){

                @Override
                public ListPage<MachineType> apply(String pageToken) {
                    return MachineTypePages.this.api.aggregatedList().pageOfMachineTypes(pageToken, options);
                }
            };
        }
    }
}

