/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.joyent.cloudapi.v6_5.JoyentCloudApi;
import org.jclouds.joyent.cloudapi.v6_5.compute.internal.KeyAndPrivateKey;
import org.jclouds.joyent.cloudapi.v6_5.compute.options.JoyentCloudTemplateOptions;
import org.jclouds.joyent.cloudapi.v6_5.domain.Key;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;
import org.jclouds.joyent.cloudapi.v6_5.features.KeyApi;
import org.jclouds.joyent.cloudapi.v6_5.predicates.KeyPredicates;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

@Singleton
public class JoyentCloudComputeService
extends BaseComputeService {
    protected final JoyentCloudApi novaApi;
    protected final LoadingCache<DatacenterAndName, KeyAndPrivateKey> keyCache;
    protected final Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByDatacenterId;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    protected JoyentCloudComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, JoyentCloudApi novaApi, LoadingCache<DatacenterAndName, KeyAndPrivateKey> keyCache, Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByDatacenterId, GroupNamingConvention.Factory namingConvention, Optional<ImageExtension> imageExtension, Optional<SecurityGroupExtension> securityGroupExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, userExecutor, imageExtension, securityGroupExtension);
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.keyCache = Preconditions.checkNotNull(keyCache, "keyCache");
        this.orphanedGroupsByDatacenterId = Preconditions.checkNotNull(orphanedGroupsByDatacenterId, "orphanedGroupsByDatacenterId");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    @Override
    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Multimap<String, String> zoneToZoneAndGroupNames = this.orphanedGroupsByDatacenterId.apply(deadNodes);
        for (Map.Entry<String, Collection<String>> entry : zoneToZoneAndGroupNames.asMap().entrySet()) {
            this.cleanupOrphanedKeysInZone(ImmutableSet.copyOf(entry.getValue()), entry.getKey());
        }
    }

    private void cleanupOrphanedKeysInZone(Set<String> groups, String datacenterId) {
        KeyApi keyApi = this.novaApi.getKeyApi();
        for (String group : groups) {
            for (Key key : Iterables.filter(keyApi.list(), KeyPredicates.nameMatches(this.namingConvention.create().containsGroup(group)))) {
                DatacenterAndName datacenterAndName = DatacenterAndName.fromDatacenterAndName(datacenterId, key.getName());
                this.logger.debug(">> deleting key(%s)", datacenterAndName);
                keyApi.delete(key.getName());
                this.keyCache.invalidate(datacenterAndName);
                this.logger.debug("<< deleted key(%s)", datacenterAndName);
            }
            this.keyCache.invalidate(DatacenterAndName.fromDatacenterAndName(datacenterId, this.namingConvention.create().sharedNameForGroup(group)));
        }
    }

    @Override
    public JoyentCloudTemplateOptions templateOptions() {
        return (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(super.templateOptions());
    }
}

