/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors.util;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.exceptions.SerializedObjectException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.executors.util.TargetParam;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StubItf;

public abstract class Invoker {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor.Invoker");
    private static final String ERROR_SERIALIZED_OBJ = "ERROR: Cannot obtain object";
    private static final String ERROR_PERSISTENT_OBJ = "ERROR: Cannot getById persistent object";
    protected static final String ERROR_METHOD_DEFINITION = "Incorrect method definition for task of type ";
    protected static final String ERROR_TASK_EXECUTION = "ERROR: Exception executing task (user code)";
    protected static final String ERROR_UNKNOWN_TYPE = "ERROR: Unrecognised type";
    protected final NIOWorker nw;
    protected final NIOTask nt;
    protected final File taskSandboxWorkingDir;
    protected final int[] assignedCoreUnits;
    private final boolean debug;
    protected final AbstractMethodImplementation.MethodType methodType;
    protected final AbstractMethodImplementation impl;
    protected final int numParams;
    protected final int totalNumberOfParams;
    protected final boolean hasTarget;
    protected final boolean hasReturn;
    protected final Class<?>[] types;
    protected final Stream[] streams;
    protected final String[] prefixes;
    protected final Object[] values;
    private final String[] renamings;
    private final boolean[] isFile;
    private final boolean[] canBePSCO;
    private final boolean[] writeFinalValue;
    protected final TargetParam target;
    private Object retValue;

    /*
     * WARNING - void declaration
     */
    public Invoker(NIOWorker nw, NIOTask nt, File taskSandboxWorkingDir, int[] assignedCoreUnits) throws JobExecutionException {
        void var6_7;
        this.nw = nw;
        this.nt = nt;
        this.taskSandboxWorkingDir = taskSandboxWorkingDir;
        this.assignedCoreUnits = assignedCoreUnits;
        this.debug = NIOWorker.isWorkerDebugEnabled();
        this.methodType = nt.getMethodType();
        this.impl = nt.getMethodImplementation();
        this.hasTarget = nt.hasTarget();
        this.hasReturn = nt.hasReturn();
        this.numParams = nt.getNumParams();
        this.totalNumberOfParams = this.hasTarget ? this.numParams - 1 : this.numParams;
        this.types = new Class[this.totalNumberOfParams];
        this.values = new Object[this.totalNumberOfParams];
        this.streams = new Stream[this.numParams];
        this.prefixes = new String[this.numParams];
        this.renamings = new String[this.numParams];
        this.isFile = new boolean[this.numParams];
        this.canBePSCO = new boolean[this.numParams];
        this.writeFinalValue = new boolean[this.numParams];
        this.target = new TargetParam();
        Iterator params = nt.getParams().iterator();
        boolean bl = false;
        while (var6_7 < this.numParams) {
            NIOParam np = (NIOParam)params.next();
            this.processParameter(np, (int)var6_7);
            ++var6_7;
        }
        if (this.debug) {
            void var6_9;
            System.out.println("WORKER - Parameters of execution:");
            System.out.println("  * Method type: " + (Object)((Object)this.methodType));
            System.out.println("  * Method definition: " + this.impl.getMethodDefinition());
            System.out.print("  * Parameter types:");
            boolean bl2 = false;
            while (var6_9 < this.types.length) {
                System.out.print(" " + this.types[var6_9].getName());
                ++var6_9;
            }
            System.out.println("");
            System.out.print("  * Parameter values:");
            for (Object object : this.values) {
                System.out.print(" " + object);
            }
            System.out.println("");
            System.out.print("  * Parameter streams:");
            for (Stream stream : this.streams) {
                System.out.print(" " + stream.name());
            }
            System.out.println("");
            System.out.print("  * Parameter prefixes:");
            for (String string : this.prefixes) {
                System.out.print(" " + string);
            }
            System.out.println("");
            System.out.println("  * Has Target: " + this.hasTarget);
            System.out.println("  * Has Return: " + this.hasReturn);
        }
        this.retValue = null;
    }

    public void processTask() throws JobExecutionException {
        this.retValue = this.invoke();
        this.checkSCOPersistence();
        this.writeUpdatedParameters();
    }

    public void serializeBinaryExitValue() throws JobExecutionException {
        LOGGER.debug("Checking binary exit value serialization");
        NIOParam lastParam = this.nt.getParams().getLast();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("- Param Type: " + lastParam.getType().name());
            LOGGER.debug("- Preserve source data: " + lastParam.isPreserveSourceData());
            LOGGER.debug("- Write final value: " + lastParam.isWriteFinalValue());
            LOGGER.debug("- Prefix: " + lastParam.getPrefix());
        }
        if (lastParam.getType().equals((Object)DataType.FILE_T) && !lastParam.isPreserveSourceData() && lastParam.isWriteFinalValue() && lastParam.getPrefix().equals("#")) {
            String renaming = lastParam.getOriginalName();
            LOGGER.info("Writing Binary Exit Value (" + this.retValue.toString() + ") to " + renaming);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(renaming));){
                String value = "0000I" + this.retValue.toString() + "\n.\n";
                writer.write(value);
                writer.flush();
            }
            catch (IOException ioe) {
                throw new JobExecutionException("ERROR: Cannot serialize binary exit value for bindings", ioe);
            }
        }
    }

    private void processParameter(NIOParam np, int i) throws JobExecutionException {
        this.streams[i] = np.getStream();
        this.prefixes[i] = np.getPrefix();
        switch (np.getType()) {
            case BOOLEAN_T: {
                this.types[i] = Boolean.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case CHAR_T: {
                this.types[i] = Character.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case BYTE_T: {
                this.types[i] = Byte.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case SHORT_T: {
                this.types[i] = Short.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case INT_T: {
                this.types[i] = Integer.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case LONG_T: {
                this.types[i] = Long.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case FLOAT_T: {
                this.types[i] = Float.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case DOUBLE_T: {
                this.types[i] = Double.TYPE;
                this.values[i] = np.getValue();
                break;
            }
            case STRING_T: {
                this.types[i] = String.class;
                this.values[i] = np.getValue();
                break;
            }
            case FILE_T: {
                this.types[i] = String.class;
                this.values[i] = np.getOriginalName();
                this.writeFinalValue[i] = np.isWriteFinalValue();
                break;
            }
            case OBJECT_T: {
                Object obj;
                this.renamings[i] = np.getValue().toString();
                this.writeFinalValue[i] = np.isWriteFinalValue();
                try {
                    obj = this.nw.getObject(this.renamings[i]);
                }
                catch (SerializedObjectException soe) {
                    throw new JobExecutionException(ERROR_SERIALIZED_OBJ, soe);
                }
                if (obj == null) {
                    try {
                        obj = this.nw.getPersistentObject(this.renamings[i]);
                    }
                    catch (StorageException se) {
                        throw new JobExecutionException(ERROR_SERIALIZED_OBJ, se);
                    }
                }
                if (obj == null) {
                    StringBuilder sb = new StringBuilder();
                    if (this.hasTarget && i == this.numParams - 1) {
                        sb.append("Target object");
                    } else {
                        sb.append("Object parameter ").append(i);
                    }
                    sb.append(" with renaming ").append(this.renamings[i]);
                    sb.append(" in MethodDefinition ").append(this.impl.getMethodDefinition());
                    sb.append(" is null!").append("\n");
                    throw new JobExecutionException(sb.toString());
                }
                if (this.hasTarget && i == this.numParams - 1) {
                    this.target.setValue(obj);
                    break;
                }
                this.types[i] = obj.getClass();
                this.values[i] = obj;
                break;
            }
            case PSCO_T: {
                Object obj;
                this.renamings[i] = np.getValue().toString();
                this.writeFinalValue[i] = np.isWriteFinalValue();
                String id = this.renamings[i];
                try {
                    obj = this.nw.getPersistentObject(id);
                }
                catch (StorageException e) {
                    throw new JobExecutionException("ERROR: Cannot getById persistent object with id " + id, e);
                }
                if (obj == null) {
                    StringBuilder sb = new StringBuilder();
                    if (this.hasTarget && i == this.numParams - 1) {
                        sb.append("Target PSCO");
                    } else {
                        sb.append("PSCO parameter ").append(i);
                    }
                    sb.append(" with renaming ").append(this.renamings[i]);
                    sb.append(" in MethodDefinition ").append(this.impl.getMethodDefinition());
                    sb.append(" is null!").append("\n");
                    throw new JobExecutionException(sb.toString());
                }
                if (this.hasTarget && i == this.numParams - 1) {
                    this.target.setValue(obj);
                    break;
                }
                this.types[i] = obj.getClass();
                this.values[i] = obj;
                break;
            }
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                this.types[i] = String.class;
                this.values[i] = np.getValue();
                this.writeFinalValue[i] = np.isWriteFinalValue();
                break;
            }
            default: {
                throw new JobExecutionException(ERROR_UNKNOWN_TYPE + (Object)((Object)np.getType()));
            }
        }
        this.isFile[i] = np.getType().equals((Object)DataType.FILE_T);
        this.canBePSCO[i] = np.getType().equals((Object)DataType.OBJECT_T) || np.getType().equals((Object)DataType.PSCO_T);
    }

    private void checkSCOPersistence() {
        for (int i = 0; i < this.numParams; ++i) {
            if (!this.canBePSCO[i] || !this.writeFinalValue[i]) continue;
            Object obj = null;
            obj = this.hasTarget && i == this.numParams - 1 ? this.target.getValue() : this.values[i];
            String id = null;
            try {
                StubItf psco = (StubItf)obj;
                id = psco.getID();
            }
            catch (Exception e) {
                id = null;
            }
            if (id == null) continue;
            this.nw.storePersistentObject(id, obj);
            if (this.hasTarget && i == this.numParams - 1) {
                this.target.setValue(id);
            } else {
                this.values[i] = id;
            }
            this.nt.getParams().get(i).setType(DataType.PSCO_T);
            this.nt.getParams().get(i).setValue(id);
            this.writeFinalValue[i] = false;
        }
        if (this.hasReturn && this.retValue != null) {
            String id = null;
            try {
                StubItf psco = (StubItf)this.retValue;
                id = psco.getID();
            }
            catch (Exception e) {
                id = null;
            }
            if (id != null) {
                this.nt.getParams().getLast().setType(DataType.PSCO_T);
                this.nt.getParams().getLast().setValue(id);
            }
        }
    }

    private void writeUpdatedParameters() {
        block3: for (int i = 0; i < this.numParams; ++i) {
            if (!this.writeFinalValue[i]) continue;
            switch (this.nt.getParams().get(i).getType()) {
                case FILE_T: {
                    this.nw.storeObject(this.renamings[i], this.nt.getParams().get(i).getValue());
                    continue block3;
                }
                default: {
                    Object res = this.hasTarget && i == this.numParams - 1 ? this.target.getValue() : this.values[i];
                    this.nt.getParams().get(i).setValue(res);
                    this.nw.storeObject(this.renamings[i], res);
                }
            }
        }
        if (this.hasReturn && this.retValue != null) {
            String renaming = (String)this.nt.getParams().getLast().getValue();
            if (this.debug) {
                LOGGER.debug("Store return value " + this.retValue + " as " + renaming);
            }
            this.nw.storeObject(renaming.substring(renaming.lastIndexOf(47) + 1), this.retValue);
        }
    }

    private Object invoke() throws JobExecutionException {
        this.emitStartTask();
        try {
            Object object = this.invokeMethod();
            return object;
        }
        catch (JobExecutionException jee) {
            throw jee;
        }
        finally {
            this.emitEndTask();
        }
    }

    private void emitStartTask() {
        int taskType = this.nt.getTaskType() + 1;
        int taskId = this.nt.getTaskId();
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEventAndCounters(taskType, NIOTracer.getTaskEventsType());
            NIOTracer.emitEvent(taskId, NIOTracer.getTaskSchedulingType());
        }
    }

    private void emitEndTask() {
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEventAndCounters(0, NIOTracer.getTaskEventsType());
            NIOTracer.emitEvent(0L, NIOTracer.getTaskSchedulingType());
        }
    }

    public abstract Object invokeMethod() throws JobExecutionException;
}

