/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.operation;

import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.DataOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobTransfersListener
extends EventListener {
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.FileTransferManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final ExecutionAction execution;

    public JobTransfersListener(ExecutionAction execution) {
        this.execution = execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        if (finished) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEnd(DataOperation fOp) {
        boolean enabled;
        boolean failed;
        boolean finished;
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.doFailures();
            } else {
                this.doReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        boolean enabled;
        boolean finished;
        if (DEBUG) {
            LOGGER.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is JOB_FILE, operation end state is FAILED", (Throwable)e);
        } else {
            LOGGER.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOp.getName() + ", file role is JOB_FILE operation end state is FAILED");
        }
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.doFailures();
        }
    }

    private void doReady() {
        this.execution.doSubmit(this.getId());
    }

    private void doFailures() {
        this.execution.failedTransfers(this.errors);
    }
}

