/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.util.CEIParser;
import es.bsc.compss.util.ResourceManager;
import java.util.List;
import java.util.concurrent.Semaphore;

public class UpdateLocalCEIRequest
extends TDRequest {
    private final Class<?> ceiClass;
    private final Semaphore sem;

    public UpdateLocalCEIRequest(Class<?> ceiClass, Semaphore sem) {
        this.ceiClass = ceiClass;
        this.sem = sem;
    }

    public Class<?> getCeiClass() {
        return this.ceiClass;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        LOGGER.debug("Treating request to update core elements");
        List<Integer> newCores = CEIParser.loadJava(this.ceiClass);
        if (DEBUG) {
            LOGGER.debug("New methods: " + newCores);
        }
        ResourceManager.coreElementUpdates(newCores);
        ts.coreElementsUpdated();
        LOGGER.debug("Data structures resized and CE-resources links updated");
        this.sem.release();
    }

    @Override
    public TDRequest.TDRequestType getType() {
        return TDRequest.TDRequestType.UPDATE_CEI_LOCAL;
    }
}

