/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class IngressRuleToIpPermission
implements Function<IngressRule, IpPermission> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Override
    public IpPermission apply(IngressRule rule) {
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(IpProtocol.fromValue(rule.getProtocol()));
        builder.fromPort(rule.getStartPort());
        builder.toPort(rule.getEndPort());
        if (rule.getCIDR() != null) {
            builder.cidrBlock(rule.getCIDR());
        }
        if (rule.getSecurityGroupName() != null && rule.getAccount() != null) {
            builder.tenantIdGroupNamePair(rule.getAccount(), rule.getSecurityGroupName());
        }
        return builder.build();
    }
}

