/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class TemplateBuilderSpec {
    protected static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    protected static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    protected static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("hardwareId", new HardwareIdParser()).put("minCores", (HardwareIdParser)((Object)new MinCoresParser())).put("minRam", (HardwareIdParser)((Object)new MinRamParser())).put("minDisk", (HardwareIdParser)((Object)new MinDiskParser())).put("hypervisorMatches", (HardwareIdParser)((Object)new HypervisorMatchesMatchesParser())).put("imageId", (HardwareIdParser)((Object)new ImageIdParser())).put("imageNameMatches", (HardwareIdParser)((Object)new ImageNameMatchesParser())).put("osFamily", (HardwareIdParser)((Object)new OsFamilyParser())).put("osVersionMatches", (HardwareIdParser)((Object)new OsVersionMatchesParser())).put("os64Bit", (HardwareIdParser)((Object)new Os64BitParser())).put("osArchMatches", (HardwareIdParser)((Object)new OsArchMatchesParser())).put("osDescriptionMatches", (HardwareIdParser)((Object)new OsDescriptionMatchesParser())).put("loginUser", (HardwareIdParser)((Object)new LoginUserParser())).put("authenticateSudo", (HardwareIdParser)((Object)new AuthenticateSudoParser())).put("locationId", (HardwareIdParser)((Object)new LocationIdParser())).build();
    @VisibleForTesting
    String hardwareId;
    @VisibleForTesting
    Double minCores;
    @VisibleForTesting
    Integer minRam;
    @VisibleForTesting
    Double minDisk;
    @VisibleForTesting
    String hypervisorMatches;
    @VisibleForTesting
    String imageId;
    @VisibleForTesting
    String imageNameMatches;
    @VisibleForTesting
    OsFamily osFamily;
    @VisibleForTesting
    String osVersionMatches;
    @VisibleForTesting
    Boolean os64Bit;
    @VisibleForTesting
    String osArchMatches;
    @VisibleForTesting
    String osDescriptionMatches;
    @VisibleForTesting
    String loginUser;
    @VisibleForTesting
    Boolean authenticateSudo;
    @VisibleForTesting
    String locationId;
    protected transient String specification;

    protected TemplateBuilderSpec() {
    }

    protected TemplateBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static TemplateBuilderSpec parse(String templateBuilderSpecification) {
        TemplateBuilderSpec spec = new TemplateBuilderSpec(templateBuilderSpecification);
        if (!templateBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(templateBuilderSpecification)) {
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                Preconditions.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Preconditions.checkArgument(valueParser != null, "unknown key %s", key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public TemplateBuilder copyTo(TemplateBuilder builder, TemplateOptions templateOptions) {
        if (this.hardwareId != null) {
            builder.hardwareId(this.hardwareId);
        }
        if (this.minCores != null) {
            builder.minCores(this.minCores);
        }
        if (this.minRam != null) {
            builder.minRam(this.minRam);
        }
        if (this.minDisk != null) {
            builder.minDisk(this.minDisk);
        }
        if (this.hypervisorMatches != null) {
            builder.hypervisorMatches(this.hypervisorMatches);
        }
        if (this.imageId != null) {
            builder.imageId(this.imageId);
        }
        if (this.imageNameMatches != null) {
            builder.imageNameMatches(this.imageNameMatches);
        }
        if (this.osFamily != null) {
            builder.osFamily(this.osFamily);
        }
        if (this.osVersionMatches != null) {
            builder.osVersionMatches(this.osVersionMatches);
        }
        if (this.os64Bit != null) {
            builder.os64Bit(this.os64Bit);
        }
        if (this.osArchMatches != null) {
            builder.osArchMatches(this.osArchMatches);
        }
        if (this.osDescriptionMatches != null) {
            builder.osDescriptionMatches(this.osDescriptionMatches);
        }
        if (this.loginUser != null) {
            LoginCredentials.Builder loginBuilder = LoginCredentials.builder();
            int pos = this.loginUser.indexOf(58);
            if (pos != -1) {
                loginBuilder.user(this.loginUser.substring(0, pos)).password(this.loginUser.substring(pos + 1));
            } else {
                loginBuilder.user(this.loginUser);
            }
            if (this.authenticateSudo != null) {
                loginBuilder.authenticateSudo(this.authenticateSudo);
            }
            LoginCredentials creds = loginBuilder.build();
            templateOptions.overrideLoginCredentials(creds);
        }
        if (this.locationId != null) {
            builder.locationId(this.locationId);
        }
        return builder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.hardwareId, this.minCores, this.minRam, this.hypervisorMatches, this.imageId, this.imageNameMatches, this.osFamily, this.osVersionMatches, this.os64Bit, this.osArchMatches, this.osDescriptionMatches, this.loginUser, this.authenticateSudo, this.locationId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemplateBuilderSpec)) {
            return false;
        }
        TemplateBuilderSpec that = (TemplateBuilderSpec)obj;
        return Objects.equal(this.hardwareId, that.hardwareId) && Objects.equal(this.minCores, that.minCores) && Objects.equal(this.minRam, that.minRam) && Objects.equal(this.hypervisorMatches, that.hypervisorMatches) && Objects.equal(this.imageId, that.imageId) && Objects.equal(this.imageNameMatches, that.imageNameMatches) && Objects.equal((Object)this.osFamily, (Object)that.osFamily) && Objects.equal(this.osVersionMatches, that.osVersionMatches) && Objects.equal(this.os64Bit, that.os64Bit) && Objects.equal(this.osArchMatches, that.osArchMatches) && Objects.equal(this.osDescriptionMatches, that.osDescriptionMatches) && Objects.equal(this.loginUser, that.loginUser) && Objects.equal(this.authenticateSudo, that.authenticateSudo) && Objects.equal(this.locationId, that.locationId);
    }

    public String getHardwareId() {
        return this.hardwareId;
    }

    public Double getMinCores() {
        return this.minCores;
    }

    public Integer getMinRam() {
        return this.minRam;
    }

    public String getHypervisorMatches() {
        return this.hypervisorMatches;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImageNameMatches() {
        return this.imageNameMatches;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public String getOsVersionMatches() {
        return this.osVersionMatches;
    }

    public Boolean getOs64Bit() {
        return this.os64Bit;
    }

    public String getOsArchMatches() {
        return this.osArchMatches;
    }

    public String getOsDescriptionMatches() {
        return this.osDescriptionMatches;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public Boolean getAuthenticateSudo() {
        return this.authenticateSudo;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public String getSpecification() {
        return this.specification;
    }

    static class LocationIdParser
    extends StringParser {
        LocationIdParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.locationId == null, "location id was already set to ", spec.locationId);
            spec.locationId = value;
        }
    }

    static class AuthenticateSudoParser
    extends BooleanParser {
        AuthenticateSudoParser() {
        }

        @Override
        protected void parseBoolean(TemplateBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.loginUser != null, "login user must be set to use authenticateSudo");
            Preconditions.checkArgument(spec.authenticateSudo == null, "authenticate sudo was already set to ", spec.authenticateSudo);
            spec.authenticateSudo = value;
        }
    }

    static class LoginUserParser
    extends StringParser {
        LoginUserParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.loginUser == null, "login user was already set to ", spec.loginUser);
            spec.loginUser = value;
        }
    }

    static class OsDescriptionMatchesParser
    extends StringParser {
        OsDescriptionMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.osDescriptionMatches == null, "os description matches was already set to ", spec.osDescriptionMatches);
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            spec.osDescriptionMatches = value;
        }
    }

    static class OsArchMatchesParser
    extends StringParser {
        OsArchMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.osArchMatches == null, "os arch matches was already set to ", spec.osArchMatches);
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            spec.osArchMatches = value;
        }
    }

    static class Os64BitParser
    extends BooleanParser {
        Os64BitParser() {
        }

        @Override
        protected void parseBoolean(TemplateBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.os64Bit == null, "os 64 bit was already set to ", spec.os64Bit);
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            spec.os64Bit = value;
        }
    }

    static class OsVersionMatchesParser
    extends StringParser {
        OsVersionMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.osVersionMatches == null, "os version matches was already set to ", spec.osVersionMatches);
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            spec.osVersionMatches = value;
        }
    }

    static class OsFamilyParser
    extends EnumParser<OsFamily> {
        protected OsFamilyParser() {
            super(OsFamily.class);
        }

        @Override
        protected void parseEnum(TemplateBuilderSpec spec, OsFamily value) {
            Preconditions.checkArgument(spec.osFamily == null, "operating system family was already set to ", new Object[]{spec.osFamily});
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            spec.osFamily = value;
        }
    }

    static class ImageNameMatchesParser
    extends StringParser {
        ImageNameMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.imageNameMatches == null, "image name matches was already set to ", spec.imageNameMatches);
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            spec.imageNameMatches = value;
        }
    }

    static class ImageIdParser
    extends StringParser {
        ImageIdParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.imageId == null, "image id was already set to ", spec.imageId);
            Preconditions.checkArgument(spec.imageNameMatches == null, "image name matches was already set to ", spec.imageNameMatches);
            Preconditions.checkArgument(spec.osFamily == null, "operating system family was already set to ", new Object[]{spec.osFamily});
            Preconditions.checkArgument(spec.osVersionMatches == null, "os version matches was already set to ", spec.osVersionMatches);
            Preconditions.checkArgument(spec.os64Bit == null, "os 64 bit was already set to ", spec.os64Bit);
            Preconditions.checkArgument(spec.osArchMatches == null, "os arch matches was already set to ", spec.osArchMatches);
            Preconditions.checkArgument(spec.osDescriptionMatches == null, "os description matches was already set to ", spec.osDescriptionMatches);
            spec.imageId = value;
        }
    }

    static class HypervisorMatchesMatchesParser
    extends StringParser {
        HypervisorMatchesMatchesParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.hypervisorMatches == null, "hypervisor matches was already set to ", spec.hypervisorMatches);
            Preconditions.checkArgument(spec.hardwareId == null, "hardware id was already set to ", spec.hardwareId);
            spec.hypervisorMatches = value;
        }
    }

    static class MinDiskParser
    extends DoubleParser {
        MinDiskParser() {
        }

        @Override
        protected void parseDouble(TemplateBuilderSpec spec, double value) {
            Preconditions.checkArgument(spec.minDisk == null, "min disk was already set to ", spec.minDisk);
            Preconditions.checkArgument(spec.hardwareId == null, "hardware id was already set to ", spec.hardwareId);
            spec.minDisk = value;
        }
    }

    static class MinRamParser
    extends IntegerParser {
        MinRamParser() {
        }

        @Override
        protected void parseInteger(TemplateBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.minRam == null, "min ram was already set to ", spec.minRam);
            Preconditions.checkArgument(spec.hardwareId == null, "hardware id was already set to ", spec.hardwareId);
            spec.minRam = value;
        }
    }

    static class MinCoresParser
    extends DoubleParser {
        MinCoresParser() {
        }

        @Override
        protected void parseDouble(TemplateBuilderSpec spec, double value) {
            Preconditions.checkArgument(spec.minCores == null, "min cores was already set to ", spec.minCores);
            Preconditions.checkArgument(spec.hardwareId == null, "hardware id was already set to ", spec.hardwareId);
            spec.minCores = value;
        }
    }

    static class HardwareIdParser
    extends StringParser {
        HardwareIdParser() {
        }

        @Override
        protected void set(TemplateBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.hardwareId == null, "hardware id was already set to ", spec.hardwareId);
            Preconditions.checkArgument(spec.minCores == null, "min cores was already set to ", spec.minCores);
            Preconditions.checkArgument(spec.minRam == null, "min ram was already set to ", spec.minRam);
            Preconditions.checkArgument(spec.hypervisorMatches == null, "hypervisor matches was already set to ", spec.hypervisorMatches);
            spec.hardwareId = value;
        }
    }

    static abstract class BooleanParser
    implements ValueParser {
        BooleanParser() {
        }

        protected abstract void parseBoolean(TemplateBuilderSpec var1, boolean var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseBoolean(spec, Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be booleans", key, value), e);
            }
        }
    }

    static abstract class StringParser
    implements ValueParser {
        StringParser() {
        }

        protected abstract void set(TemplateBuilderSpec var1, String var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            this.set(spec, value);
        }
    }

    static abstract class EnumParser<E extends Enum<E>>
    implements ValueParser {
        private final Class<E> type;

        protected EnumParser(Class<E> type) {
            this.type = type;
        }

        protected abstract void parseEnum(TemplateBuilderSpec var1, E var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseEnum(spec, Enum.valueOf(this.type, value));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be a name in enum %s", key, value, this.type), e);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(TemplateBuilderSpec var1, int var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseInteger(spec, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    static abstract class DoubleParser
    implements ValueParser {
        DoubleParser() {
        }

        protected abstract void parseDouble(TemplateBuilderSpec var1, double var2);

        @Override
        public void parse(TemplateBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseDouble(spec, Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be double", key, value), e);
            }
        }
    }

    protected static interface ValueParser {
        public void parse(TemplateBuilderSpec var1, String var2, @Nullable String var3);
    }
}

