/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaGroupParticle;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.utils.CollectionFactory;
import org.apache.ws.commons.schema.utils.UtilObjects;
import org.apache.ws.commons.schema.utils.XmlSchemaNamed;
import org.apache.ws.commons.schema.utils.XmlSchemaNamedImpl;

public class XmlSchemaGroup
extends XmlSchemaAnnotated
implements XmlSchemaNamed,
XmlSchemaChoiceMember,
XmlSchemaSequenceMember {
    private XmlSchemaGroupParticle particle;
    private XmlSchemaNamedImpl namedDelegate;

    public XmlSchemaGroup(XmlSchema parent) {
        this.namedDelegate = new XmlSchemaNamedImpl(parent, true);
        final XmlSchema fParent = parent;
        CollectionFactory.withSchemaModifiable(new Runnable(){

            public void run() {
                fParent.getItems().add(XmlSchemaGroup.this);
            }
        });
    }

    public boolean equals(Object what) {
        boolean parentCheck = super.equals(what);
        if (!parentCheck) {
            return false;
        }
        if (!(what instanceof XmlSchemaGroup)) {
            return false;
        }
        XmlSchemaGroup xsg = (XmlSchemaGroup)what;
        boolean isParticleEq = UtilObjects.equals(this.particle, xsg.particle);
        boolean isNamedDelegateEq = UtilObjects.equals(this.namedDelegate, xsg.namedDelegate);
        return isParticleEq && isNamedDelegateEq;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.particle, this.namedDelegate});
        return hash ^= super.hashCode();
    }

    public XmlSchemaGroupParticle getParticle() {
        return this.particle;
    }

    public void setParticle(XmlSchemaGroupParticle particle2) {
        this.particle = particle2;
    }

    public String getName() {
        return this.namedDelegate.getName();
    }

    public XmlSchema getParent() {
        return this.namedDelegate.getParent();
    }

    public QName getQName() {
        return this.namedDelegate.getQName();
    }

    public boolean isAnonymous() {
        return this.namedDelegate.isAnonymous();
    }

    public boolean isTopLevel() {
        return this.namedDelegate.isTopLevel();
    }

    public void setName(String name) {
        final String fName = name;
        CollectionFactory.withSchemaModifiable(new Runnable(){

            public void run() {
                if (XmlSchemaGroup.this.namedDelegate.getQName() != null) {
                    XmlSchemaGroup.this.namedDelegate.getParent().getGroups().remove(XmlSchemaGroup.this.namedDelegate.getQName());
                }
                XmlSchemaGroup.this.namedDelegate.setName(fName);
                if (fName != null) {
                    XmlSchemaGroup.this.namedDelegate.getParent().getGroups().put(XmlSchemaGroup.this.namedDelegate.getQName(), XmlSchemaGroup.this);
                }
            }
        });
    }
}

