/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLPrematureCloseException;
import COM.claymoresystems.ptls.SSLuintX;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class SSLopaque
extends SSLPDU {
    int length;
    byte[] value;

    public SSLopaque(int l) {
        this.length = l;
    }

    public SSLopaque(int l, byte[] v) {
        this.length = l;
        this.value = v;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int encode(SSLConn conn, OutputStream s) throws Error, IOException {
        int written = 0;
        if (this.length < 0) {
            SSLuintX lu = new SSLuintX(-this.length, this.value.length);
            if (SSLDebug.getDebug(1)) {
                SSLDebug.debug(1, "Opaque <" + -1 * this.length + ">" + "length" + this.value.length);
            }
            written = lu.encode(conn, s);
        } else {
            if (SSLDebug.getDebug(1)) {
                SSLDebug.debug(1, "Opaque [" + this.length + "]");
            }
            if (this.length != this.value.length) {
                throw new Error("Array length doesn't match opaque size");
            }
        }
        s.write(this.value);
        return written += this.value.length;
    }

    public int decode(SSLConn conn, InputStream s) throws IOException {
        int readb = 0;
        if (this.length < 0) {
            SSLuintX lu = new SSLuintX(-this.length);
            readb = lu.decode(conn, s);
            if (lu.value > -this.length) {
                throw new IOException("Opaque length " + lu.value + " > maximum size " + -this.length);
            }
            this.value = new byte[lu.value];
        } else {
            this.value = new byte[this.length];
        }
        int off = 0;
        int left = this.value.length;
        while (left > 0) {
            int rb = s.read(this.value, off, left);
            if (rb < 0) {
                throw new SSLPrematureCloseException("Short read");
            }
            off += rb;
            left -= rb;
        }
        return readb + this.value.length;
    }

    public void print(SSLConn conn, PrintWriter w) {
        w.print("Opaque ");
        if (this.length < 0) {
            w.print("max (" + -1 * this.length + ")");
        }
        w.println("length " + this.value.length);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

