/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.logging.Logger;

@Singleton
public class VirtualMachineRunning
implements Predicate<VirtualMachine> {
    private final CloudStackApi client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public VirtualMachineRunning(CloudStackApi client) {
        this.client = client;
    }

    @Override
    public boolean apply(VirtualMachine virtualMachine) {
        this.logger.trace("looking for state on virtualMachine %s", Preconditions.checkNotNull(virtualMachine, "virtualMachine"));
        virtualMachine = this.refresh(virtualMachine);
        if (virtualMachine == null) {
            return false;
        }
        this.logger.trace("%s: looking for virtualMachine state %s: currently: %s", new Object[]{virtualMachine.getId(), VirtualMachine.State.RUNNING, virtualMachine.getState()});
        if (virtualMachine.getState() == VirtualMachine.State.ERROR) {
            throw new IllegalStateException("virtualMachine in error state: " + virtualMachine);
        }
        return virtualMachine.getState() == VirtualMachine.State.RUNNING;
    }

    private VirtualMachine refresh(VirtualMachine virtualMachine) {
        return this.client.getVirtualMachineApi().getVirtualMachine(virtualMachine.getId());
    }
}

