/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.javax.annotation.Nullable;

public class JobProperties
implements Comparable<JobProperties> {
    private final long id;
    private final Date updatedOn;
    private final JobState state;
    private final String note;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromJobProperties(this);
    }

    @ConstructorProperties(value={"id", "updatedon", "state", "note"})
    protected JobProperties(long id, Date updatedOn, JobState state, @Nullable String note) {
        this.id = id;
        this.updatedOn = Preconditions.checkNotNull(updatedOn, "updatedOn");
        this.state = Preconditions.checkNotNull(state, "state");
        this.note = note;
    }

    public long getId() {
        return this.id;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public JobState getState() {
        return this.state;
    }

    @Nullable
    public String getNote() {
        return this.note;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.updatedOn, this.state, this.note});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobProperties that = (JobProperties)JobProperties.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.updatedOn, that.updatedOn) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal(this.note, that.note);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("updatedOn", this.updatedOn).add("state", (Object)this.state).add("note", this.note);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(JobProperties o) {
        return Longs.compare(this.id, o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected Date updatedOn;
        protected JobState state;
        protected String note;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T updatedOn(Date updatedOn) {
            this.updatedOn = updatedOn;
            return this.self();
        }

        public T state(JobState state) {
            this.state = state;
            return this.self();
        }

        public T note(String note) {
            this.note = note;
            return this.self();
        }

        public JobProperties build() {
            return new JobProperties(this.id, this.updatedOn, this.state, this.note);
        }

        public T fromJobProperties(JobProperties in) {
            return ((Builder)((Builder)((Builder)this.id(in.getId())).updatedOn(in.getUpdatedOn())).state(in.getState())).note(in.getNote());
        }
    }
}

