/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.AdvertService;
import org.gridlab.gat.engine.Adaptor;
import org.gridlab.gat.engine.util.NoInfoLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptorInvocationHandler
implements InvocationHandler {
    protected static Logger logger = LoggerFactory.getLogger(AdaptorInvocationHandler.class);
    static final boolean OPTIMIZE_ADAPTOR_POLICY = true;
    private List<Adaptor> adaptors = new ArrayList<Adaptor>();
    private Map<Adaptor, Object> instantiatedAdaptors = new HashMap<Adaptor, Object>();

    public AdaptorInvocationHandler(List<Adaptor> adaptors, GATContext context, Class<?>[] parameterTypes, Object[] params, boolean singleInstance) throws GATObjectCreationException {
        if (adaptors.size() == 0) {
            throw new GATObjectCreationException("no adaptors could be loaded for this object");
        }
        GATObjectCreationException e = new GATObjectCreationException("No adaptors could be successfully instantiated");
        URI param = null;
        if (params != null) {
            for (Object p : params) {
                if (!(p instanceof URI)) continue;
                param = (URI)p;
                break;
            }
        }
        for (Adaptor adaptor : adaptors) {
            try {
                if (adaptor.matchScheme(param)) {
                    this.instantiatedAdaptors.put(adaptor, this.initAdaptor(adaptor, context, parameterTypes, params));
                    this.adaptors.add(adaptor);
                    if (!singleInstance) continue;
                    break;
                }
                e.add(adaptor.adaptorName, (Throwable)new AdaptorNotApplicableException("cannot handle this URI: " + param));
            }
            catch (Throwable t) {
                e.add(adaptor.adaptorName, t);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Instantiation of " + adaptor.adaptorName + " failed", t);
            }
        }
        if (this.instantiatedAdaptors.size() == 0) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method m, Object[] params) throws Throwable {
        GATInvocationException e = new GATInvocationException();
        if (this.instantiatedAdaptors == null) {
            throw new GATInvocationException("no adaptor available for method " + m);
        }
        String loggerString = "";
        for (Adaptor adaptor : this.adaptors) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(adaptor.adaptorClass.getClassLoader());
                String paramString = "";
                if (params != null) {
                    for (Object param : params) {
                        paramString = paramString + param + ", ";
                    }
                    if (paramString.endsWith(", ")) {
                        paramString = paramString.substring(0, paramString.length() - 2);
                    }
                }
                loggerString = loggerString + adaptor.getCpi() + " (" + this.instantiatedAdaptors.get(adaptor) + ")." + m.getName() + "(" + paramString + ") -> " + adaptor.getShortAdaptorClassName();
                Object res = m.invoke(this.instantiatedAdaptors.get(adaptor), params);
                if (logger.isInfoEnabled()) {
                    if (adaptor.getAdaptorClass().getMethod(m.getName(), m.getParameterTypes()).isAnnotationPresent(NoInfoLogging.class)) {
                        logger.debug(loggerString + " SUCCESS");
                    } else {
                        logger.info(loggerString + " SUCCESS");
                    }
                }
                Object object = res;
                return object;
            }
            catch (Throwable t) {
                while (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof NoSuchElementException && this.instantiatedAdaptors.get(adaptor) instanceof AdvertService) {
                    throw t;
                }
                e.add(adaptor.getShortAdaptorClassName(), loggerString, t);
                if (!logger.isInfoEnabled()) continue;
                if (adaptor.getAdaptorClass().getMethod(m.getName(), m.getParameterTypes()).isAnnotationPresent(NoInfoLogging.class)) {
                    logger.debug(loggerString + " FAILED (" + t + ")");
                    continue;
                }
                logger.info(loggerString + " FAILED (" + t + ")");
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("invoke: No adaptor could be invoked.");
        }
        throw e;
    }

    private Object initAdaptor(Adaptor adaptor, GATContext gatContext, Class<?>[] parameterTypes, Object[] parameters) throws GATObjectCreationException {
        Object result;
        if (parameters == null) {
            parameters = new Object[]{};
        }
        Object[] newParameters = new Object[parameters.length + 1];
        Class[] newParameterTypes = new Class[newParameters.length];
        newParameters[0] = gatContext;
        newParameterTypes[0] = GATContext.class;
        for (int i = 0; i < parameters.length; ++i) {
            newParameters[i + 1] = parameters[i];
            newParameterTypes[i + 1] = parameterTypes[i];
        }
        if (logger.isTraceEnabled()) {
            logger.trace("adaptor instantiation: " + adaptor.getShortAdaptorClassName() + " for type " + adaptor.getCpi() + " START");
        }
        try {
            result = adaptor.newInstance(newParameterTypes, newParameters);
        }
        catch (Throwable t) {
            GATObjectCreationException exc;
            if (logger.isDebugEnabled()) {
                logger.debug("adaptor instantiation: " + adaptor.getShortAdaptorClassName() + " for type " + adaptor.getCpi() + " FAILED", t);
            }
            if (t instanceof GATObjectCreationException) {
                exc = (GATObjectCreationException)t;
            } else {
                exc = new GATObjectCreationException();
                exc.add(adaptor.toString(), t);
            }
            throw exc;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("adaptor instantiation: " + adaptor.getShortAdaptorClassName() + " for type " + adaptor.getCpi() + " SUCCESS");
        }
        return result;
    }
}

