/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;
import org.gridlab.gat.resources.HardwareResource;
import org.gridlab.gat.resources.HardwareResourceDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrappedJobCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobCpi
extends MonitorableCpi
implements Job {
    protected static Logger logger = LoggerFactory.getLogger(JobCpi.class);
    protected GATContext gatContext;
    protected JobDescription jobDescription;
    protected Sandbox sandbox;
    protected GATInvocationException postStageException = null;
    protected GATInvocationException deleteException = null;
    protected GATInvocationException wipeException = null;
    protected GATInvocationException removeSandboxException = null;
    protected static int globalJobID = 0;
    protected Job.JobState state = Job.JobState.INITIAL;
    protected long submissiontime;
    protected long starttime;
    protected long stoptime;
    protected static ArrayList<Job> jobList = new ArrayList();
    protected static boolean shutdownInProgress = false;
    protected static boolean shutdownDone = false;
    protected final int jobID = JobCpi.allocJobID();

    protected static synchronized int allocJobID() {
        return globalJobID++;
    }

    protected JobCpi(GATContext gatContext) {
        this.gatContext = gatContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected JobCpi(GATContext gatContext, JobDescription jobDescription, Sandbox sandbox) {
        this(gatContext);
        this.jobDescription = jobDescription;
        this.sandbox = sandbox;
        boolean stopOnExit = true;
        Preferences prefs = gatContext.getPreferences();
        if (prefs.containsKey("job.stop.on.exit") && prefs.get("job.stop.on.exit").equals("false")) {
            stopOnExit = false;
        }
        if (jobDescription != null && !jobDescription.getSoftwareDescription().getBooleanAttribute("job.stop.on.exit", true)) {
            stopOnExit = false;
        }
        if (stopOnExit && !(this instanceof WrappedJobCpi)) {
            Class<JobCpi> clazz = JobCpi.class;
            // MONITORENTER : org.gridlab.gat.resources.cpi.JobCpi.class
            if (shutdownInProgress) {
                throw new Error("jobCpi: cannot create new jobs when shutdown is in progress");
            }
            jobList.add(this);
            // MONITOREXIT : clazz
        }
        if (!logger.isDebugEnabled()) return;
        logger.debug("Created job " + this);
    }

    public final int getJobID() {
        return this.jobID;
    }

    public final void unSchedule() throws GATInvocationException {
        this.stop();
    }

    public void stop() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, Object> getInfo() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void checkpoint() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void migrate() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void migrate(HardwareResourceDescription hardwareResourceDescription) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Job cloneJob(HardwareResource resource) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void hold() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void resume() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getExitStatus() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        return "job " + this.getClass().getName() + ", id is " + this.jobID;
    }

    public InputStream getStdout() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public InputStream getStderr() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OutputStream getStdin() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public final JobDescription getJobDescription() {
        return this.jobDescription;
    }

    public synchronized Job.JobState getState() {
        return this.state;
    }

    public synchronized void setStartTime() {
        this.starttime = System.currentTimeMillis();
    }

    public synchronized void setSubmissionTime() {
        this.submissiontime = System.currentTimeMillis();
    }

    public synchronized void setStopTime() {
        this.stoptime = System.currentTimeMillis();
    }

    public String marshal() {
        throw new UnsupportedOperationException("marshalling of this object is not supported by this adaptor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished() {
        Class<JobCpi> clazz = JobCpi.class;
        synchronized (JobCpi.class) {
            if (jobList.contains(this)) {
                jobList.remove(this);
                if (logger.isDebugEnabled()) {
                    logger.debug("Finished job " + this);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Finished non-existent job? " + this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void end() {
        new JobShutdownHook().run();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new JobShutdownHook());
    }

    static class JobShutdownHook
    extends Thread {
        JobShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Class<JobCpi> clazz = JobCpi.class;
            // MONITORENTER : org.gridlab.gat.resources.cpi.JobCpi.class
            if (shutdownInProgress) {
                while (true) {
                    if (shutdownDone) {
                        // MONITOREXIT : clazz
                        return;
                    }
                    try {
                        JobCpi.class.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            shutdownInProgress = true;
            // MONITOREXIT : clazz
            while (true) {
                Class<JobCpi> clazz2 = JobCpi.class;
                // MONITORENTER : org.gridlab.gat.resources.cpi.JobCpi.class
                if (jobList.size() == 0) {
                    // MONITOREXIT : clazz2
                    clazz = JobCpi.class;
                    // MONITORENTER : org.gridlab.gat.resources.cpi.JobCpi.class
                    shutdownDone = true;
                    JobCpi.class.notifyAll();
                    // MONITOREXIT : clazz
                    return;
                }
                Job j = jobList.remove(0);
                // MONITOREXIT : clazz2
                if (logger.isInfoEnabled()) {
                    logger.info("stopping job: " + j);
                }
                try {
                    j.stop();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

