/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInfo
extends DataInfo {
    private final DataLocation origLocation;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");

    public FileInfo(DataLocation loc) {
        this.origLocation = loc;
    }

    public DataLocation getOriginalLocation() {
        return this.origLocation;
    }

    @Override
    public boolean delete() {
        LOGGER.debug("[FileInfo] Deleting file of data " + this.getDataId());
        DataVersion firstVersion = this.getFirstVersion();
        if (firstVersion != null) {
            LogicalData ld = Comm.getData(firstVersion.getDataInstanceId().getRenaming());
            if (ld != null) {
                for (DataLocation loc : ld.getLocations()) {
                    MultiURI uri = loc.getURIInHost(Comm.getAppHost());
                    if (uri == null || !loc.equals(this.origLocation)) continue;
                    this.waitForEndingCopies(ld, loc);
                    String newPath = Comm.getAppHost().getTempDirPath() + File.separator + firstVersion.getDataInstanceId().getRenaming();
                    LOGGER.debug("[FileInfo] Modifying path in location " + loc + " with new path " + newPath);
                    loc.modifyPath(newPath);
                    try {
                        LOGGER.debug("[FileInfo] Moving " + uri.getPath() + " to " + newPath);
                        Files.move(new File(uri.getPath()).toPath(), new File(newPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        ErrorManager.error("File " + uri.getPath() + " cannot be moved to " + newPath, e);
                    }
                }
            }
        } else {
            LOGGER.debug("[FileInfo] First Version is null. Nothing to delete");
        }
        return super.delete();
    }

    private void waitForEndingCopies(LogicalData ld, DataLocation loc) {
        ld.lockHostRemoval();
        Collection<Copy> copiesInProgress = ld.getCopiesInProgress();
        if (copiesInProgress != null && !copiesInProgress.isEmpty()) {
            for (Copy copy : copiesInProgress) {
                if (!copy.getSourceData().equals(ld)) continue;
                LOGGER.debug("[FileInfo] Waiting for copy of data " + ld.getName() + " to finish...");
                Copy.waitForCopyTofinish(copy, Comm.getAppHost().getNode());
            }
        }
        ld.releaseHostRemoval();
    }
}

