/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.io.IOException;
import java.util.concurrent.Semaphore;

public class TransferOpenFileRequest
extends APRequest {
    private DataAccessId faId;
    private DataLocation location;
    private Semaphore sem;

    public TransferOpenFileRequest(DataAccessId faId, Semaphore sem) {
        this.faId = faId;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    public DataAccessId getFaId() {
        return this.faId;
    }

    public void setFaId(DataAccessId faId) {
        this.faId = faId;
    }

    public DataLocation getLocation() {
        return this.location;
    }

    public void setLocation(DataLocation location) {
        this.location = location;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        SimpleURI targetURI;
        String targetPath;
        String targetName;
        LOGGER.debug("Process TransferOpenFileRequest");
        if (this.faId instanceof DataAccessId.WAccessId) {
            DataAccessId.WAccessId waId = (DataAccessId.WAccessId)this.faId;
            DataInstanceId targetFile = waId.getWrittenDataInstance();
            targetName = targetFile.getRenaming();
            targetPath = Comm.getAppHost().getTempDirPath() + targetName;
        } else if (this.faId instanceof DataAccessId.RWAccessId) {
            DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)this.faId;
            targetName = rwaId.getWrittenDataInstance().getRenaming();
            targetPath = Comm.getAppHost().getTempDirPath() + targetName;
        } else {
            DataAccessId.RAccessId raId = (DataAccessId.RAccessId)this.faId;
            targetName = raId.getReadDataInstance().getRenaming();
            targetPath = Comm.getAppHost().getTempDirPath() + targetName;
        }
        LOGGER.debug("Openning file " + targetName + " at " + targetPath);
        DataLocation targetLocation = null;
        String pscoId = Comm.getData(targetName).getId();
        if (pscoId == null) {
            try {
                targetURI = new SimpleURI(DataLocation.Protocol.FILE_URI.getSchema() + targetPath);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
            }
            catch (IOException ioe) {
                ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
            }
        } else {
            try {
                targetURI = new SimpleURI(DataLocation.Protocol.PERSISTENT_URI.getSchema() + pscoId);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), targetURI);
            }
            catch (IOException ioe) {
                ErrorManager.error("ERROR: Invalid location URI " + targetPath, ioe);
            }
        }
        LOGGER.debug("Setting target location to " + targetLocation);
        this.setLocation(targetLocation);
        if (pscoId != null) {
            LOGGER.debug("External object detected. Auto-release");
            Comm.registerLocation(targetName, targetLocation);
            this.sem.release();
        } else if (this.faId instanceof DataAccessId.WAccessId) {
            LOGGER.debug("Write only mode. Auto-release");
            Comm.registerLocation(targetName, targetLocation);
            this.sem.release();
        } else if (this.faId instanceof DataAccessId.RWAccessId) {
            LOGGER.debug("RW mode. Asking for transfer");
            DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)this.faId;
            String srcName = rwaId.getReadDataInstance().getRenaming();
            Comm.getAppHost().getData(srcName, targetName, (LogicalData)null, (Transferable)new FileTransferable(), (EventListener)new OneOpWithSemListener(this.sem));
        } else {
            LOGGER.debug("Read only mode. Asking for transfer");
            DataAccessId.RAccessId raId = (DataAccessId.RAccessId)this.faId;
            String srcName = raId.getReadDataInstance().getRenaming();
            Comm.getAppHost().getData(srcName, srcName, (Transferable)new FileTransferable(), (EventListener)new OneOpWithSemListener(this.sem));
        }
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.TRANSFER_OPEN_FILE;
    }
}

