/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util.parsers;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.CoreManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IDLParser {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    private static final String CONSTR_LOAD_ERR = "Error loading constraints";
    private static final String CONSTRAINT_IDL = "@Constraints";
    private static final String IMPLEMENTS_IDL = "@Implements";
    private static final String PROCESSOR_IDL = "processors";
    private static final String CLASS_METHOD_SEPARATOR = "::";

    public static void parseIDLMethods(String constraintsFile) {
        LOGGER.debug("Loading file " + constraintsFile);
        try (BufferedReader br = new BufferedReader(new FileReader(constraintsFile));){
            String line;
            MethodResourceDescription defaultCtr = MethodResourceDescription.EMPTY_FOR_CONSTRAINTS.copy();
            boolean isReadingCodeRegion = false;
            StringBuilder structureString = new StringBuilder();
            Enum type = null;
            CImplementation implementation = null;
            MethodResourceDescription currConstraints = new MethodResourceDescription(defaultCtr);
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (isReadingCodeRegion && type != null) {
                    if (line.startsWith("//")) continue;
                    if (type.equals((Object)CodeRegion.COMMENT)) {
                        if (!line.endsWith("*/")) continue;
                        isReadingCodeRegion = false;
                        continue;
                    }
                    if (line.matches(".*[)];")) {
                        isReadingCodeRegion = false;
                        structureString.append(line);
                        if (type.equals((Object)CodeRegion.CONSTRAINT)) {
                            LOGGER.debug("[IDL Parser] Loading constraint: " + structureString.toString());
                            currConstraints = IDLParser.loadCConstraints(structureString.toString());
                            continue;
                        }
                        if (type.equals((Object)CodeRegion.IMPLEMENTATION)) {
                            LOGGER.debug("[IDL Parser] Loading implementation: " + structureString.toString());
                            implementation = IDLParser.loadCImplementation(structureString.toString());
                            continue;
                        }
                        if (!type.equals((Object)CodeRegion.FUNCTION)) continue;
                        LOGGER.debug("[IDL Parser] Loading function: " + structureString.toString() + " constraint:" + currConstraints);
                        IDLParser.parseCFunction(structureString.toString(), currConstraints, implementation);
                        currConstraints = new MethodResourceDescription(defaultCtr);
                        implementation = null;
                        continue;
                    }
                    structureString.append(line);
                    continue;
                }
                if (line.startsWith("//") || line.startsWith("#") || line.startsWith("/*") && line.endsWith("*/")) continue;
                if (line.startsWith("/*")) {
                    isReadingCodeRegion = true;
                    type = CodeRegion.COMMENT;
                    continue;
                }
                if (line.matches("@Constraints[(].*[)];")) {
                    LOGGER.debug("[IDL Parser] Loading constraint: " + line);
                    currConstraints = IDLParser.loadCConstraints(line);
                    continue;
                }
                if (line.matches("@Constraints[(].*")) {
                    isReadingCodeRegion = true;
                    structureString = new StringBuilder(line);
                    type = CodeRegion.CONSTRAINT;
                    continue;
                }
                if (line.matches("@Implements[(].*[)];")) {
                    LOGGER.debug("[IDL Parser] Loading implementation: " + line);
                    implementation = IDLParser.loadCImplementation(line);
                    continue;
                }
                if (line.matches("@Implements[(].*")) {
                    isReadingCodeRegion = true;
                    structureString = new StringBuilder(line);
                    type = CodeRegion.IMPLEMENTATION;
                    continue;
                }
                if (line.matches(".*[(].*[)];")) {
                    LOGGER.debug("[IDL Parser] Loading function: " + line + " constraint:" + currConstraints);
                    IDLParser.parseCFunction(line, currConstraints, implementation);
                    currConstraints = new MethodResourceDescription(defaultCtr);
                    implementation = null;
                    continue;
                }
                if (!line.matches(".*[(].*")) continue;
                isReadingCodeRegion = true;
                structureString = new StringBuilder(line);
                type = CodeRegion.FUNCTION;
            }
        }
        catch (IOException ioe) {
            LOGGER.fatal(CONSTR_LOAD_ERR, (Throwable)ioe);
        }
    }

    private static CImplementation loadCImplementation(String line) {
        int indexOfSeparator;
        if (line.startsWith(IMPLEMENTS_IDL)) {
            line = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
        }
        if ((indexOfSeparator = line.indexOf(CLASS_METHOD_SEPARATOR)) > 0) {
            String className = line.substring(0, indexOfSeparator);
            StringBuilder methodNameBuilder = new StringBuilder();
            methodNameBuilder.append(className).append(CLASS_METHOD_SEPARATOR).append(line.substring(indexOfSeparator + CLASS_METHOD_SEPARATOR.length()));
            String methodName = methodNameBuilder.toString();
            LOGGER.debug("New C method implementation:");
            LOGGER.debug("\t Classname: " + className);
            LOGGER.debug("\t Methodname: " + methodName);
            return new CImplementation(className, methodName);
        }
        return new CImplementation("NULL", line);
    }

    private static void parseCFunction(String line, MethodResourceDescription currConstraints, CImplementation implementation) {
        StringBuilder implementedTaskSignatureBuffer = new StringBuilder();
        StringBuilder implementationSignatureBuffer = new StringBuilder();
        if (line.startsWith("static ")) {
            line = line.replace("static ", "");
        }
        if (!line.startsWith("void ")) {
            // empty if block
        }
        line = line.replaceAll("[(|)|,|;|\n|\t]", " ");
        String[] splits = line.split("\\s+");
        CImplementation task = IDLParser.loadCImplementation(splits[1]);
        String methodName = task.getMethodName();
        String declaringClass = task.getClassName();
        if (implementation != null) {
            implementedTaskSignatureBuffer.append(implementation.getMethodName()).append("(");
        } else {
            implementedTaskSignatureBuffer.append(methodName).append("(");
        }
        implementationSignatureBuffer.append(methodName).append("(");
        for (int i = 2; i < splits.length; ++i) {
            String paramDirection = splits[i++];
            String paramType = splits[i++];
            String type = "BINDING_OBJECT_T";
            if (paramType.toUpperCase().compareTo("FILE") == 0) {
                type = "FILE_T";
            } else if (paramDirection.toUpperCase().compareTo("INOUT") == 0) {
                type = "BINDING_OBJECT_T";
            } else if (paramDirection.toUpperCase().compareTo("OUT") == 0) {
                type = "BINDING_OBJECT_T";
            } else if (paramType.compareTo("boolean") == 0) {
                type = "BOOLEAN_T";
            } else if (paramType.compareTo("char") == 0) {
                type = "CHAR_T";
            } else if (paramType.compareTo("int") == 0) {
                type = "INT_T";
            } else if (paramType.compareTo("float") == 0) {
                type = "FLOAT_T";
            } else if (paramType.compareTo("double") == 0) {
                type = "DOUBLE_T";
            } else if (paramType.compareTo("byte") == 0) {
                type = "BYTE_T";
            } else if (paramType.compareTo("short") == 0) {
                type = "SHORT_T";
            } else if (paramType.compareTo("long") == 0) {
                type = "LONG_T";
            } else if (paramType.compareTo("string") == 0) {
                type = "STRING_T";
            }
            implementedTaskSignatureBuffer.append(type).append(",");
            implementationSignatureBuffer.append(type).append(",");
        }
        implementedTaskSignatureBuffer.deleteCharAt(implementedTaskSignatureBuffer.lastIndexOf(","));
        implementationSignatureBuffer.deleteCharAt(implementationSignatureBuffer.lastIndexOf(","));
        implementedTaskSignatureBuffer.append(")");
        implementationSignatureBuffer.append(")");
        if (implementation != null) {
            implementedTaskSignatureBuffer.append(implementation.getClassName());
        } else {
            implementedTaskSignatureBuffer.append(declaringClass);
        }
        implementationSignatureBuffer.append(declaringClass);
        String taskSignature = implementedTaskSignatureBuffer.toString();
        String implementationSignature = implementationSignatureBuffer.toString();
        Integer coreId = CoreManager.registerNewCoreElement(taskSignature);
        if (coreId == null) {
            coreId = CoreManager.getCoreId(taskSignature);
        }
        LOGGER.debug("CoreId for task " + taskSignature + " is " + coreId);
        int implId = CoreManager.getNumberCoreImplementations(coreId);
        LinkedList<Implementation> newImpls = new LinkedList<Implementation>();
        MethodImplementation m = new MethodImplementation(declaringClass, methodName, coreId, implId, currConstraints);
        newImpls.add(m);
        LinkedList<String> newSigns = new LinkedList<String>();
        newSigns.add(implementationSignature);
        CoreManager.registerNewImplementations(coreId, newImpls, newSigns);
        LOGGER.debug("[IDL Parser] Adding implementation: " + declaringClass + "." + methodName + " for CE id " + coreId);
    }

    private static MethodResourceDescription loadCConstraints(String line) {
        line = line.substring(CONSTRAINT_IDL.length() + 1);
        String proc = new String();
        if (line.matches(".*processors.*")) {
            int procStart = line.indexOf("{");
            int procEnd = line.indexOf("}");
            proc = line.substring(procStart, procEnd + 1);
            line = line.replace(proc, "");
            line = line.replace("processors=", "");
            proc = proc.replaceAll("[{}]", "");
            LOGGER.debug("[IDL Parser] Loading processors: " + proc);
            line = line.replaceFirst(",", "");
        }
        line = line.replaceAll("[() ;\n\t]", "");
        String[] constraints = line.split(",");
        MethodResourceDescription mrd = new MethodResourceDescription(constraints, proc);
        return mrd;
    }

    private static class CImplementation {
        private final String className;
        private final String methodName;

        public CImplementation(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    private static enum CodeRegion {
        COMMENT,
        TASK,
        CONSTRAINT,
        FUNCTION,
        IMPLEMENTATION;

    }
}

