/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileOutputStreamCpi;

public class LocalFileOutputStreamAdaptor
extends FileOutputStreamCpi {
    FileOutputStream out;

    public static String getDescription() {
        return "The Local FileOutputStream Adaptor is a simple wrapper around the java.io.FileOutputStream object.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileOutputStreamCpi.getSupportedCapabilities();
        capabilities.put("close", true);
        capabilities.put("flush", true);
        capabilities.put("write", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"local", "file", ""};
    }

    public LocalFileOutputStreamAdaptor(GATContext gatContext, URI location, Boolean append) throws IOException, GATObjectCreationException {
        super(gatContext, location, append);
        if (!location.refersToLocalHost()) {
            throw new AdaptorNotApplicableException("Cannot use remote files with the local file output stream adaptor");
        }
        String path = location.getPath();
        File f = new File(path);
        this.out = new FileOutputStream(f, (boolean)append);
    }

    public void close() throws GATInvocationException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileOutputStream", (Throwable)e);
        }
    }

    public void flush() throws GATInvocationException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileOutputStream", (Throwable)e);
        }
    }

    public void write(byte[] b, int offset, int len) throws GATInvocationException {
        try {
            this.out.write(b, offset, len);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileOutputStream", (Throwable)e);
        }
    }

    public void write(byte[] arg0) throws GATInvocationException {
        try {
            this.out.write(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileOutputStream", (Throwable)e);
        }
    }

    public void write(int arg0) throws GATInvocationException {
        try {
            this.out.write(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileOutputStream", (Throwable)e);
        }
    }
}

