/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat;

import ibis.util.IPUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;

public class URI
implements Serializable,
Comparable<Object> {
    java.net.URI u;

    public URI(String s) throws URISyntaxException {
        this.u = new java.net.URI(new URIEncoder().encodeUri(s));
    }

    public URI(java.net.URI u) {
        this.u = u;
    }

    public URI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        this.u = new java.net.URI(scheme, userInfo, host, port, path, query, fragment);
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        this.u = new java.net.URI(scheme, authority, path, query, fragment);
    }

    public static URI create(String s) throws URISyntaxException {
        return new URI(s);
    }

    public boolean isLocal() {
        return this.u.getHost() == null || this.u.getHost().equals("localhost");
    }

    public boolean refersToLocalHost() {
        if (this.u.getPort() != -1) {
            return false;
        }
        String host = this.u.getHost();
        if (host == null) {
            return true;
        }
        if (host.equals("localhost")) {
            return true;
        }
        if (this.getLocalHostName().equals(host)) {
            return true;
        }
        if (this.getLocalCanonicalHostName().equals(host)) {
            return true;
        }
        String hostip = null;
        try {
            hostip = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e1) {
            return false;
        }
        InetAddress[] myAddresses = null;
        try {
            myAddresses = IPUtils.getLocalHostAddresses();
        }
        catch (UnknownHostException e) {
            return false;
        }
        for (InetAddress myAddress : myAddresses) {
            String myIP = myAddress.getHostAddress();
            if (hostip.equals(myIP)) {
                return true;
            }
            if (!myIP.equals(host)) continue;
            return true;
        }
        return false;
    }

    public String getPath() {
        String path = this.getUnresolvedPath();
        if (path == null) {
            return null;
        }
        if (this.u.getHost() != null && this.isCompatible("file") && this.refersToLocalHost() && !path.startsWith("/")) {
            String home = new File(System.getProperty("user.home")).toURI().getPath();
            if (home == null) {
                home = "";
            }
            path = home + path;
        }
        return path;
    }

    public String getUnresolvedPath() {
        String path = this.u.getPath();
        if (this.u.getScheme() != null && this.u.getHost() == null && this.u.getSchemeSpecificPart() != null) {
            path = this.u.getSchemeSpecificPart();
            if (path.startsWith("///")) {
                path = path.substring(3);
            }
            path = "/" + path;
        }
        if (path == null || path.equals("")) {
            return path;
        }
        if (this.u.getScheme() == null && this.u.getHost() == null) {
            return path;
        }
        return path.substring(1);
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof java.net.URI) {
            return this.u.compareTo((java.net.URI)other);
        }
        if (other instanceof URI) {
            return this.u.compareTo(((URI)other).u);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof URI) {
            return this.u.equals(((URI)o).u);
        }
        if (o instanceof java.net.URI) {
            return this.u.equals(o);
        }
        return false;
    }

    public String getAuthority() {
        return this.u.getAuthority();
    }

    public String getFragment() {
        return this.u.getFragment();
    }

    public String getHost() {
        return this.u.getHost();
    }

    public String resolveHost() {
        String host = this.getHost();
        if (host == null) {
            host = this.getLocalHostName();
        }
        if (host == null || host.length() == 0) {
            return "localhost";
        }
        return host;
    }

    public int getPort() {
        return this.u.getPort();
    }

    public int getPort(int defaultPort) {
        int port = this.getPort();
        if (port < 0) {
            return defaultPort;
        }
        return port;
    }

    public String getQuery() {
        return this.u.getQuery();
    }

    public String getRawAuthority() {
        return this.u.getRawAuthority();
    }

    public String getRawFragment() {
        return this.u.getRawFragment();
    }

    public String getRawPath() {
        return this.u.getRawPath();
    }

    public String getRawQuery() {
        return this.u.getRawQuery();
    }

    public String getRawSchemeSpecificPart() {
        return this.u.getRawSchemeSpecificPart();
    }

    public String getRawUserInfo() {
        return this.u.getRawUserInfo();
    }

    public String getScheme() {
        return this.u.getScheme();
    }

    public String getSchemeSpecificPart() {
        return this.u.getSchemeSpecificPart();
    }

    public String getUserInfo() {
        return this.u.getUserInfo();
    }

    public int hashCode() {
        return this.u.hashCode();
    }

    public boolean hasAbsolutePath() {
        if (this.u.toString().startsWith("/")) {
            return true;
        }
        if (this.u.getPath() == null) {
            return false;
        }
        return this.u.getPath().startsWith("//");
    }

    public boolean isAbsolute() {
        return this.u.isAbsolute();
    }

    public boolean isOpaque() {
        return this.u.isOpaque();
    }

    public URI normalize() {
        return new URI(this.u.normalize());
    }

    public URI parseServerAuthority() throws URISyntaxException {
        return new URI(this.u.parseServerAuthority());
    }

    public URI relativize(java.net.URI arg0) {
        return new URI(this.u.relativize(arg0));
    }

    public URI resolve(String arg0) {
        URI uri = new URI(this.u.resolve(arg0));
        try {
            return uri.setPath(uri.getPath());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI resolve(java.net.URI arg0) {
        URI uri = new URI(this.u.resolve(arg0));
        try {
            return uri.setPath(uri.getPath());
        }
        catch (Throwable e) {
            return uri;
        }
    }

    public String toASCIIString() {
        return this.u.toASCIIString();
    }

    public String toString() {
        return new URIEncoder().decodeUri(this.u.toString());
    }

    public URL toURL() throws MalformedURLException {
        return this.u.toURL();
    }

    public java.net.URI toJavaURI() {
        return this.u;
    }

    public boolean isCompatible(String scheme) {
        if (scheme.equals("any")) {
            return true;
        }
        if (this.getScheme() == null) {
            return scheme.equals("file");
        }
        if (this.getScheme().equals("any")) {
            return true;
        }
        return this.getScheme().equals(scheme);
    }

    public URI setScheme(String scheme) throws URISyntaxException {
        return new URI(scheme, this.getUserInfo(), this.getHost(), this.getPort(-1), this.u.getPath(), this.getQuery(), this.getFragment());
    }

    public URI setUserInfo(String userInfo) throws URISyntaxException {
        return new URI(this.getScheme(), userInfo, this.getHost(), this.getPort(-1), this.u.getPath(), this.getQuery(), this.getFragment());
    }

    public URI setHost(String host) throws URISyntaxException {
        if (this.getHost() == null && !this.getSchemeSpecificPart().startsWith("///")) {
            return new URI(this.getScheme(), this.getUserInfo(), host, this.getPort(-1), "/" + this.u.getPath(), this.getQuery(), this.getFragment());
        }
        return new URI(this.getScheme(), this.getUserInfo(), host, this.getPort(-1), this.u.getPath(), this.getQuery(), this.getFragment());
    }

    public URI setAuthority(String authority) throws URISyntaxException {
        if (this.getAuthority() == null && !this.getSchemeSpecificPart().startsWith("///")) {
            return new URI(this.getScheme(), authority, "/" + this.u.getPath(), this.getQuery(), this.getFragment());
        }
        return new URI(this.getScheme(), authority, this.u.getPath(), this.getQuery(), this.getFragment());
    }

    public URI setPort(int port) throws URISyntaxException {
        return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), port, this.u.getPath(), this.getQuery(), this.getFragment());
    }

    public URI setPath(String path) throws URISyntaxException {
        if (this.getScheme() != null && this.getAuthority() == null) {
            return new URI(this.getScheme(), null, "///" + path, this.getQuery(), this.getFragment());
        }
        if (this.getScheme() == null && this.getAuthority() == null) {
            return new URI(this.getScheme(), this.getAuthority(), path, this.getQuery(), this.getFragment());
        }
        return new URI(this.getScheme(), this.getAuthority(), "/" + path, this.getQuery(), this.getFragment());
    }

    public URI setQuery(String query) throws URISyntaxException {
        return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(-1), this.u.getPath(), query, this.getFragment());
    }

    public URI setFragment(String fragment) throws URISyntaxException {
        return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(-1), this.u.getPath(), this.getQuery(), fragment);
    }

    private String getLocalHostName() {
        try {
            InetAddress a = InetAddress.getLocalHost();
            if (a != null) {
                return a.getHostName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "localhost";
    }

    private String getLocalCanonicalHostName() {
        try {
            InetAddress a = InetAddress.getLocalHost();
            if (a != null) {
                return a.getCanonicalHostName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "localhost";
    }

    public class URIEncoder {
        private static final String ESCAPE_CHARS = "<>#%\"{}|\\^[]`";

        public String encodeUri(String uri) {
            StringBuffer result = new StringBuffer(2 * uri.length());
            this.encodeUri(uri, result);
            return result.toString();
        }

        public void encodeUri(String uri, StringBuffer buf) {
            for (int i = 0; i < uri.length(); ++i) {
                char c;
                char cInt = c = uri.charAt(i);
                if (ESCAPE_CHARS.indexOf(c) >= 0 || cInt <= ' ') {
                    buf.append('%');
                    String hexVal = Integer.toHexString(cInt);
                    if (hexVal.length() == 1) {
                        buf.append('0');
                    }
                    buf.append(hexVal);
                    continue;
                }
                buf.append(c);
            }
        }

        public String decodeUri(String uri) {
            StringBuffer result = new StringBuffer(uri.length());
            this.decodeUri(uri, result);
            return result.toString();
        }

        public void decodeUri(String uri, StringBuffer buf) {
            int indexOfHash = uri.indexOf(35);
            if (indexOfHash == -1) {
                this._decodeUri(uri, buf);
            } else {
                String baseUri = uri.substring(0, indexOfHash);
                String fragId = uri.substring(indexOfHash);
                this._decodeUri(baseUri, buf);
                buf.append(fragId);
            }
        }

        private void _decodeUri(String uri, StringBuffer buf) {
            int percentIdx = uri.indexOf(37);
            int startIdx = 0;
            while (percentIdx != -1) {
                buf.append(uri.substring(startIdx, percentIdx));
                String xx = uri.substring(percentIdx + 1, percentIdx + 3);
                int c = Integer.parseInt(xx, 16);
                buf.append((char)c);
                startIdx = percentIdx + 3;
                percentIdx = uri.indexOf(37, startIdx);
            }
            buf.append(uri.substring(startIdx));
        }
    }
}

