/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Set;
import org.gridlab.gat.AdaptorInfo;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.AdvertService;
import org.gridlab.gat.io.Endpoint;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.io.FileInputStreamInterface;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.FileOutputStream;
import org.gridlab.gat.io.FileOutputStreamInterface;
import org.gridlab.gat.io.LogicalFile;
import org.gridlab.gat.io.RandomAccessFile;
import org.gridlab.gat.io.RandomAccessFileInterface;
import org.gridlab.gat.monitoring.Monitorable;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.steering.SteeringManager;

public class GAT {
    private static final String PROPERTIES_FILENAME = "javagat.properties";
    private static final String PROPERTIES_FILE = "javagat.properties.file";
    static Class<?> engineClass;
    static Method createProxyMethod;
    static GATContext defaultContext;

    public static File createFile(URI location) throws GATObjectCreationException {
        return GAT.createFile(defaultContext, null, location);
    }

    public static File createFile(String location) throws GATObjectCreationException {
        return GAT.createFile(defaultContext, null, location);
    }

    public static File createFile(Preferences preferences, URI location) throws GATObjectCreationException {
        return GAT.createFile(defaultContext, preferences, location);
    }

    public static File createFile(Preferences preferences, String location) throws GATObjectCreationException {
        return GAT.createFile(defaultContext, preferences, location);
    }

    public static File createFile(GATContext gatContext, URI location) throws GATObjectCreationException {
        return GAT.createFile(gatContext, null, location);
    }

    public static File createFile(GATContext gatContext, String location) throws GATObjectCreationException {
        try {
            return GAT.createFile(gatContext, null, new URI(location));
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file", e);
        }
    }

    public static File createFile(GATContext gatContext, Preferences preferences, String location) throws GATObjectCreationException {
        try {
            return GAT.createFile(gatContext, preferences, new URI(location));
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file", e);
        }
    }

    public static File createFile(GATContext gatContext, Preferences preferences, URI location) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        Object[] array = new Object[]{location};
        FileInterface f = (FileInterface)GAT.getAdaptorProxy("File", FileInterface.class, gatContext, preferences, new Class[]{URI.class}, array);
        return new File(f);
    }

    public static LogicalFile createLogicalFile(String name, int mode) throws GATObjectCreationException {
        return GAT.createLogicalFile(defaultContext, null, name, mode);
    }

    public static LogicalFile createLogicalFile(Preferences preferences, String name, int mode) throws GATObjectCreationException {
        return GAT.createLogicalFile(defaultContext, preferences, name, mode);
    }

    public static LogicalFile createLogicalFile(GATContext gatContext, String name, int mode) throws GATObjectCreationException {
        return GAT.createLogicalFile(gatContext, null, name, mode);
    }

    public static LogicalFile createLogicalFile(GATContext gatContext, Preferences preferences, String name, int mode) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        Integer modeTmp = new Integer(mode);
        Object[] array = new Object[]{name, modeTmp};
        return (LogicalFile)GAT.getAdaptorProxy("LogicalFile", LogicalFile.class, gatContext, preferences, new Class[]{String.class, Integer.class}, array);
    }

    public static FileInputStream createFileInputStream(URI location) throws GATObjectCreationException {
        return GAT.createFileInputStream(defaultContext, null, location);
    }

    public static FileInputStream createFileInputStream(Preferences preferences, URI location) throws GATObjectCreationException {
        return GAT.createFileInputStream(defaultContext, preferences, location);
    }

    public static FileInputStream createFileInputStream(GATContext gatContext, URI location) throws GATObjectCreationException {
        return GAT.createFileInputStream(gatContext, null, location);
    }

    public static FileInputStream createFileInputStream(GATContext gatContext, Preferences preferences, URI location) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        Object[] array = new Object[]{location};
        FileInputStreamInterface res = (FileInputStreamInterface)GAT.getAdaptorProxy("FileInputStream", FileInputStreamInterface.class, gatContext, preferences, new Class[]{URI.class}, array);
        return new FileInputStream(res);
    }

    public static FileInputStream createFileInputStream(File file) throws GATObjectCreationException {
        return GAT.createFileInputStream(file.getFileInterface().getGATContext(), null, file.toGATURI());
    }

    public static FileInputStream createFileInputStream(Preferences preferences, File file) throws GATObjectCreationException {
        return GAT.createFileInputStream(file.getFileInterface().getGATContext(), preferences, file);
    }

    public static FileInputStream createFileInputStream(GATContext gatContext, File file) throws GATObjectCreationException {
        return GAT.createFileInputStream(gatContext, null, file);
    }

    public static FileInputStream createFileInputStream(GATContext gatContext, Preferences preferences, File file) throws GATObjectCreationException {
        return GAT.createFileInputStream(gatContext, preferences, file.toGATURI());
    }

    public static FileInputStream createFileInputStream(String location) throws GATObjectCreationException {
        try {
            return GAT.createFileInputStream(defaultContext, null, new URI(location));
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file input stream", e);
        }
    }

    public static FileInputStream createFileInputStream(Preferences preferences, String location) throws GATObjectCreationException {
        try {
            return GAT.createFileInputStream(defaultContext, preferences, new URI(location));
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file input stream", e);
        }
    }

    public static FileInputStream createFileInputStream(GATContext gatContext, String location) throws GATObjectCreationException {
        try {
            return GAT.createFileInputStream(gatContext, null, new URI(location));
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file input stream", e);
        }
    }

    public static FileInputStream createFileInputStream(GATContext gatContext, Preferences preferences, String location) throws GATObjectCreationException {
        try {
            return GAT.createFileInputStream(gatContext, preferences, new URI(location));
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file input stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(String location) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(defaultContext, null, new URI(location), false);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(Preferences preferences, String location) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(defaultContext, preferences, new URI(location), false);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, String location) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(gatContext, null, new URI(location), false);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, Preferences preferences, String location) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(gatContext, preferences, new URI(location), false);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(String location, boolean append) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(defaultContext, null, new URI(location), append);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(Preferences preferences, String location, boolean append) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(defaultContext, preferences, new URI(location), append);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, String location, boolean append) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(gatContext, null, new URI(location), append);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, Preferences preferences, String location, boolean append) throws GATObjectCreationException {
        try {
            return GAT.createFileOutputStream(gatContext, preferences, new URI(location), append);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("file output stream", e);
        }
    }

    public static FileOutputStream createFileOutputStream(File file) throws GATObjectCreationException {
        return GAT.createFileOutputStream(file.getFileInterface().getGATContext(), null, file.toGATURI(), false);
    }

    public static FileOutputStream createFileOutputStream(File file, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(file.getFileInterface().getGATContext(), null, file.toGATURI(), append);
    }

    public static FileOutputStream createFileOutputStream(Preferences preferences, File file) throws GATObjectCreationException {
        return GAT.createFileOutputStream(file.getFileInterface().getGATContext(), preferences, file.toGATURI(), false);
    }

    public static FileOutputStream createFileOutputStream(Preferences preferences, File file, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(file.getFileInterface().getGATContext(), preferences, file.toGATURI(), append);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, File file) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, null, file.toGATURI(), false);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, Preferences preferences, File file) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, preferences, file.toGATURI(), false);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, File file, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, null, file.toGATURI(), append);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, Preferences preferences, File file, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, preferences, file.toGATURI(), append);
    }

    public static FileOutputStream createFileOutputStream(URI location) throws GATObjectCreationException {
        return GAT.createFileOutputStream(defaultContext, null, location, false);
    }

    public static FileOutputStream createFileOutputStream(Preferences preferences, URI location) throws GATObjectCreationException {
        return GAT.createFileOutputStream(defaultContext, preferences, location, false);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, URI location) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, null, location, false);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, Preferences preferences, URI location) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, preferences, location, false);
    }

    public static FileOutputStream createFileOutputStream(URI location, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(defaultContext, null, location, append);
    }

    public static FileOutputStream createFileOutputStream(Preferences preferences, URI location, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(defaultContext, preferences, location, append);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, URI location, boolean append) throws GATObjectCreationException {
        return GAT.createFileOutputStream(gatContext, null, location, append);
    }

    public static FileOutputStream createFileOutputStream(GATContext gatContext, Preferences preferences, URI location, boolean append) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        Object[] array = new Object[]{location, new Boolean(append)};
        FileOutputStreamInterface res = (FileOutputStreamInterface)GAT.getAdaptorProxy("FileOutputStream", FileOutputStreamInterface.class, gatContext, preferences, new Class[]{URI.class, Boolean.class}, array);
        return new FileOutputStream(res);
    }

    public static Endpoint createEndpoint(GATContext gatContext, Preferences preferences) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        return (Endpoint)GAT.getAdaptorProxy("Endpoint", Endpoint.class, gatContext, preferences, null, null);
    }

    public static Endpoint createEndpoint(GATContext gatContext) throws GATObjectCreationException {
        return GAT.createEndpoint(gatContext, null);
    }

    public static Endpoint createEndpoint(Preferences preferences) throws GATObjectCreationException {
        return GAT.createEndpoint(defaultContext, preferences);
    }

    public static Endpoint createEndpoint() throws GATObjectCreationException {
        return GAT.createEndpoint(defaultContext, null);
    }

    public static AdvertService createAdvertService(GATContext gatContext, Preferences preferences) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        return (AdvertService)GAT.getAdaptorProxy("AdvertService", AdvertService.class, gatContext, preferences, null, null);
    }

    public static AdvertService createAdvertService(GATContext gatContext) throws GATObjectCreationException {
        return GAT.createAdvertService(gatContext, null);
    }

    public static AdvertService createAdvertService(Preferences preferences) throws GATObjectCreationException {
        return GAT.createAdvertService(defaultContext, preferences);
    }

    public static AdvertService createAdvertService() throws GATObjectCreationException {
        return GAT.createAdvertService(defaultContext, null);
    }

    public static Monitorable createMonitorable() throws GATObjectCreationException {
        return GAT.createMonitorable(defaultContext, null);
    }

    public static Monitorable createMonitorable(Preferences preferences) throws GATObjectCreationException {
        return GAT.createMonitorable(defaultContext, preferences);
    }

    public static Monitorable createMonitorable(GATContext gatContext) throws GATObjectCreationException {
        return GAT.createMonitorable(gatContext, null);
    }

    public static Monitorable createMonitorable(GATContext gatContext, Preferences preferences) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        return (Monitorable)GAT.getAdaptorProxy("Monitorable", Monitorable.class, gatContext, preferences, null, null);
    }

    public static SteeringManager createSteeringManager() throws GATObjectCreationException {
        return GAT.createSteeringManager(defaultContext, null);
    }

    public static SteeringManager createSteeringManager(Preferences preferences) throws GATObjectCreationException {
        return GAT.createSteeringManager(defaultContext, preferences);
    }

    public static SteeringManager createSteeringManager(GATContext gatContext) throws GATObjectCreationException {
        return GAT.createSteeringManager(gatContext, null);
    }

    public static SteeringManager createSteeringManager(GATContext gatContext, Preferences preferences) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        return (SteeringManager)GAT.getAdaptorProxy("SteeringManager", SteeringManager.class, gatContext, preferences, null, null);
    }

    public static RandomAccessFile createRandomAccessFile(String location, String mode) throws GATObjectCreationException {
        try {
            return GAT.createRandomAccessFile(defaultContext, null, new URI(location), mode);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("random access file", e);
        }
    }

    public static RandomAccessFile createRandomAccessFile(Preferences preferences, String location, String mode) throws GATObjectCreationException {
        try {
            return GAT.createRandomAccessFile(defaultContext, preferences, new URI(location), mode);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("random access file", e);
        }
    }

    public static RandomAccessFile createRandomAccessFile(GATContext gatContext, String location, String mode) throws GATObjectCreationException {
        try {
            return GAT.createRandomAccessFile(gatContext, null, new URI(location), mode);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("random access file", e);
        }
    }

    public static RandomAccessFile createRandomAccessFile(GATContext gatContext, Preferences preferences, String location, String mode) throws GATObjectCreationException {
        try {
            return GAT.createRandomAccessFile(gatContext, preferences, new URI(location), mode);
        }
        catch (URISyntaxException e) {
            throw new GATObjectCreationException("random access file", e);
        }
    }

    public static RandomAccessFile createRandomAccessFile(URI location, String mode) throws GATObjectCreationException {
        return GAT.createRandomAccessFile(defaultContext, null, location, mode);
    }

    public static RandomAccessFile createRandomAccessFile(Preferences preferences, URI location, String mode) throws GATObjectCreationException {
        return GAT.createRandomAccessFile(defaultContext, preferences, location, mode);
    }

    public static RandomAccessFile createRandomAccessFile(GATContext gatContext, URI location, String mode) throws GATObjectCreationException {
        return GAT.createRandomAccessFile(gatContext, null, location, mode);
    }

    public static RandomAccessFile createRandomAccessFile(GATContext gatContext, Preferences preferences, URI location, String mode) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        Object[] array = new Object[]{location, mode};
        RandomAccessFileInterface f = (RandomAccessFileInterface)GAT.getAdaptorProxy("RandomAccessFile", RandomAccessFileInterface.class, gatContext, preferences, new Class[]{URI.class, String.class}, array);
        try {
            return new RandomAccessFile(f);
        }
        catch (Exception e) {
            throw new GATObjectCreationException("GAT", e);
        }
    }

    public static ResourceBroker createResourceBroker(URI brokerURI) throws GATObjectCreationException {
        return GAT.createResourceBroker(defaultContext, null, brokerURI);
    }

    public static ResourceBroker createResourceBroker(Preferences preferences, URI brokerURI) throws GATObjectCreationException {
        return GAT.createResourceBroker(defaultContext, preferences, brokerURI);
    }

    public static ResourceBroker createResourceBroker(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        return GAT.createResourceBroker(gatContext, null, brokerURI);
    }

    public static ResourceBroker createResourceBroker(GATContext gatContext, Preferences preferences, URI brokerURI) throws GATObjectCreationException {
        if (gatContext == null) {
            throw new NullPointerException("null specified for gatContext");
        }
        Object[] array = new Object[]{brokerURI};
        return (ResourceBroker)GAT.getAdaptorProxy("ResourceBroker", ResourceBroker.class, gatContext, preferences, new Class[]{URI.class}, array);
    }

    public static AdaptorInfo[] getAdaptorInfos(String type) throws GATInvocationException {
        AdaptorInfo[] result = null;
        Method m = null;
        try {
            m = engineClass.getMethod("getAdaptorInfos", String.class);
        }
        catch (SecurityException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        catch (NoSuchMethodException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        try {
            result = (AdaptorInfo[])m.invoke(null, type);
        }
        catch (IllegalArgumentException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        catch (IllegalAccessException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        catch (InvocationTargetException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        return result;
    }

    public static String[] getAdaptorTypes() throws GATInvocationException {
        String[] result = null;
        Method m = null;
        try {
            m = engineClass.getMethod("getAdaptorTypes", null);
        }
        catch (SecurityException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        catch (NoSuchMethodException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        try {
            result = (String[])m.invoke(null, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        catch (IllegalAccessException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        catch (InvocationTargetException e) {
            throw new GATInvocationException("GAT api: ", e);
        }
        return result;
    }

    public static void end() {
        try {
            Method m = engineClass.getMethod("end", null);
            m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected static Object getAdaptorProxy(String cpiClassName, Class<?> interfaceClass, GATContext gatContext, Preferences additionalPreferences, Class<?>[] parameterTypes, Object[] tmpParams) throws GATObjectCreationException {
        GATContext newContext = (GATContext)gatContext.clone();
        newContext.addPreferences(additionalPreferences);
        try {
            return createProxyMethod.invoke(null, cpiClassName, interfaceClass, newContext, parameterTypes, tmpParams);
        }
        catch (Exception e) {
            throw new GATObjectCreationException("", e);
        }
    }

    public static synchronized void setDefaultGATContext(GATContext context) {
        defaultContext = context;
    }

    public static synchronized GATContext getDefaultGATContext() {
        return defaultContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        defaultContext = new GATContext();
        Properties defaultProperties = new Properties();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(PROPERTIES_FILENAME);
        if (inputStream != null) {
            try {
                defaultProperties.load(inputStream);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {}
            }
        }
        try {
            inputStream = new java.io.FileInputStream(PROPERTIES_FILENAME);
            defaultProperties.load(inputStream);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e1) {}
        }
        Properties systemProperties = System.getProperties();
        String file = systemProperties.getProperty(PROPERTIES_FILE);
        if (file != null) {
            try {
                inputStream = new java.io.FileInputStream(file);
                defaultProperties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                System.err.println("User specified preferences \"" + file + "\" not found!");
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e1) {}
            }
        }
        defaultContext.addPreferences(new Preferences(defaultProperties));
        Set<Object> keys = systemProperties.keySet();
        for (Object key : keys) {
            String value = systemProperties.getProperty((String)key);
            defaultProperties.setProperty((String)key, value);
        }
        try {
            engineClass = Class.forName("org.gridlab.gat.engine.GATEngine");
            createProxyMethod = engineClass.getMethod("createAdaptorProxy", String.class, Class.class, GATContext.class, Class[].class, Object[].class);
        }
        catch (Exception e) {
            System.out.println(e);
            throw new Error(e);
        }
    }
}

