/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.monitoring.Monitorable;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.HardwareResource;
import org.gridlab.gat.resources.HardwareResourceDescription;

public interface Job
extends Monitorable,
Advertisable {
    public static final String STATE = "state";
    public static final String HOSTNAME = "hostname";
    public static final String SUBMISSIONTIME = "submissiontime";
    public static final String STARTTIME = "starttime";
    public static final String STOPTIME = "stoptime";
    public static final String POSTSTAGE_EXCEPTION = "poststage.exception";
    public static final String ADAPTOR_JOB_ID = "adaptor.job.id";

    public AbstractJobDescription getJobDescription();

    public void unSchedule() throws GATInvocationException;

    public void stop() throws GATInvocationException;

    public JobState getState();

    public Map<String, Object> getInfo() throws GATInvocationException;

    public int getJobID();

    public void checkpoint() throws GATInvocationException;

    public void migrate() throws GATInvocationException;

    public void migrate(HardwareResourceDescription var1) throws GATInvocationException;

    public Job cloneJob(HardwareResource var1);

    public void hold() throws GATInvocationException;

    public void resume() throws GATInvocationException;

    public int getExitStatus() throws GATInvocationException;

    public String toString();

    public InputStream getStdout() throws GATInvocationException;

    public InputStream getStderr() throws GATInvocationException;

    public OutputStream getStdin() throws GATInvocationException;

    public static enum JobState {
        INITIAL,
        SCHEDULED,
        RUNNING,
        STOPPED,
        SUBMISSION_ERROR,
        ON_HOLD,
        PRE_STAGING,
        POST_STAGING,
        UNKNOWN;

    }
}

