/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.LogicalFile;
import org.gridlab.gat.io.cpi.SerializedLogicalFile;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalFileCpi
extends MonitorableCpi
implements LogicalFile {
    protected static Logger logger = LoggerFactory.getLogger(LogicalFileCpi.class);
    protected GATContext gatContext;
    protected String name;
    protected int mode;
    protected List<URI> files;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map<String, Boolean> capabilities = MonitorableCpi.getSupportedCapabilities();
        capabilities.put("addFile", true);
        capabilities.put("addURI", true);
        capabilities.put("removeFile", true);
        capabilities.put("removeURI", true);
        capabilities.put("replicate", true);
        capabilities.put("getURIs", true);
        capabilities.put("getFiles", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = MonitorableCpi.getSupportedPreferences();
        preferences.put("LogicalFile.adaptor.name", (Object)"<no default>");
        preferences.put("adaptors.local", (Object)"false");
        return preferences;
    }

    protected LogicalFileCpi(GATContext gatContext, String name, Integer mode) throws GATObjectCreationException {
        this.gatContext = gatContext;
        this.files = new Vector<URI>();
        this.mode = mode;
        this.name = name;
        switch (this.mode) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new GATObjectCreationException("illegal mode in Logical file");
            }
        }
    }

    public void addFile(File file) throws GATInvocationException {
        this.addURI(file.toGATURI());
    }

    public void addURI(URI location) throws GATInvocationException {
        this.files.add(location);
    }

    public void removeFile(File file) throws GATInvocationException {
        this.removeURI(file.toGATURI());
    }

    public void removeURI(URI location) throws GATInvocationException {
        this.files.remove(location);
    }

    public void replicate(URI loc) throws IOException, GATInvocationException {
        if (this.files.size() == 0) {
            throw new IOException("Must have at least one source file");
        }
        if (this.files.contains(loc)) {
            if (logger.isInfoEnabled()) {
                logger.info("logical file '" + this.name + "' already contains URI '" + loc + "'.");
            }
            return;
        }
        GATInvocationException exception = new GATInvocationException("default logical file");
        for (URI u : this.getOrderedURIs(loc)) {
            FileInterface f = null;
            try {
                f = GAT.createFile((GATContext)this.gatContext, (URI)u).getFileInterface();
                f.copy(loc);
            }
            catch (Exception e) {
                exception.add("default logical file", (Throwable)e);
                continue;
            }
            this.files.add(loc);
            return;
        }
        throw exception;
    }

    public URI getClosestURI(URI loc) throws GATInvocationException {
        if (this.files == null || this.files.size() == 0) {
            throw new GATInvocationException("No files in logical file '" + this.name + "' to compare with");
        }
        return this.files.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> getOrderedURIs(URI location) throws GATInvocationException {
        if (this.files == null || this.files.size() == 0) {
            throw new GATInvocationException("No files in logical file '" + this.name + "' to order");
        }
        Vector<URI> result = new Vector<URI>();
        List<URI> list = this.files;
        synchronized (list) {
            for (URI uri : this.files) {
                result.add(uri);
            }
        }
        return result;
    }

    public List<URI> getURIs() throws GATInvocationException {
        return this.files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getFiles() throws GATInvocationException {
        Vector<File> res = new Vector<File>();
        List<URI> list = this.files;
        synchronized (list) {
            for (URI uri : this.files) {
                try {
                    File f = GAT.createFile((GATContext)this.gatContext, (URI)uri);
                    res.add(f);
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    public String getName() throws GATInvocationException {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal() {
        SerializedLogicalFile f = new SerializedLogicalFile();
        f.setMode(this.mode);
        f.setName(this.name);
        Vector<String> fileStrings = new Vector<String>();
        List<URI> list = this.files;
        synchronized (list) {
            for (int i = 0; i < this.files.size(); ++i) {
                fileStrings.add(this.files.get(i).toString());
            }
        }
        f.setFiles(fileStrings);
        return GATEngine.defaultMarshal(f);
    }

    public static Advertisable unmarshal(GATContext context, String s) {
        SerializedLogicalFile f = (SerializedLogicalFile)GATEngine.defaultUnmarshal(SerializedLogicalFile.class, s);
        try {
            LogicalFile lf = GAT.createLogicalFile((GATContext)context, (String)f.getName(), (int)f.getMode());
            for (int i = 0; i < f.getFiles().size(); ++i) {
                lf.addURI(new URI(f.getFiles().get(i)));
            }
            return lf;
        }
        catch (Exception e) {
            throw new Error("could not create new GAT object");
        }
    }

    public String toString() {
        return this.name;
    }
}

