/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.juds;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class UnixDomainSocket {
    private static File jarFile;
    public static final int SOCK_DGRAM = 0;
    public static final int SOCK_STREAM = 1;
    protected UnixDomainSocketInputStream in;
    protected UnixDomainSocketOutputStream out;
    protected int nativeSocketFileHandle;
    protected String socketFile;
    protected int socketType;
    private int timeout;

    private static void getJarPath() {
        try {
            jarFile = new File(UnixDomainSocket.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            UnixDomainSocket.throwLink(uRISyntaxException);
        }
    }

    private static void loadNativeLib() {
        File file = UnixDomainSocket.getNativeLibTarget();
        if (!file.exists() || UnixDomainSocket.jarNewer(file).booleanValue()) {
            try {
                UnixDomainSocket.extractNativeLib(file);
                if (!file.exists()) {
                    UnixDomainSocket.throwLink("The native library was not extracted");
                }
            }
            catch (IOException iOException) {
                UnixDomainSocket.throwLink(iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                UnixDomainSocket.throwLink(uRISyntaxException);
            }
        }
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            UnixDomainSocket.throwLink(iOException);
        }
        System.load(string);
    }

    private static Boolean jarNewer(File file) {
        return file.lastModified() < jarFile.lastModified();
    }

    private static void throwLink(Throwable throwable) {
        UnixDomainSocket.throwLink(throwable.toString());
    }

    private static void throwLink(String string) {
        throw new UnsatisfiedLinkError(string);
    }

    private static File getNativeLibTarget() {
        String string = UnixDomainSocket.platform();
        String string2 = "darwin".equals(string) ? "dylib" : "so";
        String string3 = String.format("/var/tmp/libunixdomainsocket-%s-%s.%s", string, UnixDomainSocket.arch(), string2);
        return new File(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractNativeLib(File file) throws IOException, URISyntaxException {
        JarFile jarFile = new JarFile(UnixDomainSocket.jarFile);
        ZipEntry zipEntry = jarFile.getEntry(file.getName());
        if (zipEntry == null) {
            UnixDomainSocket.throwLink("Could not find library: " + file.getName());
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                int n;
                byte[] byArray = new byte[2048];
                while ((n = inputStream.read(byArray)) >= 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static String arch() {
        String string = System.getProperty("os.arch");
        if ("amd64".equals(string) || "x86_64".equals(string)) {
            return "x86_64";
        }
        return string;
    }

    private static String platform() {
        String string = System.getProperty("os.name").toLowerCase();
        if ("mac os x".equals(string)) {
            return "darwin";
        }
        return string;
    }

    protected static native int nativeCreate(String var0, int var1);

    protected static native int nativeListen(String var0, int var1, int var2);

    protected static native int nativeAccept(int var0, int var1);

    protected static native int nativeOpen(String var0, int var1);

    protected static native int nativeRead(int var0, byte[] var1, int var2, int var3);

    protected static native int nativeWrite(int var0, byte[] var1, int var2, int var3);

    protected static native int nativeClose(int var0);

    protected static native int nativeCloseInput(int var0);

    protected static native int nativeCloseOutput(int var0);

    protected static native int nativeUnlink(String var0);

    protected UnixDomainSocket() {
    }

    protected UnixDomainSocket(int n, int n2) throws IOException {
        this.nativeSocketFileHandle = n;
        this.socketType = n2;
        this.socketFile = null;
        this.in = new UnixDomainSocketInputStream();
        if (this.socketType == 1) {
            this.out = new UnixDomainSocketOutputStream();
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void close() {
        UnixDomainSocket.nativeClose(this.nativeSocketFileHandle);
    }

    public void unlink() {
        if (this.socketFile != null) {
            UnixDomainSocket.nativeUnlink(this.socketFile);
        }
    }

    static {
        UnixDomainSocket.getJarPath();
        UnixDomainSocket.loadNativeLib();
    }

    protected class UnixDomainSocketReadThread
    extends Thread {
        private int count;
        private int off;
        private int len;
        private byte[] b;

        public UnixDomainSocketReadThread(byte[] byArray, int n, int n2) {
            this.b = byArray;
            this.off = n;
            this.len = n2;
        }

        @Override
        public void run() {
            this.count = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, this.b, this.off, this.len);
        }

        public int getData() {
            return this.count;
        }
    }

    protected class UnixDomainSocketOutputStream
    extends OutputStream {
        protected UnixDomainSocketOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            if (UnixDomainSocket.nativeWrite(UnixDomainSocket.this.nativeSocketFileHandle, byArray, 0, 1) != 1) {
                throw new IOException("Unable to write to Unix domain socket");
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (UnixDomainSocket.nativeWrite(UnixDomainSocket.this.nativeSocketFileHandle, byArray, n, n2) != n2) {
                throw new IOException("Unable to write to Unix domain socket");
            }
        }

        @Override
        public void close() throws IOException {
            UnixDomainSocket.nativeCloseOutput(UnixDomainSocket.this.nativeSocketFileHandle);
        }
    }

    protected class UnixDomainSocketInputStream
    extends InputStream {
        protected UnixDomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            int n;
            byte[] byArray = new byte[1];
            if (UnixDomainSocket.this.timeout > 0) {
                UnixDomainSocketReadThread unixDomainSocketReadThread = new UnixDomainSocketReadThread(byArray, 0, 1);
                unixDomainSocketReadThread.setDaemon(true);
                unixDomainSocketReadThread.start();
                try {
                    unixDomainSocketReadThread.join(UnixDomainSocket.this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (unixDomainSocketReadThread.isAlive()) {
                    throw new InterruptedIOException("Unix domain socket read() call timed out");
                }
                n = unixDomainSocketReadThread.getData();
            } else {
                n = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, byArray, 0, 1);
                if (n == -1) {
                    throw new IOException();
                }
            }
            return n > 0 ? byArray[0] : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (UnixDomainSocket.this.timeout > 0) {
                UnixDomainSocketReadThread unixDomainSocketReadThread = new UnixDomainSocketReadThread(byArray, n, n2);
                unixDomainSocketReadThread.setDaemon(true);
                unixDomainSocketReadThread.start();
                try {
                    unixDomainSocketReadThread.join(UnixDomainSocket.this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (unixDomainSocketReadThread.isAlive()) {
                    throw new InterruptedIOException("Unix domain socket read() call timed out");
                }
                n3 = unixDomainSocketReadThread.getData();
            } else {
                n3 = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, byArray, n, n2);
                if (n3 == -1) {
                    throw new IOException();
                }
            }
            return n3;
        }

        @Override
        public void close() throws IOException {
            UnixDomainSocket.nativeCloseInput(UnixDomainSocket.this.nativeSocketFileHandle);
        }
    }
}

