/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.util;

import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.exceptions.InitializationException;
import es.bsc.compss.nio.worker.util.ThreadProperties;
import es.bsc.compss.util.RequestQueue;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JobsThreadPool {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ThreadPool");
    protected static final String JOB_THREADS_POOL_NAME = "JobsThreadPool";
    protected final NIOWorker nw;
    protected final int size;
    protected Thread[] workerThreads;
    protected final RequestQueue<NIOTask> queue;
    protected final Semaphore sem;

    public JobsThreadPool(NIOWorker nw, int size) {
        LOGGER.info("Init JobsThreadPool");
        this.nw = nw;
        this.size = size;
        this.workerThreads = new Thread[this.size];
        System.setProperties(new ThreadProperties(System.getProperties()));
        this.queue = new RequestQueue();
        this.sem = new Semaphore(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(NIOTask nt) {
        RequestQueue<NIOTask> requestQueue = this.queue;
        synchronized (requestQueue) {
            this.queue.enqueue(nt);
        }
    }

    public abstract void startThreads() throws InitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        LOGGER.info("Stopping Jobs Thread Pool");
        RequestQueue<NIOTask> requestQueue = this.queue;
        synchronized (requestQueue) {
            for (int i = 0; i < this.size; ++i) {
                this.queue.addToFront(null);
            }
            this.queue.wakeUpAll();
        }
        this.sem.acquireUninterruptibly(this.size);
        LOGGER.info("Performing specific stop");
        this.specificStop();
        this.joinThreads();
        LOGGER.info("ThreadPool stopped");
    }

    protected abstract void specificStop();

    private void joinThreads() {
        for (Thread t : this.workerThreads) {
            if (t == null) continue;
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.workerThreads = null;
        Runtime.getRuntime().gc();
    }

    public void threadEnd() {
        this.sem.release();
    }

    public int getNumThreads() {
        return this.size;
    }
}

