/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class ResourceBrokerCallBackExample
implements MetricListener {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("\tUsage: scripts/run-gat-app examples20.ResourceBrokerCallBackExample <brokerURI> (where location is a valid JavaGAT URI)\n");
            System.exit(1);
        }
        new ResourceBrokerCallBackExample().start(args[0]);
        GAT.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String brokerURI) {
        ResourceBroker broker = null;
        Preferences prefs = new Preferences();
        try {
            broker = GAT.createResourceBroker((Preferences)prefs, (URI)new URI(brokerURI));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create resource broker at location '" + brokerURI + "': " + (Object)((Object)e));
            return;
        }
        catch (URISyntaxException e) {
            System.err.println("Wrong uri '" + brokerURI + "': " + e);
            return;
        }
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/hostname");
        try {
            sd.setStdout(GAT.createFile((String)"hostname.txt"));
        }
        catch (GATObjectCreationException e) {
            System.err.println("Failed to create the stdout file 'hostname.txt': " + (Object)((Object)e));
            return;
        }
        JobDescription jd = new JobDescription(sd);
        try {
            broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            System.err.println("Failed to submit the job: " + (Object)((Object)e));
            return;
        }
        ResourceBrokerCallBackExample resourceBrokerCallBackExample = this;
        synchronized (resourceBrokerCallBackExample) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetricEvent(MetricEvent event) {
        System.out.println("received state change: " + event.getValue());
        if (event.getValue() == Job.JobState.STOPPED) {
            ResourceBrokerCallBackExample resourceBrokerCallBackExample = this;
            synchronized (resourceBrokerCallBackExample) {
                this.notify();
            }
        }
    }
}

