/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;

public class CloudStackTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected Set<String> securityGroupIds = Sets.newLinkedHashSet();
    protected Map<String, String> ipsToNetworks = Maps.newLinkedHashMap();
    protected String ipOnDefaultNetwork;
    protected String keyPair;
    protected boolean setupStaticNat = true;
    protected String account;
    protected String domainId;
    protected boolean generateKeyPair = false;
    protected boolean generateSecurityGroup = false;
    protected String diskOfferingId;
    protected int dataDiskSize;
    public static final CloudStackTemplateOptions NONE = new CloudStackTemplateOptions();

    @Override
    public CloudStackTemplateOptions clone() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof CloudStackTemplateOptions) {
            CloudStackTemplateOptions eTo = (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(to);
            eTo.securityGroupIds(this.securityGroupIds);
            eTo.ipsToNetworks(this.ipsToNetworks);
            eTo.ipOnDefaultNetwork(this.ipOnDefaultNetwork);
            eTo.keyPair(this.keyPair);
            eTo.generateKeyPair(this.shouldGenerateKeyPair());
            eTo.generateSecurityGroup(this.shouldGenerateSecurityGroup());
            eTo.account(this.account);
            eTo.domainId(this.domainId);
            eTo.setupStaticNat(this.setupStaticNat);
            eTo.diskOfferingId(this.diskOfferingId);
            eTo.dataDiskSize(this.dataDiskSize);
        }
    }

    public CloudStackTemplateOptions diskOfferingId(String diskOfferingId) {
        this.diskOfferingId = diskOfferingId;
        return this;
    }

    public String getDiskOfferingId() {
        return this.diskOfferingId;
    }

    public CloudStackTemplateOptions dataDiskSize(int dataDiskSize) {
        this.dataDiskSize = dataDiskSize;
        return this;
    }

    public int getDataDiskSize() {
        return this.dataDiskSize;
    }

    public CloudStackTemplateOptions securityGroupId(String securityGroupId) {
        this.securityGroupIds.add(securityGroupId);
        return this;
    }

    public CloudStackTemplateOptions securityGroupIds(Iterable<String> securityGroupIds) {
        Iterables.addAll(this.securityGroupIds, Preconditions.checkNotNull(securityGroupIds, "securityGroupIds was null"));
        return this;
    }

    public Set<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public CloudStackTemplateOptions generateSecurityGroup(boolean enable) {
        this.generateSecurityGroup = enable;
        return this;
    }

    public boolean shouldGenerateSecurityGroup() {
        return this.generateSecurityGroup;
    }

    @Deprecated
    public CloudStackTemplateOptions networkId(String networkId) {
        this.networks.add(networkId);
        return this;
    }

    @Deprecated
    public CloudStackTemplateOptions networkIds(Iterable<String> networkIds) {
        Iterables.addAll(this.networks, Preconditions.checkNotNull(networkIds, "networkIds was null"));
        return this;
    }

    @Deprecated
    public Set<String> getNetworkIds() {
        return this.getNetworks();
    }

    public CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
        this.setupStaticNat = setupStaticNat;
        return this;
    }

    public boolean shouldSetupStaticNat() {
        return this.setupStaticNat;
    }

    public CloudStackTemplateOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
        this.ipOnDefaultNetwork = ipOnDefaultNetwork;
        return this;
    }

    public String getIpOnDefaultNetwork() {
        return this.ipOnDefaultNetwork;
    }

    public CloudStackTemplateOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
        this.ipsToNetworks.putAll(ipsToNetworks);
        return this;
    }

    public Map<String, String> getIpsToNetworks() {
        return this.ipsToNetworks;
    }

    public CloudStackTemplateOptions keyPair(String keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public CloudStackTemplateOptions generateKeyPair(boolean enable) {
        this.generateKeyPair = enable;
        return this;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    public CloudStackTemplateOptions account(String account) {
        this.account = account;
        return this;
    }

    public String getAccount() {
        return this.account;
    }

    public CloudStackTemplateOptions domainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public String getDomainId() {
        return this.domainId;
    }

    @Override
    public CloudStackTemplateOptions blockOnPort(int port, int seconds) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public CloudStackTemplateOptions inboundPorts(int ... ports) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public CloudStackTemplateOptions authorizePublicKey(String publicKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public CloudStackTemplateOptions installPrivateKey(String privateKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public CloudStackTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    @Override
    public CloudStackTemplateOptions userMetadata(String key, String value) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    @Override
    public CloudStackTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    @Override
    public CloudStackTemplateOptions networks(Iterable<String> networks) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.networks(networks));
    }

    @Override
    public CloudStackTemplateOptions networks(String ... networks) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static CloudStackTemplateOptions diskOfferingId(String diskOfferingId) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.diskOfferingId(diskOfferingId);
        }

        public static CloudStackTemplateOptions dataDiskSize(int dataDiskSize) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.dataDiskSize(dataDiskSize);
        }

        public static CloudStackTemplateOptions securityGroupId(String id) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.securityGroupId(id);
        }

        public static CloudStackTemplateOptions securityGroupIds(Iterable<String> securityGroupIds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static CloudStackTemplateOptions generateSecurityGroup(boolean enable) {
            return new CloudStackTemplateOptions().generateSecurityGroup(enable);
        }

        @Deprecated
        public static CloudStackTemplateOptions networkId(String id) {
            return Builder.networks(id);
        }

        @Deprecated
        public static CloudStackTemplateOptions networkIds(Iterable<String> networkIds) {
            return Builder.networks(networkIds);
        }

        public static CloudStackTemplateOptions ipOnDefaultNetwork(String ipAddress) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipOnDefaultNetwork(ipAddress);
        }

        public static CloudStackTemplateOptions ipsToNetworks(Map<String, String> ipToNetworkMap) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipsToNetworks(ipToNetworkMap);
        }

        public static CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.setupStaticNat(setupStaticNat);
        }

        public static CloudStackTemplateOptions keyPair(String keyPair) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.keyPair(keyPair);
        }

        public static CloudStackTemplateOptions generateKeyPair(boolean enable) {
            return new CloudStackTemplateOptions().generateKeyPair(enable);
        }

        public static CloudStackTemplateOptions account(String account) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.account(account);
        }

        public static CloudStackTemplateOptions domainId(String domainId) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.domainId(domainId);
        }

        public static CloudStackTemplateOptions inboundPorts(int ... ports) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static CloudStackTemplateOptions blockOnPort(int port, int seconds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static CloudStackTemplateOptions userMetadata(Map<String, String> userMetadata) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static CloudStackTemplateOptions userMetadata(String key, String value) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.userMetadata(key, value));
        }

        public static CloudStackTemplateOptions nodeNames(Iterable<String> nodeNames) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static CloudStackTemplateOptions networks(Iterable<String> networks) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.networks((Iterable)networks));
        }

        public static CloudStackTemplateOptions networks(String ... networks) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.networks(networks));
        }
    }
}

