/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.google.inject.Singleton;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.inject.Inject;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class WindowsLoginCredentialsFromEncryptedData
implements Function<PasswordDataAndPrivateKey, LoginCredentials> {
    private final Crypto crypto;

    @Inject
    public WindowsLoginCredentialsFromEncryptedData(Crypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public LoginCredentials apply(@Nullable PasswordDataAndPrivateKey dataAndKey) {
        if (dataAndKey == null) {
            return null;
        }
        try {
            KeySpec keySpec = Pems.privateKeySpec(dataAndKey.getPrivateKey());
            KeyFactory kf = this.crypto.rsaKeyFactory();
            PrivateKey privKey = kf.generatePrivate(keySpec);
            Cipher cipher = this.crypto.cipher("RSA");
            cipher.init(2, privKey);
            byte[] cipherText = BaseEncoding.base64().decode(dataAndKey.getPasswordData().getPasswordData());
            byte[] plainText = cipher.doFinal(cipherText);
            String password = new String(plainText, Charsets.US_ASCII);
            return LoginCredentials.builder().user("Administrator").password(password).noPrivateKey().build();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

