/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.inject.Provider;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.DelegatesToInvocationFunction;

@Singleton
public class AnnotatedHttpApiProvider<A>
implements Provider<A> {
    private final Class<A> annotatedApiType;
    private final DelegatesToInvocationFunction<A, Function<Invocation, Object>> httpInvoker;

    @Inject
    private AnnotatedHttpApiProvider(DelegatesToInvocationFunction<A, Function<Invocation, Object>> httpInvoker, Class<A> annotatedApiType) {
        this.httpInvoker = httpInvoker;
        this.annotatedApiType = annotatedApiType;
    }

    @Override
    public A get() {
        return (A)Proxy.newProxyInstance(this.annotatedApiType.getClassLoader(), new Class[]{this.annotatedApiType}, this.httpInvoker);
    }
}

