/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.concurrent.Event;
import net.schmizz.concurrent.ExceptionChainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCopier {
    private static final Listener NULL_LISTENER = new Listener(){

        @Override
        public void reportProgress(long transferred) {
        }
    };
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InputStream in;
    private final OutputStream out;
    private Listener listener = NULL_LISTENER;
    private int bufSize = 1;
    private boolean keepFlushing = true;
    private long length = -1L;

    public StreamCopier(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public StreamCopier bufSize(int bufSize) {
        this.bufSize = bufSize;
        return this;
    }

    public StreamCopier keepFlushing(boolean keepFlushing) {
        this.keepFlushing = keepFlushing;
        return this;
    }

    public StreamCopier listener(Listener listener) {
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        this.listener = listener;
        return this;
    }

    public StreamCopier length(long length) {
        this.length = length;
        return this;
    }

    public Event<IOException> spawn(String name) {
        return this.spawn(name, false);
    }

    public Event<IOException> spawnDaemon(String name) {
        return this.spawn(name, true);
    }

    private Event<IOException> spawn(final String name, final boolean daemon) {
        final Event<IOException> doneEvent = new Event<IOException>("copyDone", new ExceptionChainer<IOException>(){

            @Override
            public IOException chain(Throwable t) {
                return t instanceof IOException ? (IOException)t : new IOException(t);
            }
        });
        new Thread(){
            {
                this.setName(name);
                this.setDaemon(daemon);
            }

            @Override
            public void run() {
                try {
                    StreamCopier.this.log.debug("Will copy from {} to {}", (Object)StreamCopier.this.in, (Object)StreamCopier.this.out);
                    StreamCopier.this.copy();
                    StreamCopier.this.log.debug("Done copying from {}", (Object)StreamCopier.this.in);
                    doneEvent.set();
                }
                catch (IOException ioe) {
                    StreamCopier.this.log.error("In pipe from {} to {}: {}", StreamCopier.this.in, StreamCopier.this.out, ioe);
                    doneEvent.deliverError(ioe);
                }
            }
        }.start();
        return doneEvent;
    }

    public long copy() throws IOException {
        byte[] buf = new byte[this.bufSize];
        long count = 0L;
        int read = 0;
        long startTime = System.currentTimeMillis();
        if (this.length == -1L) {
            while ((read = this.in.read(buf)) != -1) {
                count = this.write(buf, count, read);
            }
        } else {
            while (count < this.length && (read = this.in.read(buf, 0, (int)Math.min((long)this.bufSize, this.length - count))) != -1) {
                count = this.write(buf, count, read);
            }
        }
        if (!this.keepFlushing) {
            this.out.flush();
        }
        double timeSeconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        double sizeKiB = (double)count / 1024.0;
        this.log.info("{} KiB transferred in {} seconds ({} KiB/s)", sizeKiB, timeSeconds, sizeKiB / timeSeconds);
        if (this.length != -1L && read == -1) {
            throw new IOException("Encountered EOF, could not transfer " + this.length + " bytes");
        }
        return count;
    }

    private long write(byte[] buf, long count, int read) throws IOException {
        this.out.write(buf, 0, read);
        count += (long)read;
        if (this.keepFlushing) {
            this.out.flush();
        }
        this.listener.reportProgress(count);
        return count;
    }

    public static interface Listener {
        public void reportProgress(long var1) throws IOException;
    }
}

