/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.commands.Command;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandDataReceived
extends Command
implements Externalizable {
    private int transfergroupID;

    public CommandDataReceived() {
    }

    public CommandDataReceived(NIOAgent ng, int transfergroupID) {
        super(ng);
        this.transfergroupID = transfergroupID;
    }

    @Override
    public Command.CommandType getType() {
        return Command.CommandType.DATA_RECEIVED;
    }

    @Override
    public void handle(Connection c) {
        c.finishConnection();
        NIOAgent nm = this.agent;
        nm.copiedData(this.transfergroupID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.transfergroupID = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.transfergroupID);
    }

    public String toString() {
        return "Data for transfer group" + this.transfergroupID + "has been received in the remote worker";
    }
}

