/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.time.Duration;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;

public final class WordCountProcessorDemo {
    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("application.id", "streams-wordcount-processor");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("default.key.serde", Serdes.String().getClass());
        props.put("default.value.serde", Serdes.String().getClass());
        props.put("auto.offset.reset", "earliest");
        Topology builder = new Topology();
        builder.addSource("Source", new String[]{"streams-plaintext-input"});
        builder.addProcessor("Process", (ProcessorSupplier)new MyProcessorSupplier(), new String[]{"Source"});
        builder.addStateStore(Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"Counts"), (Serde)Serdes.String(), (Serde)Serdes.Integer()), new String[]{"Process"});
        builder.addSink("Sink", "streams-wordcount-processor-output", new String[]{"Process"});
        final KafkaStreams streams = new KafkaStreams(builder, props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-wordcount-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }

    static class MyProcessorSupplier
    implements ProcessorSupplier<String, String> {
        MyProcessorSupplier() {
        }

        public Processor<String, String> get() {
            return new Processor<String, String>(){
                private ProcessorContext context;
                private KeyValueStore<String, Integer> kvStore;

                public void init(ProcessorContext context) {
                    this.context = context;
                    this.context.schedule(Duration.ofSeconds(1L), PunctuationType.STREAM_TIME, timestamp -> {
                        try (KeyValueIterator iter = this.kvStore.all();){
                            System.out.println("----------- " + timestamp + " ----------- ");
                            while (iter.hasNext()) {
                                KeyValue entry = (KeyValue)iter.next();
                                System.out.println("[" + (String)entry.key + ", " + entry.value + "]");
                                context.forward((Object)((String)entry.key), (Object)((Integer)entry.value).toString());
                            }
                        }
                    });
                    this.kvStore = (KeyValueStore)context.getStateStore("Counts");
                }

                public void process(String dummy, String line) {
                    String[] words;
                    for (String word : words = line.toLowerCase(Locale.getDefault()).split(" ")) {
                        Integer oldValue = (Integer)this.kvStore.get((Object)word);
                        if (oldValue == null) {
                            this.kvStore.put((Object)word, (Object)1);
                            continue;
                        }
                        this.kvStore.put((Object)word, (Object)(oldValue + 1));
                    }
                    this.context.commit();
                }

                public void close() {
                }
            };
        }
    }
}

