/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.nio.NIOResultCollection;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.nio.master.utils.NIOParamFactory;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobImpl;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.CollectiveParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.worker.COMPSsException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NIOJob
extends JobImpl<NIOWorkerNode> {
    protected final List<String> slaveWorkersNodeNames;

    public NIOJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, taskParams, impl, res, listener, predecessors, numSuccessors);
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
    }

    public TaskType getType() {
        return TaskType.METHOD;
    }

    public void submitJob() throws Exception {
        LOGGER.info("Submit NIOJob with ID " + this.jobId);
        NIOAdaptor.submitTask(this);
    }

    public void cancelJob() throws Exception {
        LOGGER.info("Stopping NIOJob with ID " + this.jobId);
        NIOAdaptor.cancelTask(this);
    }

    public NIOTask prepareJob() {
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodDefinition methodImpl = (MethodDefinition)absMethodImpl.getDescription().getDefinition();
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName != null && !methodName.isEmpty()) break;
                methodImpl.setAlternativeMethodName(this.taskParams.getName());
                break;
            }
            case MULTI_NODE: {
                MultiNodeDefinition multiNodeImpl = (MultiNodeDefinition)absMethodImpl.getDescription().getDefinition();
                String multiNodeMethodName = multiNodeImpl.getMethodName();
                if (multiNodeMethodName != null && !multiNodeMethodName.isEmpty()) break;
                multiNodeImpl.setMethodName(this.taskParams.getName());
                break;
            }
        }
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size() - this.taskParams.getNumReturns();
        String parallelismSource = this.taskParams.getParallelismSource();
        NIOTask nt = new NIOTask(this.getLang(), DEBUG, absMethodImpl, parallelismSource, this.taskParams.hasTargetObject(), this.taskParams.getNumReturns(), params, numParams, absMethodImpl.getRequirements(), this.slaveWorkersNodeNames, this.taskId, this.impl.getTaskType(), this.jobId, this.history, this.transferId, this.getOnFailure(), this.getTimeOut(), this.getPredecessors(), this.getNumSuccessors());
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            params.add(NIOParamFactory.fromParameter(param, (NIOWorkerNode)this.getResourceNode(), this.taskParams.isReplicated()));
        }
        return params;
    }

    public void taskFinished(boolean successful, NIOTaskResult ntr, Exception e) {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        if (successful) {
            this.completed(ntr);
        } else if (e instanceof COMPSsException) {
            this.exception(ntr, (COMPSsException)e);
        } else {
            this.failed(ntr, JobEndStatus.EXECUTION_FAILED);
        }
    }

    private void completed(NIOTaskResult ntr) {
        this.registerAllJobOutputs(ntr);
        super.completed();
    }

    private void exception(NIOTaskResult ntr, COMPSsException e) {
        this.registerAllJobOutputs(ntr);
        super.exception(e);
    }

    private void failed(NIOTaskResult ntr, JobEndStatus status) {
        if (this.isBeingCancelled()) {
            this.registerAllJobOutputs(ntr);
        } else {
            switch (this.taskParams.getOnFailure()) {
                case IGNORE: 
                case CANCEL_SUCCESSORS: {
                    this.registerAllJobOutputs(ntr);
                    break;
                }
                default: {
                    this.removeTmpData();
                }
            }
        }
        super.failed(status);
    }

    private void registerAllJobOutputs(NIOTaskResult ntr) {
        List taskResults = ntr.getParamResults();
        List taskParams = this.getTaskParams().getParameters();
        Iterator taskParamsItr = taskParams.iterator();
        Iterator taskResultItr = taskResults.iterator();
        while (taskParamsItr.hasNext()) {
            Parameter param = (Parameter)taskParamsItr.next();
            NIOResult result = (NIOResult)taskResultItr.next();
            this.registerResult(param, result);
        }
    }

    protected void registerResult(Parameter param, NIOResult result) {
        Collection uris;
        if (!param.isPotentialDependency()) {
            return;
        }
        DependencyParameter dp = (DependencyParameter)param;
        String rename = this.getOutputRename((Parameter)dp);
        if (dp.isCollective()) {
            CollectiveParameter colParam = (CollectiveParameter)param;
            NIOResultCollection colResult = (NIOResultCollection)result;
            List taskResults = colResult.getElements();
            List taskParams = colParam.getElements();
            Iterator taskParamsItr = taskParams.iterator();
            Iterator taskResultItr = taskResults.iterator();
            while (taskParamsItr.hasNext()) {
                Parameter elemParam = (Parameter)taskParamsItr.next();
                NIOResult elemResult = (NIOResult)taskResultItr.next();
                this.registerResult(elemParam, elemResult);
            }
        }
        if (!(uris = result.getUris()).isEmpty() && rename != null) {
            for (NIOUri uri : uris) {
                String loc = uri.getPath();
                this.registerResultLocation(loc, rename, this.worker);
            }
            this.notifyResultAvailability(dp, rename);
        }
    }

    public String toString() {
        AbstractMethodImplementation method = (AbstractMethodImplementation)this.impl;
        String definition = method.getMethodDefinition();
        String methodName = this.taskParams.getName();
        return "NIOJob JobId" + this.jobId + " for method " + methodName + " with definition " + definition;
    }
}

