/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.types.resources.updates.PendingReduction;
import es.bsc.compss.util.ResourceManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DynamicMethodWorker
extends MethodWorker {
    private final List<PendingReduction<MethodResourceDescription>> pendingReductions;
    private final MethodResourceDescription toRemove;

    public DynamicMethodWorker(String name, MethodResourceDescription description, COMPSsWorker worker, int limitOfTasks, int limitGPUTasks, int limitFPGATasks, int limitOTHERTasks, Map<String, String> sharedDisks) {
        super(name, description, worker, limitOfTasks, limitGPUTasks, limitFPGATasks, limitOTHERTasks, sharedDisks);
        this.toRemove = new MethodResourceDescription();
        this.pendingReductions = new LinkedList<PendingReduction<MethodResourceDescription>>();
    }

    public DynamicMethodWorker(String name, MethodResourceDescription description, MethodConfiguration config, Map<String, String> sharedDisks) {
        super(name, description, config, sharedDisks);
        this.toRemove = new MethodResourceDescription();
        this.pendingReductions = new LinkedList<PendingReduction<MethodResourceDescription>>();
    }

    public DynamicMethodWorker(DynamicMethodWorker cmw) {
        super(cmw);
        this.toRemove = cmw.toRemove.copy();
        this.pendingReductions = cmw.pendingReductions;
    }

    @Override
    public ResourceType getType() {
        return ResourceType.WORKER;
    }

    @Override
    public MethodResourceDescription getDescription() {
        return (MethodResourceDescription)super.getDescription();
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(super.getMonitoringData(prefix));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFeatures(MethodResourceDescription increment) {
        int CPUCount = increment.getTotalCPUComputingUnits();
        int GPUCount = increment.getTotalGPUComputingUnits();
        int FPGACount = increment.getTotalFPGAComputingUnits();
        int otherCount = increment.getTotalOTHERComputingUnits();
        this.getNode().increaseComputingCapabilities((ResourceDescription)increment);
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.increase((ResourceDescription)increment);
        }
        methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            ((MethodResourceDescription)this.description).increase((ResourceDescription)increment);
        }
        this.setMaxCPUTaskCount(this.getMaxCPUTaskCount() + CPUCount);
        this.setMaxGPUTaskCount(this.getMaxGPUTaskCount() + GPUCount);
        this.setMaxFPGATaskCount(this.getMaxFPGATaskCount() + FPGACount);
        this.setMaxOthersTaskCount(this.getMaxOthersTaskCount() + otherCount);
        this.updatedFeatures();
    }

    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        if (!this.hasAvailable(consumption)) {
            return null;
        }
        return super.reserveResource(consumption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseResource(MethodResourceDescription consumption) {
        LOGGER.debug("Checking cloud resources to release...");
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            super.releaseResource(consumption);
            List<PendingReduction<MethodResourceDescription>> list = this.pendingReductions;
            synchronized (list) {
                if (!this.pendingReductions.isEmpty()) {
                    PendingReduction<MethodResourceDescription> pRed;
                    Iterator<PendingReduction<MethodResourceDescription>> prIt = this.pendingReductions.iterator();
                    while (prIt.hasNext() && this.available.containsDynamic((MethodResourceDescription)(pRed = prIt.next()).getModification())) {
                        this.available.reduce(pRed.getModification());
                        MethodResourceDescription methodResourceDescription2 = this.toRemove;
                        synchronized (methodResourceDescription2) {
                            this.toRemove.reduce(pRed.getModification());
                        }
                        LOGGER.debug("Releasing cloud resource " + this.getName());
                        pRed.notifyCompletion();
                        prIt.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyReduction(PendingReduction<MethodResourceDescription> pRed) {
        MethodResourceDescription reduction = (MethodResourceDescription)pRed.getModification();
        int CPUCount = reduction.getTotalCPUComputingUnits();
        int GPUCount = reduction.getTotalGPUComputingUnits();
        int FPGACount = reduction.getTotalFPGAComputingUnits();
        int otherCount = reduction.getTotalOTHERComputingUnits();
        if (!this.isLost()) {
            this.getNode().reduceComputingCapabilities((ResourceDescription)reduction);
        }
        MethodResourceDescription methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            this.getDescription().reduce((ResourceDescription)reduction);
        }
        methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            if (!this.hasAvailable(reduction) && this.getUsedCPUTaskCount() > 0) {
                LOGGER.debug("Resource in use. Adding pending reduction");
                Object object = this.toRemove;
                synchronized (object) {
                    this.toRemove.increase((ResourceDescription)reduction);
                }
                object = this.pendingReductions;
                synchronized (object) {
                    this.pendingReductions.add(pRed);
                }
            }
            this.available.reduce((ResourceDescription)reduction);
            pRed.notifyCompletion();
        }
        this.setMaxCPUTaskCount(this.getMaxCPUTaskCount() - CPUCount);
        this.setMaxGPUTaskCount(this.getMaxGPUTaskCount() - GPUCount);
        this.setMaxFPGATaskCount(this.getMaxFPGATaskCount() - FPGACount);
        this.setMaxOthersTaskCount(this.getMaxOthersTaskCount() - otherCount);
        this.updatedFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            MethodResourceDescription methodResourceDescription2 = this.toRemove;
            synchronized (methodResourceDescription2) {
                consumption.increaseDynamic((ResourceDescription)this.toRemove);
                boolean fits = super.hasAvailable(consumption);
                consumption.reduceDynamic((ResourceDescription)this.toRemove);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cloud Method Worker received:");
                    LOGGER.debug("With result: " + fits);
                }
                return fits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBeStopped() {
        MethodResourceDescription methodResourceDescription = (MethodResourceDescription)this.description;
        synchronized (methodResourceDescription) {
            return this.getDescription().isDynamicUseless();
        }
    }

    public <T extends WorkerResourceDescription> void destroyResources(T modification) {
        ResourceManager.terminateDynamicResource(this, (MethodResourceDescription)modification);
    }

    @Override
    public DynamicMethodWorker getSchedulingCopy() {
        return new DynamicMethodWorker(this);
    }
}

