/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ResourceType;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.configuration.Configuration;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import es.bsc.compss.util.ResourceManager;
import java.util.Map;

public class MethodWorker
extends Worker<MethodResourceDescription> {
    private String name;
    protected final MethodResourceDescription available;
    private int usedCPUtaskCount = 0;
    private int maxCPUtaskCount;
    private int usedGPUtaskCount = 0;
    private int maxGPUtaskCount;
    private int usedFPGAtaskCount = 0;
    private int maxFPGAtaskCount;
    private int usedOthersTaskCount = 0;
    private int maxOthersTaskCount;

    public MethodWorker(String name, MethodResourceDescription description, COMPSsWorker worker, int limitOfTasks, int limitGPUTasks, int limitFPGATasks, int limitOTHERTasks, Map<String, String> sharedDisks) {
        super(name, description, (COMPSsNode)worker, limitOfTasks, sharedDisks);
        this.name = name;
        this.available = new MethodResourceDescription((MethodResourceDescription)this.getDescription());
        this.maxCPUtaskCount = limitOfTasks;
        this.maxGPUtaskCount = limitGPUTasks;
        this.maxFPGAtaskCount = limitFPGATasks;
        this.maxOthersTaskCount = limitOTHERTasks;
    }

    public MethodWorker(String name, MethodResourceDescription description, MethodConfiguration conf, Map<String, String> sharedDisks) {
        super(name, description, (Configuration)conf, sharedDisks);
        this.name = name;
        this.available = new MethodResourceDescription((MethodResourceDescription)this.getDescription());
        this.maxCPUtaskCount = conf.getLimitOfTasks();
        this.maxGPUtaskCount = conf.getLimitOfGPUTasks();
        this.maxFPGAtaskCount = conf.getLimitOfFPGATasks();
        this.maxOthersTaskCount = conf.getLimitOfOTHERsTasks();
    }

    public MethodWorker(MethodWorker mw) {
        super(mw);
        this.available = mw.available.copy();
        this.maxCPUtaskCount = mw.maxCPUtaskCount;
        this.usedCPUtaskCount = mw.usedCPUtaskCount;
        this.maxGPUtaskCount = mw.maxGPUtaskCount;
        this.usedGPUtaskCount = mw.usedGPUtaskCount;
        this.maxFPGAtaskCount = mw.maxFPGAtaskCount;
        this.usedFPGAtaskCount = mw.usedFPGAtaskCount;
        this.maxOthersTaskCount = mw.maxOthersTaskCount;
        this.usedOthersTaskCount = mw.usedOthersTaskCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected int limitIdealSimultaneousTasks(int ideal) {
        return Math.min(this.getMaxCPUTaskCount(), ideal);
    }

    public MethodResourceDescription getAvailable() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            if (this.hasAvailable(consumption)) {
                return (MethodResourceDescription)this.available.reduceDynamic((ResourceDescription)consumption);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.increaseDynamic((ResourceDescription)consumption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllResources() {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            super.resetUsedTaskCounts();
            this.available.reduceDynamic((ResourceDescription)this.available);
            this.available.increaseDynamic((ResourceDescription)this.description);
        }
    }

    @Override
    public Integer fitCount(Implementation impl) {
        if (impl.getTaskType() != TaskType.METHOD) {
            return null;
        }
        MethodResourceDescription ctrs = (MethodResourceDescription)impl.getRequirements();
        return ((MethodResourceDescription)this.description).canHostSimultaneously(ctrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            return this.available.containsDynamic(consumption);
        }
    }

    @Override
    public boolean hasAvailableSlots() {
        return this.usedCPUtaskCount < this.maxCPUtaskCount || this.usedGPUtaskCount < this.maxGPUtaskCount || this.usedFPGAtaskCount < this.maxFPGAtaskCount || this.usedOthersTaskCount < this.maxOthersTaskCount;
    }

    public void setMaxCPUTaskCount(int maxCPUTaskCount) {
        this.maxCPUtaskCount = maxCPUTaskCount;
    }

    public int getMaxCPUTaskCount() {
        return this.maxCPUtaskCount;
    }

    public int getUsedCPUTaskCount() {
        return this.usedCPUtaskCount;
    }

    private void decreaseUsedCPUTaskCount() {
        --this.usedCPUtaskCount;
    }

    private void increaseUsedCPUTaskCount() {
        ++this.usedCPUtaskCount;
    }

    public void setMaxGPUTaskCount(int maxGPUTaskCount) {
        this.maxGPUtaskCount = maxGPUTaskCount;
    }

    public int getMaxGPUTaskCount() {
        return this.maxGPUtaskCount;
    }

    public int getUsedGPUTaskCount() {
        return this.usedGPUtaskCount;
    }

    private void decreaseUsedGPUTaskCount() {
        --this.usedGPUtaskCount;
    }

    private void increaseUsedGPUTaskCount() {
        ++this.usedGPUtaskCount;
    }

    public void setMaxFPGATaskCount(int maxFPGATaskCount) {
        this.maxFPGAtaskCount = maxFPGATaskCount;
    }

    public int getMaxFPGATaskCount() {
        return this.maxFPGAtaskCount;
    }

    public int getUsedFPGATaskCount() {
        return this.usedFPGAtaskCount;
    }

    private void decreaseUsedFPGATaskCount() {
        --this.usedFPGAtaskCount;
    }

    private void increaseUsedFPGATaskCount() {
        ++this.usedFPGAtaskCount;
    }

    public void setMaxOthersTaskCount(int maxOthersTaskCount) {
        this.maxOthersTaskCount = maxOthersTaskCount;
    }

    public int getMaxOthersTaskCount() {
        return this.maxOthersTaskCount;
    }

    public int getUsedOthersTaskCount() {
        return this.usedOthersTaskCount;
    }

    private void decreaseUsedOthersTaskCount() {
        --this.usedOthersTaskCount;
    }

    private void increaseUsedOthersTaskCount() {
        ++this.usedOthersTaskCount;
    }

    @Override
    public void resetUsedTaskCounts() {
        super.resetUsedTaskCounts();
        this.usedCPUtaskCount = 0;
        this.usedGPUtaskCount = 0;
        this.usedFPGAtaskCount = 0;
        this.usedOthersTaskCount = 0;
    }

    @Override
    public Integer simultaneousCapacity(Implementation impl) {
        return Math.min(super.simultaneousCapacity(impl), this.getMaxCPUTaskCount());
    }

    public ResourceType getType() {
        return ResourceType.WORKER;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<TotalCPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("</TotalCPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalGPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("</TotalGPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalFPGAComputingUnits>").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("</TotalFPGAComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalOTHERComputingUnits>").append(((MethodResourceDescription)this.description).getTotalOTHERComputingUnits()).append("</TotalOTHERComputingUnits>").append("\n");
        sb.append(prefix).append("<Memory>").append(((MethodResourceDescription)this.description).getMemorySize()).append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append(((MethodResourceDescription)this.description).getStorageSize()).append("</Disk>").append("\n");
        return sb.toString();
    }

    private Float getValue() {
        return ((MethodResourceDescription)this.description).value;
    }

    @Override
    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case HTTP: {
                return 1;
            }
            case WORKER: {
                MethodWorker w = (MethodWorker)t;
                if (((MethodResourceDescription)this.description).getValue() == null) {
                    if (w.getValue() == null) {
                        return w.getName().compareTo(this.getName());
                    }
                    return 1;
                }
                if (w.getValue() == null) {
                    return -1;
                }
                float dif = w.getValue().floatValue() - ((MethodResourceDescription)this.description).getValue().floatValue();
                if (dif > 0.0f) {
                    return -1;
                }
                if (dif < 0.0f) {
                    return 1;
                }
                return this.getName().compareTo(w.getName());
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation implementation) {
        if (this.isLost()) {
            return false;
        }
        switch (implementation.getTaskType()) {
            case METHOD: {
                MethodResourceDescription ctrs = (MethodResourceDescription)implementation.getRequirements();
                return ((MethodResourceDescription)this.description).contains(ctrs);
            }
        }
        return false;
    }

    @Override
    public boolean canRunNow(MethodResourceDescription consumption) {
        boolean canRun = super.canRunNow(consumption);
        canRun = canRun && (this.getUsedCPUTaskCount() < this.getMaxCPUTaskCount() || !consumption.containsCPU());
        canRun = canRun && (this.getUsedGPUTaskCount() < this.getMaxGPUTaskCount() || !consumption.containsGPU());
        canRun = canRun && (this.getUsedFPGATaskCount() < this.getMaxFPGATaskCount() || !consumption.containsFPGA());
        canRun = canRun && (this.getUsedOthersTaskCount() < this.getMaxOthersTaskCount() || !consumption.containsOthers());
        canRun = canRun && this.hasAvailable(consumption);
        return canRun;
    }

    @Override
    public void endTask(MethodResourceDescription consumption) {
        if (DEBUG) {
            LOGGER.debug("End task received. Releasing resource " + this.getName());
        }
        if (consumption.containsCPU()) {
            this.decreaseUsedCPUTaskCount();
        }
        if (consumption.containsGPU()) {
            this.decreaseUsedGPUTaskCount();
        }
        if (consumption.containsFPGA()) {
            this.decreaseUsedFPGATaskCount();
        }
        if (consumption.containsOthers()) {
            this.decreaseUsedOthersTaskCount();
        }
        super.endTask(consumption);
    }

    @Override
    public MethodResourceDescription runTask(MethodResourceDescription consumption) {
        MethodResourceDescription reserved = super.runTask(consumption);
        if (DEBUG) {
            LOGGER.debug("Run task received. Reserving resource " + consumption + " on " + this.getName());
        }
        if (reserved != null) {
            if (consumption.containsCPU()) {
                this.increaseUsedCPUTaskCount();
            }
            if (consumption.containsGPU()) {
                this.increaseUsedGPUTaskCount();
            }
            if (consumption.containsFPGA()) {
                this.increaseUsedFPGATaskCount();
            }
            if (consumption.containsOthers()) {
                this.increaseUsedOthersTaskCount();
            }
            return reserved;
        }
        return reserved;
    }

    @Override
    public void idleReservedResourcesDetected(ResourceDescription resources) {
        ResourceManager.notifyIdleResources(this, (MethodResourceDescription)resources);
    }

    @Override
    public void reactivatedReservedResourcesDetected(ResourceDescription resources) {
        ResourceManager.notifyResourcesReacquisition(this, (MethodResourceDescription)resources);
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = WORKER").append("\n");
        sb.append(prefix).append("CPU_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("\n");
        sb.append(prefix).append("GPU_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("\n");
        sb.append(prefix).append("FPGA_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("\n");
        sb.append(prefix).append("OTHER_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("\n");
        sb.append(prefix).append("MEMORY = ").append(((MethodResourceDescription)this.description).getMemorySize()).append("\n");
        return sb.toString();
    }

    public MethodWorker getSchedulingCopy() {
        return new MethodWorker(this);
    }

    @Override
    public String toString() {
        return "Worker " + this.name + " with usedTaskCount = " + this.usedCPUtaskCount + " and maxTaskCount = " + this.maxCPUtaskCount + " with the following description " + this.description;
    }
}

