/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources.description;

import es.bsc.compss.types.annotations.Constraints;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CloudMethodResourceDescription
extends MethodResourceDescription {
    public static final CloudMethodResourceDescription EMPTY = new CloudMethodResourceDescription();
    private String name;
    private final Map<CloudInstanceTypeDescription, int[]> typeComposition;
    private CloudImageDescription image;

    public CloudMethodResourceDescription() {
        this.name = "";
        this.typeComposition = new HashMap<CloudInstanceTypeDescription, int[]>();
        this.image = null;
    }

    public CloudMethodResourceDescription(Constraints constraints) {
        super(constraints);
        this.name = "";
        this.typeComposition = new HashMap<CloudInstanceTypeDescription, int[]>();
        this.image = null;
    }

    public CloudMethodResourceDescription(MethodResourceDescription constraints) {
        super(constraints);
        this.name = "";
        this.typeComposition = new HashMap<CloudInstanceTypeDescription, int[]>();
        this.image = null;
    }

    public CloudMethodResourceDescription(CloudMethodResourceDescription clone) {
        super((MethodResourceDescription)clone);
        this.name = clone.name;
        this.typeComposition = new HashMap<CloudInstanceTypeDescription, int[]>();
        for (Map.Entry<CloudInstanceTypeDescription, int[]> entry : clone.typeComposition.entrySet()) {
            this.typeComposition.put(entry.getKey(), new int[]{entry.getValue()[0]});
        }
        this.image = clone.image;
    }

    public CloudMethodResourceDescription(CloudInstanceTypeDescription type, CloudImageDescription image) {
        super(type.getResourceDescription());
        this.name = "";
        this.typeComposition = new HashMap<CloudInstanceTypeDescription, int[]>();
        this.typeComposition.put(type, new int[]{1});
        this.image = image;
    }

    public CloudMethodResourceDescription copy() {
        return new CloudMethodResourceDescription(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CloudImageDescription getImage() {
        return this.image;
    }

    public void setImage(CloudImageDescription image) {
        this.image = image;
    }

    public Map<CloudInstanceTypeDescription, int[]> getTypeComposition() {
        return this.typeComposition;
    }

    public void addInstances(CloudInstanceTypeDescription type, int count) {
        int[] counts = this.typeComposition.get(type);
        if (counts != null) {
            counts[0] = counts[0] + count;
        } else {
            this.typeComposition.put(type, new int[]{count});
        }
    }

    public void addInstance(CloudInstanceTypeDescription type) {
        int[] counts = this.typeComposition.get(type);
        if (counts != null) {
            counts[0] = counts[0] + 1;
        } else {
            this.typeComposition.put(type, new int[]{1});
        }
    }

    public void increase(ResourceDescription cmrd) {
        super.increase(cmrd);
        for (Map.Entry<CloudInstanceTypeDescription, int[]> typeCount : ((CloudMethodResourceDescription)cmrd).getTypeComposition().entrySet()) {
            CloudInstanceTypeDescription type = typeCount.getKey();
            int[] count = typeCount.getValue();
            this.addInstances(type, count[0]);
        }
    }

    public List<CloudInstanceTypeDescription> getPossibleReductions() {
        LinkedList<CloudInstanceTypeDescription> reductions = new LinkedList<CloudInstanceTypeDescription>();
        for (CloudInstanceTypeDescription type : this.typeComposition.keySet()) {
            reductions.add(type);
        }
        return reductions;
    }

    public void removeInstance(CloudInstanceTypeDescription type) {
        int[] counts = this.typeComposition.get(type);
        if (counts != null) {
            counts[0] = counts[0] - 1;
            if (counts[0] == 0) {
                this.typeComposition.remove(type);
            }
        }
    }

    public void removeInstances(CloudInstanceTypeDescription type, int count) {
        int[] counts = this.typeComposition.get(type);
        if (counts != null) {
            counts[0] = counts[0] - count;
            if (counts[0] < 1) {
                this.typeComposition.remove(type);
            }
        }
    }

    public void reduce(ResourceDescription cmrd) {
        super.reduce(cmrd);
        for (Map.Entry<CloudInstanceTypeDescription, int[]> typeCount : ((CloudMethodResourceDescription)cmrd).getTypeComposition().entrySet()) {
            CloudInstanceTypeDescription type = typeCount.getKey();
            int[] count = typeCount.getValue();
            this.removeInstances(type, count[0]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[CLOUD");
        sb.append(" IMAGE=").append(this.image == null ? "NULL" : this.image.getImageName());
        sb.append(" TYPE_COMPOSITION=[");
        for (Map.Entry<CloudInstanceTypeDescription, int[]> entry : this.typeComposition.entrySet()) {
            sb.append(" ").append(entry.getKey().getName()).append("=").append(entry.getValue()[0]);
        }
        sb.append("]]");
        return sb.toString();
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("\t").append("VIRTUAL_INSTANCE = [").append("\n");
        sb.append(prefix).append("\t").append("\t").append("NAME = ").append(this.name).append("\n");
        sb.append(prefix).append("\t").append("\t").append("COMPONENTS = [").append("\n");
        for (Map.Entry<CloudInstanceTypeDescription, int[]> component : this.typeComposition.entrySet()) {
            String componentName = component.getKey().getName();
            int[] amount = component.getValue();
            sb.append(prefix).append("\t").append("\t").append("\t").append("COMPONENT = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("NAME = ").append(componentName).append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("AMOUNT = ").append(amount[0]).append("\n");
            sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("\t").append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("]").append("\n");
        return sb.toString();
    }
}

