/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.connectors.ConnectorException;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.util.Classpath;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudManager {
    private static final String CONNECTORS_REL_PATH = File.separator + "Runtime" + File.separator + "connectors" + File.separator;
    private static final String WARN_RESOURCES_PREFIX = "WARN_MSG = [";
    private static final String WARN_NO_COMPSS_HOME = "WARN: COMPSS_HOME not defined, no default connectors loaded";
    private static final String WARN_NO_COMPSS_HOME_RESOURCES = "WARN_MSG = [COMPSS_HOME NOT DEFINED, NO DEFAULT CONNECTORS LOADED]";
    private static final String WARN_NO_CONNECTORS_FOLDER = "WARN: Connectors folder not defined, no default connectors loaded";
    private static final String WARN_NO_CONNECTORS_FOLDER_RESOURCES = "WARN_MSG = [CONNECTORS FOLDER NOT DEFINED, NO DEFAULT CONNECTORS LOADED]";
    private static final Logger RUNTIME_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Components.CloudManager");
    private static final Logger RESOURCES_LOGGER = LogManager.getLogger((String)"es.bsc.compss.Resources");
    private final Map<String, CloudProvider> providers;
    private boolean useCloud;
    private int initialVMs = 0;
    private int minVMs = 0;
    private int maxVMs = Integer.MAX_VALUE;

    public CloudManager() {
        RUNTIME_LOGGER.info("Initializing Cloud Manager");
        this.useCloud = false;
        this.providers = new HashMap<String, CloudProvider>();
    }

    public int getMinVMs() {
        return this.minVMs;
    }

    public int getMaxVMs() {
        if (this.maxVMs > this.minVMs) {
            return this.maxVMs;
        }
        return this.minVMs;
    }

    public int getInitialVMs() {
        int initialVMs = this.initialVMs;
        if (initialVMs > this.maxVMs) {
            initialVMs = this.maxVMs;
        }
        if (initialVMs < this.minVMs) {
            initialVMs = this.minVMs;
        }
        return initialVMs;
    }

    public void setMinVMs(Integer minVMs) {
        if (minVMs != null) {
            if (minVMs > 0) {
                this.minVMs = minVMs;
                if (minVMs > this.maxVMs) {
                    ErrorManager.warn((String)("Cloud: MaxVMs (" + this.maxVMs + ") is lower than MinVMs (" + this.minVMs + "). The current MaxVMs value (" + this.maxVMs + ") is ignored until MinVMs (" + this.minVMs + ") is lower than it"));
                }
            } else {
                this.minVMs = 0;
            }
        }
    }

    public void setMaxVMs(Integer maxVMs) {
        if (maxVMs != null) {
            this.maxVMs = maxVMs > 0 ? maxVMs : 0;
            if (this.minVMs > maxVMs) {
                ErrorManager.warn((String)("Cloud: MaxVMs (" + this.maxVMs + ") is lower than MinVMs (" + this.minVMs + "). The current MaxVMs value (" + this.maxVMs + ") is ignored until MinVMs (" + this.minVMs + ") is higher than it"));
            }
        }
    }

    public void setInitialVMs(Integer initialVMs) {
        if (initialVMs != null) {
            this.initialVMs = initialVMs > 0 ? initialVMs : 0;
        }
    }

    public boolean isUseCloud() {
        return this.useCloud;
    }

    public CloudProvider registerCloudProvider(String providerName, Integer limitOfVMs, String runtimeConnectorClass, String connectorJarPath, String connectorMainClass, Map<String, String> connectorProperties) throws ConnectorException {
        CloudProvider cp = new CloudProvider(providerName, limitOfVMs, runtimeConnectorClass, connectorJarPath, connectorMainClass, connectorProperties);
        this.useCloud = true;
        this.providers.put(cp.getName(), cp);
        return cp;
    }

    public Collection<CloudProvider> getProviders() {
        return this.providers.values();
    }

    public CloudProvider getProvider(String name) {
        if (this.providers.containsKey(name)) {
            return this.providers.get(name);
        }
        return null;
    }

    public void newCoreElementsDetected(List<Integer> newCores) {
        for (CloudProvider cp : this.providers.values()) {
            cp.newCoreElementsDetected(newCores);
        }
    }

    public List<ResourceCreationRequest> getPendingRequests() {
        LinkedList<ResourceCreationRequest> pendingRequests = new LinkedList<ResourceCreationRequest>();
        for (CloudProvider cp : this.providers.values()) {
            pendingRequests.addAll(cp.getPendingRequests());
        }
        return pendingRequests;
    }

    public int[] getPendingCoreCounts() {
        int coreCount = CoreManager.getCoreCount();
        int[] pendingCoreCounts = new int[coreCount];
        for (CloudProvider cp : this.providers.values()) {
            int[] providerCounts = cp.getPendingCoreCounts();
            for (int coreId = 0; coreId < providerCounts.length; ++coreId) {
                int n = coreId;
                pendingCoreCounts[n] = pendingCoreCounts[n] + providerCounts[coreId];
            }
        }
        return pendingCoreCounts;
    }

    public void terminateALL() throws ConnectorException {
        RUNTIME_LOGGER.debug("[Cloud Manager] Terminate ALL resources");
        if (this.providers != null) {
            for (Map.Entry<String, CloudProvider> vm : this.providers.entrySet()) {
                CloudProvider cp = vm.getValue();
                cp.terminateAll();
            }
        }
    }

    public float currentCostPerHour() {
        float total = 0.0f;
        for (CloudProvider cp : this.providers.values()) {
            total += cp.getCurrentCostPerHour();
        }
        return total;
    }

    public void stopReached() {
        for (CloudProvider cp : this.providers.values()) {
            cp.stopReached();
        }
    }

    public float getTotalCost() {
        float total = 0.0f;
        for (CloudProvider cp : this.providers.values()) {
            total += cp.getTotalCost();
        }
        return total;
    }

    public long getNextCreationTime() throws Exception {
        long total = 0L;
        for (CloudProvider cp : this.providers.values()) {
            total = Math.max(total, cp.getNextCreationTime());
        }
        return total;
    }

    public long getTimeSlot() throws Exception {
        long total = Long.MAX_VALUE;
        for (CloudProvider cp : this.providers.values()) {
            total = Math.min(total, cp.getTimeSlot());
        }
        return total;
    }

    public int getCurrentVMCount() {
        int total = 0;
        for (CloudProvider cp : this.providers.values()) {
            total += cp.getCurrentVMCount();
        }
        return total;
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("CLOUD = [").append("\n");
        sb.append(prefix).append("\t").append("CURRENT_STATE = [").append("\n");
        for (CloudProvider cp : this.providers.values()) {
            sb.append(cp.getCurrentState(prefix + "\t\t"));
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("\t").append("PENDING_REQUESTS = [").append("\n");
        for (CloudProvider cp : this.providers.values()) {
            for (ResourceCreationRequest rcr : cp.getPendingRequests()) {
                Map<CloudInstanceTypeDescription, int[]> composition = rcr.getRequested().getTypeComposition();
                for (CloudInstanceTypeDescription citd : composition.keySet()) {
                    sb.append(prefix).append("\t").append("\t").append("REQUEST = ").append(citd.getName()).append("\n");
                }
            }
        }
        sb.append(prefix).append("\t").append("]").append("\n");
        sb.append(prefix).append("]");
        return sb.toString();
    }

    static {
        RUNTIME_LOGGER.debug("Loading runtime connectors to classpath...");
        String compssHome = System.getenv("COMPSS_HOME");
        if (compssHome == null || compssHome.isEmpty()) {
            RESOURCES_LOGGER.warn(WARN_NO_COMPSS_HOME_RESOURCES);
            RUNTIME_LOGGER.warn(WARN_NO_COMPSS_HOME);
        } else {
            String connPath = compssHome + CONNECTORS_REL_PATH;
            Classpath.loadJarsInPath((String)connPath, (Logger)RUNTIME_LOGGER);
        }
    }
}

