/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.CoreManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class WorkerPool {
    private final Map<String, Worker<? extends WorkerResourceDescription>> staticSet = new HashMap<String, Worker<? extends WorkerResourceDescription>>();
    private final Map<String, DynamicMethodWorker> criticalSet = new HashMap<String, DynamicMethodWorker>();
    private final Map<String, DynamicMethodWorker> nonCriticalSet = new HashMap<String, DynamicMethodWorker>();
    private final Set<DynamicMethodWorker> criticalOrder = new TreeSet<DynamicMethodWorker>();

    public void addStaticResource(Worker<? extends WorkerResourceDescription> newResource) {
        this.staticSet.put(newResource.getName(), newResource);
    }

    public void addDynamicResource(DynamicMethodWorker newResource) {
        this.criticalSet.put(newResource.getName(), newResource);
        this.criticalOrder.add(newResource);
    }

    public void coreElementUpdates(List<Integer> newCores) {
        for (Worker<? extends WorkerResourceDescription> worker : this.staticSet.values()) {
            worker.updatedCoreElements(newCores);
        }
        for (DynamicMethodWorker dynamicMethodWorker : this.criticalSet.values()) {
            dynamicMethodWorker.updatedCoreElements(newCores);
        }
        for (DynamicMethodWorker dynamicMethodWorker : this.nonCriticalSet.values()) {
            dynamicMethodWorker.updatedCoreElements(newCores);
        }
    }

    public Collection<Worker<? extends WorkerResourceDescription>> getStaticResources() {
        return this.staticSet.values();
    }

    public Worker<? extends WorkerResourceDescription> getStaticResource(String resourceName) {
        return this.staticSet.get(resourceName);
    }

    public List<DynamicMethodWorker> getDynamicResources() {
        LinkedList<DynamicMethodWorker> resources = new LinkedList<DynamicMethodWorker>();
        resources.addAll(this.criticalSet.values());
        resources.addAll(this.nonCriticalSet.values());
        return resources;
    }

    public DynamicMethodWorker getDynamicResource(String resourceName) {
        DynamicMethodWorker resource = null;
        resource = this.criticalSet.get(resourceName);
        if (resource == null) {
            resource = this.nonCriticalSet.get(resourceName);
        }
        return resource;
    }

    public Worker<? extends WorkerResourceDescription> getResource(String resourceName) {
        Worker resource = null;
        resource = this.staticSet.get(resourceName);
        if (resource == null) {
            resource = this.criticalSet.get(resourceName);
        }
        if (resource == null) {
            resource = this.nonCriticalSet.get(resourceName);
        }
        return resource;
    }

    public void delete(Worker<? extends WorkerResourceDescription> resource) {
        String resourceName = resource.getName();
        if (this.nonCriticalSet.remove(resourceName) == null) {
            DynamicMethodWorker worker = this.criticalSet.remove(resourceName);
            if (worker == null) {
                this.staticSet.remove(resourceName);
            } else {
                this.criticalOrder.remove(worker);
            }
        }
    }

    public List<Integer> getExecutableCores(String resourceName) {
        Worker<? extends WorkerResourceDescription> resource = this.getResource(resourceName);
        if (resource == null) {
            return new LinkedList<Integer>();
        }
        return resource.getExecutableCores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineCriticalSet() {
        WorkerPool workerPool = this;
        synchronized (workerPool) {
            int coreCount = CoreManager.getCoreCount();
            boolean[] runnable = new boolean[coreCount];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                runnable[coreId] = false;
            }
            for (Worker<? extends WorkerResourceDescription> res : this.staticSet.values()) {
                List<Integer> cores = res.getExecutableCores();
                for (int i = 0; i < cores.size(); ++i) {
                    runnable[cores.get((int)i).intValue()] = true;
                }
            }
            LinkedList<DynamicMethodWorker> criticalOrderRemovals = new LinkedList<DynamicMethodWorker>();
            for (DynamicMethodWorker resource : this.criticalOrder) {
                int i;
                String resourceName = resource.getName();
                List<Integer> executableCores = resource.getExecutableCores();
                boolean needed = false;
                for (i = 0; i < executableCores.size() && !needed; ++i) {
                    needed = needed || !runnable[executableCores.get(i)];
                }
                if (needed) {
                    for (i = 0; i < executableCores.size(); ++i) {
                        runnable[executableCores.get((int)i).intValue()] = true;
                    }
                    continue;
                }
                this.criticalSet.remove(resourceName);
                criticalOrderRemovals.add(resource);
                this.nonCriticalSet.put(resourceName, resource);
            }
            for (DynamicMethodWorker resource : criticalOrderRemovals) {
                this.criticalOrder.remove(resource);
            }
        }
    }

    public Collection<DynamicMethodWorker> getNonCriticalResources() {
        return this.nonCriticalSet.values();
    }

    public Collection<DynamicMethodWorker> getCriticalResources() {
        return this.criticalSet.values();
    }

    public List<Worker<? extends WorkerResourceDescription>> findAllResources() {
        int i;
        LinkedList<Worker<? extends WorkerResourceDescription>> workers = new LinkedList<Worker<? extends WorkerResourceDescription>>();
        if (this.staticSet != null && !this.staticSet.isEmpty()) {
            Object[] arrayStaticSet = this.staticSet.values().toArray();
            for (i = 0; i < arrayStaticSet.length; ++i) {
                workers.add((Worker)arrayStaticSet[i]);
            }
        }
        if (this.criticalSet != null && !this.criticalSet.isEmpty()) {
            Object[] arrayCriticalSet = this.criticalSet.values().toArray();
            for (i = 0; i < arrayCriticalSet.length; ++i) {
                workers.add((Worker)arrayCriticalSet[i]);
            }
        }
        if (this.nonCriticalSet != null && !this.nonCriticalSet.isEmpty()) {
            Object[] arrayNonCriticalSet = this.nonCriticalSet.values().toArray();
            for (i = 0; i < arrayNonCriticalSet.length; ++i) {
                workers.add((Worker)arrayNonCriticalSet[i]);
            }
        }
        return workers;
    }

    public boolean isCriticalRemovalSafe(int[][] slotReductionImpls) {
        int coreCount = CoreManager.getCoreCount();
        int[] slotReductionCores = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            for (int implId = 0; implId < CoreManager.getNumberCoreImplementations((int)coreId); ++implId) {
                if (slotReductionImpls[coreId][implId] <= slotReductionCores[coreId]) continue;
                slotReductionCores[coreId] = slotReductionImpls[coreId][implId];
            }
        }
        int[] slots = new int[coreCount];
        for (DynamicMethodWorker r : this.criticalSet.values()) {
            int[] resSlots = r.getSimultaneousTasks();
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                int n = coreId;
                slots[n] = slots[n] + resSlots[coreId];
            }
        }
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (slotReductionCores[coreId] <= 0 || slotReductionCores[coreId] < slots[coreId]) continue;
            return false;
        }
        return true;
    }

    public String getCurrentState(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("RESOURCES = [").append("\n");
        for (Worker<? extends WorkerResourceDescription> worker : this.staticSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(worker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Static").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        for (DynamicMethodWorker dynamicMethodWorker : this.criticalSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(dynamicMethodWorker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Critical").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        for (DynamicMethodWorker dynamicMethodWorker : this.nonCriticalSet.values()) {
            sb.append(prefix).append("\t").append("RESOURCE = [").append("\n");
            sb.append(dynamicMethodWorker.getResourceLinks(prefix + "\t\t"));
            sb.append(prefix).append("\t").append("\t").append("SET = Non-Critical").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }
}

