/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.rocci;

import es.bsc.conn.Connector;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.rocci.RocciClient;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.Processor;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ROCCI
extends Connector {
    private static final String ROCCI_CLIENT_VERSION = "4.2.5";
    private static final String PROP_AUTH = "auth";
    private static final String PROP_TIMEOUT = "timeout";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSW = "password";
    private static final String PROP_TOKEN = "token";
    private static final String PROP_CA_PATH = "ca-path";
    private static final String PROP_CA_FILE = "ca-file";
    private static final String PROP_SKIP_CA_CHECK = "skip-ca-check";
    private static final String PROP_FILTER = "filter";
    private static final String PROP_USER_CREDENTIALS = "user-cred";
    private static final String PROP_VOMS = "voms";
    private static final String PROP_MEDIA_TYPE = "media-type";
    private static final String PROP_RESOURCE = "resource";
    private static final String PROP_ATTRIBUTES = "attributes";
    private static final String PROP_CONTEXT = "context";
    private static final String PROP_ACTION = "action";
    private static final String PROP_MIXIN = "mixin";
    private static final String PROP_LINK = "link";
    private static final String PROP_LINK2 = "link2";
    private static final String PROP_TRIGGER_ACTION = "trigger-action";
    private static final String PROP_LOG = "log-to";
    private static final String PROP_DUMP_MODEL = "dump-model";
    private static final String PROP_DEBUG = "debug";
    private static final String PROP_VERBOSE = "verbose";
    private static final String PROP_ATTR_OWNER = "owner";
    private static final String PROP_ATTR_JOBNAME = "jobname";
    private static final String PROP_NET_PREFIX = "network-prefix";
    private static final String ROCCI_PROP_SERVER = "--endpoint ";
    private static final String ROCCI_PROP_AUTH = "--auth ";
    private static final String ROCCI_PROP_TIMEOUT = "--timeout ";
    private static final String ROCCI_PROP_USERNAME = "--username ";
    private static final String ROCCI_PROP_PASSW = "--password ";
    private static final String ROCCI_PROP_TOKEN = "--token";
    private static final String ROCCI_PROP_CA_PATH = "--ca-path ";
    private static final String ROCCI_PROP_CA_FILE = "--ca-file ";
    private static final String ROCCI_PROP_SKIP_CA_CHECK = "--skip-ca-check ";
    private static final String ROCCI_PROP_FILTER = "--filter ";
    private static final String ROCCI_PROP_USER_CREDENTIALS = "--user-cred ";
    private static final String ROCCI_PROP_VOMS = "--voms";
    private static final String ROCCI_PROP_MEDIA_TYPE = "--media-type ";
    private static final String ROCCI_PROP_RESOURCE = "--resource ";
    private static final String ROCCI_PROP_ATTRIBUTES = "--attributes ";
    private static final String ROCCI_PROP_CONTEXT = "--context ";
    private static final String ROCCI_PROP_ACTION = "--action ";
    private static final String ROCCI_PROP_MIXIN = "--mixin ";
    private static final String ROCCI_PROP_LINK = "--link ";
    private static final String ROCCI_PROP_TRIGGER_ACTION = "--trigger-action ";
    private static final String ROCCI_PROP_LOG = "--log-to ";
    private static final String ROCCI_PROP_DUMP_MODEL = "--dump-model";
    private static final String ROCCI_PROP_DEBUG = "--debug";
    private static final String ROCCI_PROP_VERBOSE = "--verbose";
    private static final String ROCCI_PROP_OUTPUT_FORMAT = "--output-format json_extended_pretty";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.Rocci");
    private static final Integer RETRY_TIME = 5;
    private final RocciClient client;
    private final Map<String, HardwareDescription> vmidToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> vmidToSoftwareRequest = new HashMap<String, SoftwareDescription>();
    private String netPrefix;

    public ROCCI(Map<String, String> props) throws ConnException {
        super(props);
        String propVerbose;
        String propDebug;
        String propDumpModel;
        String propLog;
        String propTriggerAction;
        String propLink2;
        String propLink;
        String propMixin;
        String propAction;
        String propContext;
        String propAttributes;
        String propResource;
        String propMediaType;
        String propVoms;
        String propUserCred;
        String propFilter;
        String propSkipCACheck;
        String propCAFile;
        String propCAPath;
        String propToken;
        String propPassword;
        String propUsername;
        String propTimeout;
        String propAuth;
        LOGGER.info("Starting ROCCI v4.2.5");
        ArrayList<String> cmdString = new ArrayList<String>();
        if (this.server != null) {
            cmdString.add(ROCCI_PROP_SERVER + this.server);
        }
        if ((propAuth = props.get(PROP_AUTH)) != null) {
            cmdString.add(ROCCI_PROP_AUTH + propAuth);
        }
        if ((propTimeout = props.get(PROP_TIMEOUT)) != null) {
            cmdString.add(ROCCI_PROP_TIMEOUT + propTimeout);
        }
        if ((propUsername = props.get(PROP_USERNAME)) != null) {
            cmdString.add(ROCCI_PROP_USERNAME + propUsername);
        }
        if ((propPassword = props.get(PROP_PASSW)) != null) {
            cmdString.add(ROCCI_PROP_PASSW + propPassword);
        }
        if ((propToken = props.get(PROP_TOKEN)) != null) {
            cmdString.add(ROCCI_PROP_TOKEN + propToken);
        }
        if ((propCAPath = props.get(PROP_CA_PATH)) != null) {
            cmdString.add(ROCCI_PROP_CA_PATH + propCAPath);
        }
        if ((propCAFile = props.get(PROP_CA_FILE)) != null) {
            cmdString.add(ROCCI_PROP_CA_FILE + propCAFile);
        }
        if ((propSkipCACheck = props.get(PROP_SKIP_CA_CHECK)) != null) {
            cmdString.add(ROCCI_PROP_SKIP_CA_CHECK + propSkipCACheck);
        }
        if ((propFilter = props.get(PROP_FILTER)) != null) {
            cmdString.add(ROCCI_PROP_FILTER + propFilter);
        }
        if ((propUserCred = props.get(PROP_USER_CREDENTIALS)) != null) {
            cmdString.add(ROCCI_PROP_USER_CREDENTIALS + propUserCred);
        }
        if ((propVoms = props.get(PROP_VOMS)) != null) {
            cmdString.add(ROCCI_PROP_VOMS + propVoms);
        }
        if ((propMediaType = props.get(PROP_MEDIA_TYPE)) != null) {
            cmdString.add(ROCCI_PROP_MEDIA_TYPE + propMediaType);
        }
        if ((propResource = props.get(PROP_RESOURCE)) != null) {
            cmdString.add(ROCCI_PROP_RESOURCE + propResource);
        }
        if ((propAttributes = props.get(PROP_ATTRIBUTES)) != null) {
            cmdString.add(ROCCI_PROP_ATTRIBUTES + propAttributes);
        }
        if ((propContext = props.get(PROP_CONTEXT)) != null) {
            cmdString.add(ROCCI_PROP_CONTEXT + propContext);
        }
        if ((propAction = props.get(PROP_ACTION)) != null) {
            cmdString.add(ROCCI_PROP_ACTION + propAction);
        }
        if ((propMixin = props.get(PROP_MIXIN)) != null) {
            cmdString.add(ROCCI_PROP_MIXIN + propMixin);
        }
        if ((propLink = props.get(PROP_LINK)) != null) {
            cmdString.add(ROCCI_PROP_LINK + propLink);
        }
        if ((propLink2 = props.get(PROP_LINK2)) != null) {
            cmdString.add(ROCCI_PROP_LINK + propLink2);
        }
        if ((propTriggerAction = props.get(PROP_TRIGGER_ACTION)) != null) {
            cmdString.add(ROCCI_PROP_TRIGGER_ACTION + propTriggerAction);
        }
        if ((propLog = props.get(PROP_LOG)) != null) {
            cmdString.add(ROCCI_PROP_LOG + propLog);
        }
        if ((propDumpModel = props.get(PROP_DUMP_MODEL)) != null) {
            cmdString.add(ROCCI_PROP_DUMP_MODEL);
        }
        if ((propDebug = props.get(PROP_DEBUG)) != null) {
            cmdString.add(ROCCI_PROP_DEBUG);
        }
        String propPrefix = props.get(PROP_NET_PREFIX);
        if (props.get(PROP_NET_PREFIX) != null) {
            this.netPrefix = propPrefix;
        }
        if ((propVerbose = props.get(PROP_VERBOSE)) != null) {
            cmdString.add(ROCCI_PROP_VERBOSE);
        }
        cmdString.add(ROCCI_PROP_OUTPUT_FORMAT);
        String owner = props.get(PROP_ATTR_OWNER);
        String jobName = props.get(PROP_ATTR_JOBNAME);
        String attributes = "";
        if (owner != null && jobName != null) {
            attributes = owner + "-" + jobName;
        }
        LOGGER.debug("cmdString : " + cmdString);
        LOGGER.debug("attributes: " + attributes);
        this.client = new RocciClient(cmdString, attributes);
    }

    @Override
    public Object create(String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        try {
            String instanceCode = hd.getType();
            String vmId = this.client.createCompute(hd.getImageName(), instanceCode);
            this.vmidToHardwareRequest.put(vmId, hd);
            this.vmidToSoftwareRequest.put(vmId, sd);
            VirtualResource vr = new VirtualResource(vmId, hd, sd, prop);
            return vr.getId();
        }
        catch (ConnClientException e) {
            LOGGER.error("Error creating a VM", (Throwable)e);
            throw new ConnException("Error creating a VM", e);
        }
    }

    @Override
    public Object[] createMultiple(int replicas, String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        Object[] envIds = new Object[replicas];
        for (int i = 0; i < replicas; ++i) {
            envIds[i] = this.create(requestName, hd, sd, prop, starterCMD);
        }
        return envIds;
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        LOGGER.debug("Waiting for creation " + id);
        String vmId = (String)id;
        LOGGER.info("Waiting until VM " + vmId + " is created");
        Integer polls = 0;
        int errors = 0;
        String status = null;
        do {
            try {
                Thread.sleep((long)RETRY_TIME.intValue() * 1000L);
                if ((long)(RETRY_TIME * polls) >= this.maxVMCreationTime * 60L) {
                    throw new ConnException("Maximum VM creation time reached.");
                }
                Integer n = polls;
                Integer n2 = polls = Integer.valueOf(polls + 1);
                status = this.client.getResourceStatus(vmId);
            }
            catch (ConnClientException | ConnException | InterruptedException e) {
                if (++errors != this.maxVMConnectionErrors) continue;
                LOGGER.error("ERROR_MSG = [\n\tError = " + e.getMessage() + "\n]");
                throw new ConnException("Error getting the status of the request", e);
            }
        } while (status == null || !"active".equals(status));
        String[] ips = null;
        try {
            ips = this.client.getResourceAddress(vmId);
        }
        catch (ConnClientException cce) {
            throw new ConnException("Error retrieving resource address from client", cce);
        }
        String localIp = null;
        if (ips != null) {
            if (this.netPrefix != null) {
                for (String s : ips) {
                    if (!s.startsWith(this.netPrefix)) continue;
                    localIp = s;
                    break;
                }
            } else {
                localIp = ips[0];
            }
        }
        if (localIp == null) {
            throw new ConnException("Unable to get resource address from client");
        }
        VirtualResource vr = new VirtualResource();
        vr.setId(vmId);
        vr.setIp(localIp);
        vr.setProperties(null);
        HardwareDescription hd = this.vmidToHardwareRequest.get(vmId);
        if (hd == null) {
            throw new ConnException("Unregistered hardware description for vmId = " + vmId);
        }
        try {
            this.getHardwareInformation(vmId, hd);
        }
        catch (ConnClientException cce) {
            throw new ConnException("Error retrieving resource hardware description of VM " + vmId + " from client", cce);
        }
        vr.setHd(hd);
        SoftwareDescription sd = this.vmidToSoftwareRequest.get(vmId);
        if (sd == null) {
            throw new ConnException("Unregistered software description for vmId = " + vmId);
        }
        sd.setOperatingSystemType("Linux");
        vr.setSd(sd);
        return vr;
    }

    @Override
    public void destroy(Object id) {
        String vmId = (String)id;
        LOGGER.info(" Destroy VM " + vmId + " with rOCCI connector");
        this.client.deleteCompute(vmId);
        this.vmidToHardwareRequest.remove(vmId);
        this.vmidToSoftwareRequest.remove(vmId);
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
    }

    public void attachLink(String vmId, String link) {
        LOGGER.info(" Attach link " + link + " to VM " + vmId + " with rOCCI connector");
        this.client.attachLink(vmId, link);
    }

    private void getHardwareInformation(String vmId, HardwareDescription hd) throws ConnClientException {
        Object[] grantedHD = this.client.getHardwareDescription(vmId);
        Float memory = (Float)grantedHD[0];
        Float storage = (Float)grantedHD[1];
        Integer cores = (Integer)grantedHD[2];
        String architecture = (String)grantedHD[3];
        Float speed = (Float)grantedHD[4];
        if (cores == null || cores < 0) {
            cores = 1;
        }
        Processor runtimeProc = new Processor();
        runtimeProc.setComputingUnits(cores);
        if (architecture != null && !architecture.isEmpty()) {
            runtimeProc.setArchitecture(architecture);
        }
        if (speed != null) {
            runtimeProc.setSpeed(speed.floatValue());
        }
        ArrayList<Processor> procs = new ArrayList<Processor>();
        procs.add(runtimeProc);
        if (memory != null) {
            hd.setMemorySize(memory.floatValue());
        }
        if (storage != null) {
            hd.setStorageSize(storage.floatValue());
        }
        hd.setProcessors(procs);
        hd.setTotalComputingUnits(cores);
    }
}

